/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.OneLineMarginBorder;

public class RoundedCornerMarginBorder
extends OneLineMarginBorder {
    private final Dimension corner = new Dimension(0, 0);

    public RoundedCornerMarginBorder(int position) {
        super(position);
    }

    @Override
    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        int hRadius = this.corner.width / 2;
        int vRadius = this.corner.height / 2;
        Insets cornerAwareInsets = insets;
        switch (this.getPosition()) {
            case 8: 
            case 32: {
                cornerAwareInsets = insets.getAdded(new Insets(0, hRadius, 0, hRadius));
                break;
            }
            case 1: 
            case 4: {
                cornerAwareInsets = insets.getAdded(new Insets(vRadius, 0, vRadius, 0));
                break;
            }
        }
        super.paint(figure, graphics, cornerAwareInsets);
        int one = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(1);
        int widthInDP = this.getWidth() / one;
        int halfWidthInLP = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(widthInDP / 2);
        if (!this.corner.isEmpty()) {
            switch (this.getPosition()) {
                case 8: {
                    RoundedCornerMarginBorder.tempRect.x += halfWidthInLP;
                    RoundedCornerMarginBorder.tempRect.width -= this.getWidth();
                    graphics.drawArc(RoundedCornerMarginBorder.tempRect.getTopRight().x - hRadius, RoundedCornerMarginBorder.tempRect.getTopRight().y, this.corner.width, this.corner.height, 5, 85);
                    graphics.drawArc(RoundedCornerMarginBorder.tempRect.getTopLeft().x - hRadius, RoundedCornerMarginBorder.tempRect.getTopLeft().y, this.corner.width, this.corner.height, 90, 85);
                    break;
                }
                case 32: {
                    RoundedCornerMarginBorder.tempRect.x += halfWidthInLP;
                    RoundedCornerMarginBorder.tempRect.width -= this.getWidth();
                    graphics.drawArc(RoundedCornerMarginBorder.tempRect.getBottomLeft().x - hRadius, RoundedCornerMarginBorder.tempRect.getBottomLeft().y - this.corner.height, this.corner.width, this.corner.height, 185, 85);
                    graphics.drawArc(RoundedCornerMarginBorder.tempRect.getBottomRight().x - hRadius, RoundedCornerMarginBorder.tempRect.getBottomRight().y - this.corner.height, this.corner.width, this.corner.height, 270, 85);
                    break;
                }
                case 1: {
                    RoundedCornerMarginBorder.tempRect.y += halfWidthInLP;
                    RoundedCornerMarginBorder.tempRect.height -= this.getWidth();
                    graphics.drawArc(RoundedCornerMarginBorder.tempRect.getTopLeft().x, RoundedCornerMarginBorder.tempRect.getTopLeft().y - vRadius, this.corner.width, this.corner.height, 95, 85);
                    graphics.drawArc(RoundedCornerMarginBorder.tempRect.getBottomLeft().x, RoundedCornerMarginBorder.tempRect.getBottomLeft().y - vRadius, this.corner.width, this.corner.height, 180, 85);
                    break;
                }
                case 4: {
                    RoundedCornerMarginBorder.tempRect.y += halfWidthInLP;
                    RoundedCornerMarginBorder.tempRect.height -= this.getWidth();
                    graphics.drawArc(RoundedCornerMarginBorder.tempRect.getTopRight().x - this.corner.width, RoundedCornerMarginBorder.tempRect.getTopRight().y - vRadius, this.corner.width, this.corner.height, 0, 85);
                    graphics.drawArc(RoundedCornerMarginBorder.tempRect.getBottomRight().x - this.corner.width, RoundedCornerMarginBorder.tempRect.getBottomRight().y - vRadius, this.corner.width, this.corner.height, 270, 85);
                    break;
                }
            }
        }
    }

    public void setCornerDimensions(Dimension d) {
        if (d == null) {
            this.corner.width = 0;
            this.corner.height = 0;
        } else {
            this.corner.width = d.width;
            this.corner.height = d.height;
        }
    }
}

