/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otre;

import java.lang.reflect.Field;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.POP;
import org.apache.bcel.generic.Type;
import org.eclipse.objectteams.otre.ClassLoaderAccess;
import org.eclipse.objectteams.otre.ObjectTeamsTransformation;
import org.eclipse.objectteams.otre.jplis.JPLISEnhancer;
import org.objectteams.Team;

public class LiftingParticipantTransformation
extends ObjectTeamsTransformation {
    private static String PARTICIPANT_NAME = System.getProperty("ot.lifting.participant");
    private static boolean checked = false;
    private static final String LIFT_PREFIX = "_OT$liftTo";
    private static final String WRONG_ROLE_EXCEPTION = "org.objectteams.WrongRoleException";
    private static final String LIFTING_FAILED_EXCEPTION = "org.objectteams.LiftingFailedException";
    private static final String LIFTING_VETO_EXCEPTION = "org.objectteams.LiftingVetoException";
    private static final ObjectType iLiftingParticipant = new ObjectType("org.objectteams.ILiftingParticipant");
    private static final String CREATE_ROLE_METHOD = "createRole";
    private static final String LIFTING_PARTICIPANT_FIELD = "_OT$liftingParticipant";

    public LiftingParticipantTransformation(Object loader) {
        super(loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTransformCode(ClassGen cg) {
        if (!LiftingParticipantTransformation.classNeedsTeamExtensions(cg)) {
            return;
        }
        Class<LiftingParticipantTransformation> clazz = LiftingParticipantTransformation.class;
        synchronized (LiftingParticipantTransformation.class) {
            try {
                this.checkInitParticipant();
            }
            catch (Exception e) {
                new IllegalArgumentException("Lifting participant " + PARTICIPANT_NAME + " is invalid.", e).printStackTrace();
                PARTICIPANT_NAME = null;
            }
            if (PARTICIPANT_NAME == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.factory = new InstructionFactory(cg);
            ConstantPoolGen cpg = cg.getConstantPool();
            String class_name = cg.getClassName();
            Method[] methods = cg.getMethods();
            int i = 0;
            while (i < methods.length) {
                Method m = methods[i];
                if (m.getName().startsWith(LIFT_PREFIX)) {
                    Method method = m;
                    m = this.weaveLiftingParticipant(m, class_name, cpg);
                    cg.replaceMethod(method, m);
                    JPLISEnhancer.requireClassFileVersionLessThan51(cg);
                }
                ++i;
            }
            return;
        }
    }

    private void checkInitParticipant() throws Exception {
        if (checked) {
            return;
        }
        checked = true;
        Field participantField = Team.class.getField(LIFTING_PARTICIPANT_FIELD);
        Object participant = participantField.get(null);
        if (PARTICIPANT_NAME != null) {
            if (participant != null) {
                throw new IllegalStateException("liftingParticipant already installed.");
            }
            Class<?> participantClass = ClassLoaderAccess.loadClass(this.loader, PARTICIPANT_NAME);
            participantField.set(null, participantClass.newInstance());
        } else if (participant != null) {
            PARTICIPANT_NAME = participant.getClass().getName();
        }
    }

    private Method weaveLiftingParticipant(Method m, String className, ConstantPoolGen cpg) {
        MethodGen mg = LiftingParticipantTransformation.newMethodGen(m, className, cpg);
        InstructionList il = mg.getInstructionList();
        InstructionHandle[] ihs = il.getInstructionHandles();
        int i = 0;
        while (i < ihs.length) {
            NEW newInstr;
            Type newType;
            String newTypeName;
            InstructionHandle ih = ihs[i];
            if (ih.getInstruction() instanceof NEW && !(newTypeName = (newType = (newInstr = (NEW)ih.getInstruction()).getType(cpg)).toString()).equals(LIFTING_FAILED_EXCEPTION) && !newTypeName.equals(LIFTING_VETO_EXCEPTION) && !newTypeName.equals(WRONG_ROLE_EXCEPTION)) {
                ih.setInstruction((Instruction)new NOP());
                InstructionList inset = new InstructionList();
                inset.append((Instruction)this.factory.createFieldAccess(teamClassType.getClassName(), LIFTING_PARTICIPANT_FIELD, (Type)iLiftingParticipant, (short)178));
                inset.append((Instruction)new ALOAD(0));
                inset.append((Instruction)new ALOAD(1));
                inset.append((Instruction)new LDC(cpg.addString(newTypeName)));
                inset.append((Instruction)this.factory.createInvoke(iLiftingParticipant.getClassName(), CREATE_ROLE_METHOD, (Type)object, new Type[]{teamType, object, string}, (short)185));
                inset.append((Instruction)new DUP());
                IFNULL isNull = new IFNULL(null);
                inset.append((BranchInstruction)isNull);
                inset.append(this.factory.createCast((Type)object, newType));
                int invokeOffset = 4;
                if (!(ihs[i + invokeOffset].getInstruction() instanceof INVOKESPECIAL)) {
                    ++invokeOffset;
                }
                inset.append((BranchInstruction)new GOTO(ihs[i + invokeOffset + 1]));
                InstructionHandle goOn = inset.append((Instruction)new POP());
                isNull.setTarget(goOn);
                inset.append((Instruction)newInstr);
                il.append(ih, inset);
            }
            ++i;
        }
        return mg.getMethod();
    }
}

