/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.wst.jsdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.HintTextGroup;

public class ResetAllAction
extends BuildpathModifierAction {
    private final HintTextGroup fProvider;
    private final IRunnableContext fContext;
    private IJavaScriptProject fJavaScriptProject;
    private List fEntries;

    public ResetAllAction(HintTextGroup provider, IRunnableContext context, ISetSelectionTarget selectionTarget) {
        super(null, selectionTarget, 6);
        this.fProvider = provider;
        this.fContext = context;
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_CLEAR);
        this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_CLEAR);
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ClearAll_label);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ClearAll_tooltip);
        this.setEnabled(false);
    }

    @Override
    public String getDetailedDescription() {
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_ResetAll;
    }

    public void setBreakPoint(IJavaScriptProject javaProject) {
        this.fJavaScriptProject = javaProject;
        if (this.fJavaScriptProject.exists()) {
            try {
                this.fEntries = ClasspathModifier.getExistingEntries(this.fJavaScriptProject);
            }
            catch (JavaScriptModelException e) {
                JavaScriptPlugin.log(e);
                return;
            }
            this.setEnabled(true);
        } else {
            JavaScriptCore.addElementChangedListener((IElementChangedListener)new IElementChangedListener(){

                public void elementChanged(ElementChangedEvent event) {
                    if (ResetAllAction.this.fJavaScriptProject.exists()) {
                        try {
                            try {
                                ResetAllAction.this.fEntries = ClasspathModifier.getExistingEntries(ResetAllAction.this.fJavaScriptProject);
                            }
                            catch (JavaScriptModelException e) {
                                JavaScriptPlugin.log(e);
                                JavaScriptCore.removeElementChangedListener((IElementChangedListener)this);
                                return;
                            }
                        }
                        finally {
                            JavaScriptCore.removeElementChangedListener((IElementChangedListener)this);
                        }
                        ResetAllAction.this.setEnabled(true);
                    }
                }
            }, (int)1);
        }
    }

    public void run() {
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("", 3);
                    try {
                        if (!ResetAllAction.this.hasChange(ResetAllAction.this.fJavaScriptProject)) {
                            return;
                        }
                        try {
                            BuildpathDelta delta = new BuildpathDelta(ResetAllAction.this.getToolTipText());
                            ClasspathModifier.commitClassPath(ResetAllAction.this.fEntries, ResetAllAction.this.fJavaScriptProject, monitor);
                            delta.setNewEntries(ResetAllAction.this.fEntries.toArray(new CPListElement[ResetAllAction.this.fEntries.size()]));
                            for (IResource resource : ResetAllAction.this.fProvider.getCreatedResources()) {
                                resource.delete(false, null);
                                delta.addDeletedResource(resource);
                            }
                            ResetAllAction.this.fProvider.resetCreatedResources();
                            ResetAllAction.this.informListeners(delta);
                            ResetAllAction.this.selectAndReveal((ISelection)new StructuredSelection((Object)ResetAllAction.this.fJavaScriptProject));
                        }
                        catch (JavaScriptModelException e) {
                            ResetAllAction.this.showExceptionDialog((CoreException)((Object)e), NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ClearAll_tooltip);
                        }
                        catch (CoreException e) {
                            ResetAllAction.this.showExceptionDialog(e, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ClearAll_tooltip);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            this.fContext.run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)e.getCause(), NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ClearAll_tooltip);
            } else {
                JavaScriptPlugin.log(e);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    protected boolean canHandle(IStructuredSelection elements) {
        return this.fJavaScriptProject != null;
    }

    private boolean hasChange(IJavaScriptProject project) throws JavaScriptModelException {
        IIncludePathEntry[] currentEntries = project.getRawIncludepath();
        if (currentEntries.length != this.fEntries.size()) {
            return true;
        }
        int i = 0;
        for (CPListElement oldEntrie : this.fEntries) {
            if (!oldEntrie.getClasspathEntry().equals(currentEntries[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

