/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.java.IdentifierType;
import org.eclipse.wst.jsdt.internal.ui.text.java.ScopedCodeAssistVisitor;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;

public class IdentifierProposal
implements IJavaCompletionProposal,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposalExtension4 {
    private IRegion fRegion;
    private List<IdentifierProposal> fields = new ArrayList<IdentifierProposal>();
    private IdentifierType type;
    private List<String> parameterNames = new ArrayList<String>();
    private String name;
    private boolean isGlobal = false;
    private IdentifierProposal parent;

    public IdentifierProposal(String name) {
        this.name = name;
    }

    public void setRegion(IRegion fRegion) {
        this.fRegion = fRegion;
    }

    public void apply(IDocument document) {
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fRegion.getOffset() + this.name.length(), 0);
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        if (this.isGlobal) {
            return String.format("%s - Global", this.getProposalString());
        }
        return this.getProposalString();
    }

    public String getProposalString() {
        if (this.type == IdentifierType.FUNCTION) {
            return String.valueOf(this.name) + String.format("(%s)", this.getParameterString());
        }
        return this.name;
    }

    public Image getImage() {
        if (this.type == IdentifierType.FUNCTION) {
            return JavaPluginImages.get("org.eclipse.wst.jsdt.ui.methpub_obj.gif");
        }
        return JavaPluginImages.get("org.eclipse.wst.jsdt.ui.field_public_obj.gif");
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public boolean isAutoInsertable() {
        return false;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return null;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return null;
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return 0;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        try {
            document.replace(this.fRegion.getOffset(), offset - this.fRegion.getOffset(), this.getProposalString());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    private String getParameterString() {
        if (this.parameterNames.isEmpty()) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (String param : this.parameterNames) {
            str.append(String.valueOf(param) + ", ");
        }
        return str.substring(0, str.length() - 2);
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        return false;
    }

    @Override
    public int getRelevance() {
        return 1;
    }

    public void addField(IdentifierProposal field) {
        this.fields.add(field);
    }

    public String getName() {
        return this.name;
    }

    public List<IdentifierProposal> getFields() {
        return this.fields;
    }

    public void setType(IdentifierType type) {
        this.type = type;
    }

    public void setParameters(List<String> parameterNames) {
        this.parameterNames = parameterNames;
    }

    public void setJSdoc(JSdoc jsdoc) {
    }

    public void updateScope(Stack<ScopedCodeAssistVisitor.Scope> scopes) {
        this.isGlobal = scopes.size() == 1;
    }

    public void addParent(IdentifierProposal parent) {
        this.parent = parent;
    }

    public IdentifierProposal getParent() {
        return this.parent;
    }

    public void setIsGlobal(boolean b) {
        this.isGlobal = b;
    }

    public String getCamelCaseName() {
        return String.valueOf(this.getName().charAt(0)) + this.getCaptialLetters(this.getName().substring(1));
    }

    private String getCaptialLetters(String s) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            if (Character.isUpperCase(s.charAt(i))) {
                sb.append(s.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }
}

