/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.CharacterLiteral;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.RegularExpressionLiteral;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.SemanticHighlighting;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.SemanticHighlightingManager;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.SemanticHighlightingPresenter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.SemanticToken;
import org.eclipse.wst.jsdt.internal.ui.text.java.IJavaReconcilingListener;

public class SemanticHighlightingReconciler
implements IJavaReconcilingListener,
ITextInputListener {
    private PositionCollector fCollector = new PositionCollector();
    private JavaEditor fEditor;
    private ISourceViewer fSourceViewer;
    private SemanticHighlightingPresenter fPresenter;
    private SemanticHighlighting[] fSemanticHighlightings;
    private SemanticHighlightingManager.Highlighting[] fHighlightings;
    private List fAddedPositions = new ArrayList();
    private List fRemovedPositions = new ArrayList();
    private int fNOfRemovedPositions;
    private Job fJob;
    private final Object fJobLock = new Object();
    private final Object fReconcileLock = new Object();
    private boolean fIsReconciling = false;
    private SemanticHighlightingPresenter fJobPresenter;
    private SemanticHighlighting[] fJobSemanticHighlightings;
    private SemanticHighlightingManager.Highlighting[] fJobHighlightings;

    @Override
    public void aboutToBeReconciled() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconciled(JavaScriptUnit ast, boolean forced, IProgressMonitor progressMonitor) {
        ASTNode[] subtrees;
        block29: {
            block28: {
                block27: {
                    Object object;
                    Object object2 = this.fReconcileLock;
                    synchronized (object2) {
                        if (this.fIsReconciling) {
                            return;
                        }
                        this.fIsReconciling = true;
                    }
                    this.fJobPresenter = this.fPresenter;
                    this.fJobSemanticHighlightings = this.fSemanticHighlightings;
                    this.fJobHighlightings = this.fHighlightings;
                    try {
                        if (this.fJobPresenter != null && this.fJobSemanticHighlightings != null && this.fJobHighlightings != null) break block27;
                        this.fJobPresenter = null;
                        this.fJobSemanticHighlightings = null;
                        this.fJobHighlightings = null;
                        object = this.fReconcileLock;
                    }
                    catch (Throwable throwable) {
                        this.fJobPresenter = null;
                        this.fJobSemanticHighlightings = null;
                        this.fJobHighlightings = null;
                        Object object3 = this.fReconcileLock;
                        synchronized (object3) {
                            this.fIsReconciling = false;
                        }
                        throw throwable;
                    }
                    synchronized (object) {
                        this.fIsReconciling = false;
                    }
                    return;
                }
                this.fJobPresenter.setCanceled(progressMonitor.isCanceled());
                if (ast != null && !this.fJobPresenter.isCanceled()) break block28;
                this.fJobPresenter = null;
                this.fJobSemanticHighlightings = null;
                this.fJobHighlightings = null;
                Object object = this.fReconcileLock;
                synchronized (object) {
                    this.fIsReconciling = false;
                }
                return;
            }
            subtrees = this.getAffectedSubtrees((ASTNode)ast);
            if (subtrees.length != 0) break block29;
            this.fJobPresenter = null;
            this.fJobSemanticHighlightings = null;
            this.fJobHighlightings = null;
            Object object = this.fReconcileLock;
            synchronized (object) {
                this.fIsReconciling = false;
            }
            return;
        }
        this.startReconcilingPositions();
        if (!this.fJobPresenter.isCanceled()) {
            this.reconcilePositions(subtrees);
        }
        TextPresentation textPresentation = null;
        if (!this.fJobPresenter.isCanceled()) {
            textPresentation = this.fJobPresenter.createPresentation(this.fAddedPositions, this.fRemovedPositions);
        }
        if (!this.fJobPresenter.isCanceled()) {
            this.updatePresentation(textPresentation, this.fAddedPositions, this.fRemovedPositions);
        }
        this.stopReconcilingPositions();
        this.fJobPresenter = null;
        this.fJobSemanticHighlightings = null;
        this.fJobHighlightings = null;
        Object object = this.fReconcileLock;
        synchronized (object) {
            this.fIsReconciling = false;
        }
    }

    private ASTNode[] getAffectedSubtrees(ASTNode node) {
        return new ASTNode[]{node};
    }

    private void startReconcilingPositions() {
        this.fJobPresenter.addAllPositions(this.fRemovedPositions);
        this.fNOfRemovedPositions = this.fRemovedPositions.size();
    }

    private void reconcilePositions(ASTNode[] subtrees) {
        int i = 0;
        int n = subtrees.length;
        while (i < n) {
            subtrees[i].accept((ASTVisitor)this.fCollector);
            ++i;
        }
        List oldPositions = this.fRemovedPositions;
        ArrayList newPositions = new ArrayList(this.fNOfRemovedPositions);
        int i2 = 0;
        int n2 = oldPositions.size();
        while (i2 < n2) {
            Object current = oldPositions.get(i2);
            if (current != null) {
                newPositions.add(current);
            }
            ++i2;
        }
        this.fRemovedPositions = newPositions;
    }

    private void updatePresentation(TextPresentation textPresentation, List addedPositions, List removedPositions) {
        Runnable runnable = this.fJobPresenter.createUpdateRunnable(textPresentation, addedPositions, removedPositions);
        if (runnable == null) {
            return;
        }
        JavaEditor editor = this.fEditor;
        if (editor == null) {
            return;
        }
        IWorkbenchPartSite site = editor.getSite();
        if (site == null) {
            return;
        }
        Shell shell = site.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Display display = shell.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(runnable);
    }

    private void stopReconcilingPositions() {
        this.fRemovedPositions.clear();
        this.fNOfRemovedPositions = 0;
        this.fAddedPositions.clear();
    }

    public void install(JavaEditor editor, ISourceViewer sourceViewer, SemanticHighlightingPresenter presenter, SemanticHighlighting[] semanticHighlightings, SemanticHighlightingManager.Highlighting[] highlightings) {
        this.fPresenter = presenter;
        this.fSemanticHighlightings = semanticHighlightings;
        this.fHighlightings = highlightings;
        this.fEditor = editor;
        this.fSourceViewer = sourceViewer;
        if (this.fEditor instanceof CompilationUnitEditor) {
            ((CompilationUnitEditor)this.fEditor).addReconcileListener(this);
        } else if (this.fEditor == null) {
            this.fSourceViewer.addTextInputListener((ITextInputListener)this);
            this.scheduleJob();
        }
    }

    public void uninstall() {
        if (this.fPresenter != null) {
            this.fPresenter.setCanceled(true);
        }
        if (this.fEditor != null) {
            if (this.fEditor instanceof CompilationUnitEditor) {
                ((CompilationUnitEditor)this.fEditor).removeReconcileListener(this);
            } else {
                this.fSourceViewer.removeTextInputListener((ITextInputListener)this);
            }
            this.fEditor = null;
        }
        this.fSourceViewer = null;
        this.fSemanticHighlightings = null;
        this.fHighlightings = null;
        this.fPresenter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob() {
        final IJavaScriptElement element = this.fEditor.getInputJavaElement();
        Object object = this.fJobLock;
        synchronized (object) {
            final Job oldJob = this.fJob;
            if (this.fJob != null) {
                this.fJob.cancel();
                this.fJob = null;
            }
            if (element != null) {
                this.fJob = new Job(JavaEditorMessages.SemanticHighlighting_job){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected IStatus run(IProgressMonitor monitor) {
                        if (oldJob != null) {
                            try {
                                oldJob.join();
                            }
                            catch (InterruptedException e) {
                                JavaScriptPlugin.log(e);
                                return Status.CANCEL_STATUS;
                            }
                        }
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        JavaScriptUnit ast = JavaScriptPlugin.getDefault().getASTProvider().getAST(element, ASTProvider.WAIT_YES, monitor);
                        SemanticHighlightingReconciler.this.reconciled(ast, false, monitor);
                        Object object = SemanticHighlightingReconciler.this.fJobLock;
                        synchronized (object) {
                            if (SemanticHighlightingReconciler.this.fJob == this) {
                                SemanticHighlightingReconciler.this.fJob = null;
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                this.fJob.setSystem(true);
                this.fJob.setPriority(50);
                this.fJob.schedule();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        Object object = this.fJobLock;
        synchronized (object) {
            if (this.fJob != null) {
                this.fJob.cancel();
                this.fJob = null;
            }
        }
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (newInput != null) {
            this.scheduleJob();
        }
    }

    public void refresh() {
        this.scheduleJob();
    }

    private class PositionCollector
    extends GenericVisitor {
        private SemanticToken fToken = new SemanticToken();

        private PositionCollector() {
        }

        @Override
        protected boolean visitNode(ASTNode node) {
            if ((node.getFlags() & 1) == 1) {
                this.retainPositions(node.getStartPosition(), node.getLength());
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(BooleanLiteral node) {
            return this.visitLiteral((Expression)node);
        }

        @Override
        public boolean visit(CharacterLiteral node) {
            return this.visitLiteral((Expression)node);
        }

        @Override
        public boolean visit(RegularExpressionLiteral node) {
            return this.visitLiteral((Expression)node);
        }

        @Override
        public boolean visit(NumberLiteral node) {
            return this.visitLiteral((Expression)node);
        }

        private boolean visitLiteral(Expression node) {
            this.fToken.update(node);
            int i = 0;
            int n = SemanticHighlightingReconciler.this.fJobSemanticHighlightings.length;
            while (i < n) {
                SemanticHighlighting semanticHighlighting = SemanticHighlightingReconciler.this.fJobSemanticHighlightings[i];
                if (SemanticHighlightingReconciler.this.fJobHighlightings[i].isEnabled() && semanticHighlighting.consumesLiteral(this.fToken)) {
                    int offset = node.getStartPosition();
                    int length = node.getLength();
                    if (offset <= -1 || length <= 0) break;
                    this.addPosition(offset, length, SemanticHighlightingReconciler.this.fJobHighlightings[i]);
                    break;
                }
                ++i;
            }
            this.fToken.clear();
            return false;
        }

        @Override
        public boolean visit(SimpleName node) {
            this.fToken.update(node);
            int i = 0;
            int n = SemanticHighlightingReconciler.this.fJobSemanticHighlightings.length;
            while (i < n) {
                SemanticHighlighting semanticHighlighting = SemanticHighlightingReconciler.this.fJobSemanticHighlightings[i];
                if (SemanticHighlightingReconciler.this.fJobHighlightings[i].isEnabled() && semanticHighlighting.consumes(this.fToken)) {
                    int offset = node.getStartPosition();
                    int length = node.getLength();
                    if (offset <= -1 || length <= 0) break;
                    this.addPosition(offset, length, SemanticHighlightingReconciler.this.fJobHighlightings[i]);
                    break;
                }
                ++i;
            }
            this.fToken.clear();
            return false;
        }

        private void addPosition(int offset, int length, SemanticHighlightingManager.Highlighting highlighting) {
            boolean isExisting = false;
            int i = 0;
            int n = SemanticHighlightingReconciler.this.fRemovedPositions.size();
            while (i < n) {
                SemanticHighlightingManager.HighlightedPosition position = (SemanticHighlightingManager.HighlightedPosition)((Object)SemanticHighlightingReconciler.this.fRemovedPositions.get(i));
                if (position != null && position.isEqual(offset, length, highlighting)) {
                    isExisting = true;
                    SemanticHighlightingReconciler.this.fRemovedPositions.set(i, null);
                    SemanticHighlightingReconciler semanticHighlightingReconciler = SemanticHighlightingReconciler.this;
                    semanticHighlightingReconciler.fNOfRemovedPositions = semanticHighlightingReconciler.fNOfRemovedPositions - 1;
                    break;
                }
                ++i;
            }
            if (!isExisting) {
                SemanticHighlightingManager.HighlightedPosition position = SemanticHighlightingReconciler.this.fJobPresenter.createHighlightedPosition(offset, length, highlighting);
                SemanticHighlightingReconciler.this.fAddedPositions.add(position);
            }
        }

        private void retainPositions(int offset, int length) {
            int i = 0;
            int n = SemanticHighlightingReconciler.this.fRemovedPositions.size();
            while (i < n) {
                SemanticHighlightingManager.HighlightedPosition position = (SemanticHighlightingManager.HighlightedPosition)((Object)SemanticHighlightingReconciler.this.fRemovedPositions.get(i));
                if (position != null && position.isContained(offset, length)) {
                    SemanticHighlightingReconciler.this.fRemovedPositions.set(i, null);
                    SemanticHighlightingReconciler semanticHighlightingReconciler = SemanticHighlightingReconciler.this;
                    semanticHighlightingReconciler.fNOfRemovedPositions = semanticHighlightingReconciler.fNOfRemovedPositions - 1;
                }
                ++i;
            }
        }
    }
}

