/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEditableContentExtension;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.StructureCreator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.compare.CompareMessages;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaElementHistoryPageSource;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaNode;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaParseTreeBuilder;

public class JavaStructureCreator
extends StructureCreator {
    private Map fDefaultCompilerOptions;

    void setDefaultCompilerOptions(Map compilerSettings) {
        this.fDefaultCompilerOptions = compilerSettings;
    }

    public String getName() {
        return CompareMessages.JavaStructureViewer_title;
    }

    public IStructureComparator getStructure(Object input) {
        String contents = null;
        char[] buffer = null;
        IDocument doc = CompareUI.getDocument((Object)input);
        if (doc == null) {
            if (input instanceof IStreamContentAccessor) {
                IStreamContentAccessor sca = (IStreamContentAccessor)input;
                try {
                    contents = JavaCompareUtilities.readString(sca);
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
            if (contents != null) {
                int n = contents.length();
                buffer = new char[n];
                contents.getChars(0, n, buffer, 0);
                doc = new Document(contents);
                this.setupDocument(doc);
            }
        }
        return this.createStructureComparator(input, buffer, doc, null, null);
    }

    protected IStructureComparator createStructureComparator(Object element, IDocument document, ISharedDocumentAdapter sharedDocumentAdapter, IProgressMonitor monitor) throws CoreException {
        return this.createStructureComparator(element, null, document, sharedDocumentAdapter, monitor);
    }

    private IStructureComparator createStructureComparator(Object input, char[] buffer, IDocument doc, ISharedDocumentAdapter adapter, IProgressMonitor monitor) {
        IJavaScriptProject javaProject;
        IJavaScriptElement element;
        IResource resource;
        Map compilerOptions = null;
        if (input instanceof IResourceProvider && (resource = ((IResourceProvider)input).getResource()) != null && (element = JavaScriptCore.create((IResource)resource)) != null && (javaProject = element.getJavaScriptProject()) != null) {
            compilerOptions = javaProject.getOptions(true);
        }
        if (compilerOptions == null) {
            compilerOptions = this.fDefaultCompilerOptions;
        }
        if (doc != null) {
            boolean isEditable = false;
            if (input instanceof IEditableContent) {
                isEditable = ((IEditableContent)input).isEditable();
            }
            RootJavaNode root = new RootJavaNode(doc, isEditable, input, adapter);
            if (buffer == null) {
                String contents = doc.get();
                int n = contents.length();
                buffer = new char[n];
                contents.getChars(0, n, buffer, 0);
            }
            ASTParser parser = ASTParser.newParser((int)3);
            if (compilerOptions != null) {
                parser.setCompilerOptions(compilerOptions);
            }
            parser.setSource(buffer);
            parser.setFocalPosition(0);
            JavaScriptUnit cu = (JavaScriptUnit)parser.createAST(monitor);
            cu.accept((ASTVisitor)new JavaParseTreeBuilder(root, buffer, true));
            return root;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getContents(Object node, boolean ignoreWhiteSpace) {
        if (!(node instanceof IStreamContentAccessor)) {
            return null;
        }
        sca = (IStreamContentAccessor)node;
        content = null;
        try {
            content = JavaCompareUtilities.readString(sca);
        }
        catch (CoreException ex) {
            JavaScriptPlugin.log(ex);
            return null;
        }
        if (ignoreWhiteSpace == false) return content;
        buf = new StringBuffer();
        b = content.toCharArray();
        scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)false);
        scanner.setSource(b);
        try {
            block7: while (true) lbl-1000:
            // 4 sources

            {
                if ((token = scanner.getNextToken()) == 158) {
                    return buf.toString();
                }
                switch (token) {
                    case 1000: {
                        l = buf.length();
                        if (l <= 0 || buf.charAt(l - 1) == ' ') continue block7;
                        buf.append(' ');
                        ** break;
                    }
                }
                buf.append(scanner.getCurrentTokenSource());
                buf.append(' ');
            }
        }
        catch (InvalidInputException v0) {}
        return content;
    }

    public boolean canRewriteTree() {
        return true;
    }

    public void rewriteTree(Differencer differencer, IDiffContainer root) {
        HashMap<String, RewriteInfo> map = new HashMap<String, RewriteInfo>(10);
        IDiffElement[] children = root.getChildren();
        int i = 0;
        while (i < children.length) {
            DiffNode diff = (DiffNode)children[i];
            JavaNode jn = (JavaNode)diff.getId();
            if (jn != null) {
                int type = jn.getTypeCode();
                if (type == 11 || type == 10) {
                    String name = jn.extractMethodName();
                    RewriteInfo nameInfo = (RewriteInfo)map.get(name);
                    if (nameInfo == null) {
                        nameInfo = new RewriteInfo();
                        map.put(name, nameInfo);
                    }
                    nameInfo.add((IDiffElement)diff);
                    String argList = jn.extractArgumentList();
                    RewriteInfo argInfo = null;
                    if (argList != null && !argList.equals("()")) {
                        argInfo = (RewriteInfo)map.get(argList);
                        if (argInfo == null) {
                            argInfo = new RewriteInfo();
                            map.put(argList, argInfo);
                        }
                        argInfo.add((IDiffElement)diff);
                    }
                    switch (diff.getKind() & 3) {
                        case 1: 
                        case 2: {
                            if (type != 10) {
                                nameInfo.setDiff((ICompareInput)diff);
                            }
                            if (argInfo == null) break;
                            argInfo.setDiff((ICompareInput)diff);
                            break;
                        }
                    }
                }
                this.rewriteTree(differencer, (IDiffContainer)diff);
            }
            ++i;
        }
        for (String name : map.keySet()) {
            DiffNode d;
            RewriteInfo i2 = (RewriteInfo)map.get(name);
            if (!i2.matches() || (d = (DiffNode)differencer.findDifferences(true, null, (Object)root, (Object)i2.fAncestor, (Object)i2.fLeft, (Object)i2.fRight)) == null) continue;
            d.setDontExpand(true);
            for (IDiffElement rd : i2.fChildren) {
                root.removeToRoot(rd);
                d.add(rd);
            }
        }
    }

    static boolean hasEdition(IJavaScriptElement je) {
        return JavaElementHistoryPageSource.hasEdition(je);
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return JavaCompareUtilities.createJavaPartitioner();
    }

    protected String getDocumentPartitioning() {
        return "___java_partitioning";
    }

    protected String[] getPath(Object element, Object input) {
        if (element instanceof IJavaScriptElement) {
            IJavaScriptElement je = (IJavaScriptElement)element;
            ArrayList<String> args = new ArrayList<String>();
            while (je != null) {
                String name = JavaCompareUtilities.getJavaElementID(je);
                if (name == null) {
                    return null;
                }
                args.add(name);
                if (je instanceof IJavaScriptUnit) break;
                je = je.getParent();
            }
            int n = args.size();
            String[] path = new String[n];
            int i = 0;
            while (i < n) {
                path[i] = (String)args.get(n - 1 - i);
                ++i;
            }
            return path;
        }
        return null;
    }

    static class RewriteInfo {
        boolean fIsOut = false;
        JavaNode fAncestor = null;
        JavaNode fLeft = null;
        JavaNode fRight = null;
        ArrayList fChildren = new ArrayList();

        RewriteInfo() {
        }

        void add(IDiffElement diff) {
            this.fChildren.add(diff);
        }

        void setDiff(ICompareInput diff) {
            if (this.fIsOut) {
                return;
            }
            this.fIsOut = true;
            JavaNode a = (JavaNode)diff.getAncestor();
            JavaNode y = (JavaNode)diff.getLeft();
            JavaNode m = (JavaNode)diff.getRight();
            if (a != null) {
                if (this.fAncestor != null) {
                    return;
                }
                this.fAncestor = a;
            }
            if (y != null) {
                if (this.fLeft != null) {
                    return;
                }
                this.fLeft = y;
            }
            if (m != null) {
                if (this.fRight != null) {
                    return;
                }
                this.fRight = m;
            }
            this.fIsOut = false;
        }

        boolean matches() {
            return !this.fIsOut && this.fAncestor != null && this.fLeft != null && this.fRight != null;
        }
    }

    private final class RootJavaNode
    extends JavaNode
    implements IDisposable {
        private final Object fInput;
        private final boolean fEditable;
        private final ISharedDocumentAdapter fAdapter;

        private RootJavaNode(IDocument document, boolean editable, Object input, ISharedDocumentAdapter adapter) {
            super(document);
            this.fEditable = editable;
            this.fInput = input;
            this.fAdapter = adapter;
        }

        public boolean isEditable() {
            return this.fEditable;
        }

        protected void nodeChanged(DocumentRangeNode node) {
            JavaStructureCreator.this.save((IStructureComparator)this, this.fInput);
        }

        public void dispose() {
            if (this.fAdapter != null) {
                this.fAdapter.disconnect(this.fInput);
            }
        }

        public Object getAdapter(Class adapter) {
            if (adapter == ISharedDocumentAdapter.class) {
                return this.fAdapter;
            }
            return super.getAdapter(adapter);
        }

        public boolean isReadOnly() {
            if (this.fInput instanceof IEditableContentExtension) {
                IEditableContentExtension ext = (IEditableContentExtension)this.fInput;
                return ext.isReadOnly();
            }
            return super.isReadOnly();
        }

        public IStatus validateEdit(Shell shell) {
            if (this.fInput instanceof IEditableContentExtension) {
                IEditableContentExtension ext = (IEditableContentExtension)this.fInput;
                return ext.validateEdit(shell);
            }
            return super.validateEdit(shell);
        }
    }
}

