/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IResourceMapper;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.refactoring.IJavaScriptElementMapper;
import org.eclipse.wst.jsdt.core.refactoring.RenameTypeArguments;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaScriptRefactoringDescriptor;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameJavaScriptElementDescriptor;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameResourceDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameTypeProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ISimilarDeclarationUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;

public final class RenameCompilationUnitProcessor
extends JavaRenameProcessor
implements IReferenceUpdating,
ITextUpdating,
IQualifiedNameUpdating,
ISimilarDeclarationUpdating,
IResourceMapper,
IJavaScriptElementMapper {
    private RenameTypeProcessor fRenameTypeProcessor = null;
    private boolean fWillRenameType = false;
    private IJavaScriptUnit fCu;
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.renameCompilationUnitProcessor";

    public RenameCompilationUnitProcessor(IJavaScriptUnit unit) throws CoreException {
        this.fCu = unit;
        if (this.fCu != null) {
            this.computeRenameTypeRefactoring();
            this.setNewElementName(this.fCu.getElementName());
        }
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fCu);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameCompilationUnitRefactoring_name;
    }

    @Override
    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaScriptElement)this.fCu);
    }

    @Override
    public Object[] getElements() {
        return new Object[]{this.fCu};
    }

    @Override
    protected RenameModifications computeRenameModifications() {
        RenameModifications result = new RenameModifications();
        result.rename(this.fCu, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        if (this.fRenameTypeProcessor != null) {
            String newTypeName = RenameCompilationUnitProcessor.removeFileNameExtension(this.getNewElementName());
            RenameTypeArguments arguments = new RenameTypeArguments(newTypeName, this.getUpdateReferences(), this.getUpdateSimilarDeclarations(), this.getSimilarElements());
            result.rename(this.fRenameTypeProcessor.getType(), arguments, this.getUpdateSimilarDeclarations() ? new RenameTypeProcessor.ParticipantDescriptorFilter() : null);
        }
        return result;
    }

    @Override
    protected IFile[] getChangedFiles() throws CoreException {
        IFile file;
        if (!this.fWillRenameType && (file = ResourceUtil.getFile(this.fCu)) != null) {
            return new IFile[]{file};
        }
        return new IFile[0];
    }

    @Override
    public int getSaveMode() {
        return 3;
    }

    @Override
    public String getCurrentElementName() {
        return this.getSimpleCUName();
    }

    @Override
    public String getCurrentElementQualifier() {
        IPackageFragment pack = (IPackageFragment)this.fCu.getParent();
        return pack.getElementName();
    }

    @Override
    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        Assert.isNotNull((Object)newName, (String)"new name");
        String typeName = RenameCompilationUnitProcessor.removeFileNameExtension(newName);
        RefactoringStatus result = Checks.checkCompilationUnitName(newName);
        if (this.fWillRenameType) {
            result.merge(this.fRenameTypeProcessor.checkNewElementName(typeName));
        }
        if (Checks.isAlreadyNamed((IJavaScriptElement)this.fCu, newName)) {
            result.addFatalError(RefactoringCoreMessages.RenameCompilationUnitRefactoring_same_name);
        }
        return result;
    }

    @Override
    public void setNewElementName(String newName) {
        super.setNewElementName(newName);
        if (this.fWillRenameType) {
            this.fRenameTypeProcessor.setNewElementName(RenameCompilationUnitProcessor.removeFileNameExtension(newName));
        }
    }

    @Override
    public Object getNewElement() {
        IJavaScriptElement parent = this.fCu.getParent();
        if (parent.getElementType() != 4) {
            return this.fCu;
        }
        IPackageFragment pack = (IPackageFragment)parent;
        if (JavaScriptConventions.validateCompilationUnitName((String)this.getNewElementName()).getSeverity() == 4) {
            return this.fCu;
        }
        return pack.getJavaScriptUnit(this.getNewElementName());
    }

    @Override
    public boolean canEnableTextUpdating() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableUpdateReferences();
    }

    @Override
    public boolean getUpdateTextualMatches() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateTextualMatches();
    }

    @Override
    public void setUpdateTextualMatches(boolean update) {
        if (this.fRenameTypeProcessor != null) {
            this.fRenameTypeProcessor.setUpdateTextualMatches(update);
        }
    }

    @Override
    public boolean canEnableUpdateReferences() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableUpdateReferences();
    }

    @Override
    public void setUpdateReferences(boolean update) {
        if (this.fRenameTypeProcessor != null) {
            this.fRenameTypeProcessor.setUpdateReferences(update);
        }
    }

    @Override
    public boolean getUpdateReferences() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateReferences();
    }

    @Override
    public boolean canEnableQualifiedNameUpdating() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableQualifiedNameUpdating();
    }

    @Override
    public boolean getUpdateQualifiedNames() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateQualifiedNames();
    }

    @Override
    public void setUpdateQualifiedNames(boolean update) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setUpdateQualifiedNames(update);
    }

    @Override
    public String getFilePatterns() {
        if (this.fRenameTypeProcessor == null) {
            return null;
        }
        return this.fRenameTypeProcessor.getFilePatterns();
    }

    @Override
    public void setFilePatterns(String patterns) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setFilePatterns(patterns);
    }

    @Override
    public boolean canEnableSimilarDeclarationUpdating() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableSimilarDeclarationUpdating();
    }

    @Override
    public void setUpdateSimilarDeclarations(boolean update) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setUpdateSimilarDeclarations(update);
    }

    @Override
    public boolean getUpdateSimilarDeclarations() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateSimilarDeclarations();
    }

    @Override
    public int getMatchStrategy() {
        if (this.fRenameTypeProcessor == null) {
            return 1;
        }
        return this.fRenameTypeProcessor.getMatchStrategy();
    }

    @Override
    public void setMatchStrategy(int selectedStrategy) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setMatchStrategy(selectedStrategy);
    }

    public IJavaScriptElement[] getSimilarElements() {
        if (this.fRenameTypeProcessor == null) {
            return null;
        }
        return this.fRenameTypeProcessor.getSimilarElements();
    }

    public IResource getRefactoredResource(IResource element) {
        if (this.fRenameTypeProcessor == null) {
            return element;
        }
        return this.fRenameTypeProcessor.getRefactoredResource(element);
    }

    public IJavaScriptElement getRefactoredJavaScriptElement(IJavaScriptElement element) {
        if (this.fRenameTypeProcessor == null) {
            return element;
        }
        return this.fRenameTypeProcessor.getRefactoredJavaScriptElement(element);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        if (this.fRenameTypeProcessor != null && !this.fCu.isStructureKnown()) {
            this.fRenameTypeProcessor = null;
            this.fWillRenameType = false;
            return new RefactoringStatus();
        }
        if (this.fWillRenameType && this.fRenameTypeProcessor != null && !this.fRenameTypeProcessor.getType().exists()) {
            this.fRenameTypeProcessor = null;
            this.fWillRenameType = false;
            return new RefactoringStatus();
        }
        return new RefactoringStatus();
    }

    @Override
    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        try {
            if (this.fWillRenameType && !this.fCu.isStructureKnown()) {
                RefactoringStatus result1 = new RefactoringStatus();
                RefactoringStatus result2 = new RefactoringStatus();
                result2.merge(Checks.checkCompilationUnitNewName(this.fCu, this.getNewElementName()));
                if (result2.hasFatalError()) {
                    result1.addError(Messages.format(RefactoringCoreMessages.RenameCompilationUnitRefactoring_not_parsed_1, this.fCu.getElementName()));
                } else {
                    result1.addError(Messages.format(RefactoringCoreMessages.RenameCompilationUnitRefactoring_not_parsed, this.fCu.getElementName()));
                }
                result1.merge(result2);
            }
            if (this.fWillRenameType) {
                RefactoringStatus refactoringStatus = this.fRenameTypeProcessor.checkFinalConditions(pm, context);
                return refactoringStatus;
            }
            RefactoringStatus refactoringStatus = Checks.checkCompilationUnitNewName(this.fCu, this.getNewElementName());
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private void computeRenameTypeRefactoring() throws CoreException {
        this.fRenameTypeProcessor = null;
        this.fWillRenameType = false;
    }

    private IType getTypeWithTheSameName() {
        try {
            IType[] topLevelTypes = this.fCu.getTypes();
            String name = this.getSimpleCUName();
            int i = 0;
            while (i < topLevelTypes.length) {
                if (name.equals(topLevelTypes[i].getElementName())) {
                    return topLevelTypes[i];
                }
                ++i;
            }
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private String getSimpleCUName() {
        return RenameCompilationUnitProcessor.removeFileNameExtension(this.fCu.getElementName());
    }

    private static String removeFileNameExtension(String fileName) {
        if (fileName.lastIndexOf(".") == -1) {
            return fileName;
        }
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        if (this.fWillRenameType) {
            return this.fRenameTypeProcessor.createChange(pm);
        }
        this.fRenameTypeProcessor = null;
        String newName = this.getNewElementName();
        IResource resource = this.fCu.getResource();
        if (resource != null && resource.isLinked()) {
            IProject project = resource.getProject();
            String name = project.getName();
            String description = Messages.format(RefactoringCoreMessages.RenameCompilationUnitChange_descriptor_description_short, resource.getName());
            String header = Messages.format(RefactoringCoreMessages.RenameCompilationUnitChange_descriptor_description, new String[]{resource.getFullPath().toString(), newName});
            String comment = new JDTRefactoringDescriptorComment(name, this, header).asString();
            RenameResourceDescriptor descriptor = new RenameResourceDescriptor();
            descriptor.setProject(name);
            descriptor.setDescription(description);
            descriptor.setComment(comment);
            descriptor.setFlags(2);
            descriptor.setResource(resource);
            descriptor.setNewName(newName);
            return new DynamicValidationStateChange(new RenameResourceChange((RefactoringDescriptor)descriptor, resource, newName, comment));
        }
        String label = null;
        IPackageFragment fragment = (IPackageFragment)this.fCu.getParent();
        label = !fragment.isDefaultPackage() ? String.valueOf(fragment.getElementName()) + "." + this.fCu.getElementName() : this.fCu.getElementName();
        String name = this.fCu.getJavaScriptProject().getElementName();
        String description = Messages.format(RefactoringCoreMessages.RenameCompilationUnitChange_descriptor_description_short, this.fCu.getElementName());
        String header = Messages.format(RefactoringCoreMessages.RenameCompilationUnitChange_descriptor_description, new String[]{label, newName});
        String comment = new JDTRefactoringDescriptorComment(name, this, header).asString();
        RenameJavaScriptElementDescriptor descriptor = new RenameJavaScriptElementDescriptor("org.eclipse.wst.jsdt.ui.rename.compilationunit");
        descriptor.setProject(name);
        descriptor.setDescription(description);
        descriptor.setComment(comment);
        descriptor.setFlags(2);
        descriptor.setJavaElement((IJavaScriptElement)this.fCu);
        descriptor.setNewName(newName);
        return new DynamicValidationRefactoringChange((JavaScriptRefactoringDescriptor)descriptor, RefactoringCoreMessages.RenameCompilationUnitRefactoring_name, new Change[]{new RenameCompilationUnitChange(this.fCu, newName)});
    }

    public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
        if (this.fWillRenameType) {
            return this.fRenameTypeProcessor.postCreateChange(participantChanges, pm);
        }
        return super.postCreateChange(participantChanges, pm);
    }

    @Override
    public RefactoringStatus initialize(RefactoringArguments arguments) {
        if (!(arguments instanceof JavaRefactoringArguments)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
        String handle = extended.getAttribute("input");
        if (handle == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        IJavaScriptElement element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
        if (element == null || !element.exists() || element.getElementType() != 5) {
            return ScriptableRefactoring.createInputFatalStatus(element, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.compilationunit");
        }
        String name = extended.getAttribute("name");
        if (name == null || name.length() == 0) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        this.fCu = (IJavaScriptUnit)element;
        try {
            this.computeRenameTypeRefactoring();
            this.setNewElementName(name);
        }
        catch (CoreException exception) {
            JavaScriptPlugin.log(exception);
            return ScriptableRefactoring.createInputFatalStatus(element, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.compilationunit");
        }
        return new RefactoringStatus();
    }

    public RenameTypeProcessor getRenameTypeProcessor() {
        return this.fRenameTypeProcessor;
    }

    public boolean isWillRenameType() {
        return this.fWillRenameType;
    }
}

