/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.memories;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.memories.AbstractSetBackedMaskedTupleMemory;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;

public final class NullaryMaskedTupleMemory
extends AbstractSetBackedMaskedTupleMemory {
    protected static final Set<Tuple> UNIT_RELATION = Collections.singleton(Tuples.staticArityFlatTupleOf());
    protected static final Set<Tuple> EMPTY_RELATION = Collections.emptySet();

    public NullaryMaskedTupleMemory(TupleMask mask, CollectionsFactory.MemoryType bucketType, Object owner) {
        super(mask, bucketType, owner);
        if (mask.getSize() != 0) {
            throw new IllegalArgumentException(mask.toString());
        }
    }

    @Override
    public int getKeysetSize() {
        return this.tuples.isEmpty() ? 0 : 1;
    }

    @Override
    public Iterable<Tuple> getSignatures() {
        return this.tuples.isEmpty() ? EMPTY_RELATION : UNIT_RELATION;
    }

    @Override
    public Collection<Tuple> get(ITuple signature) {
        if (signature.getSize() == 0) {
            return this.tuples.distinctValues();
        }
        return null;
    }

    @Override
    public boolean remove(Tuple tuple, Tuple signature) {
        this.tuples.removeOne(tuple);
        return this.tuples.isEmpty();
    }

    @Override
    public boolean remove(Tuple tuple) {
        this.tuples.removeOne(tuple);
        return this.tuples.isEmpty();
    }

    @Override
    public boolean add(Tuple tuple, Tuple signature) {
        boolean wasEmpty = this.tuples.isEmpty();
        this.tuples.addOne(tuple);
        return wasEmpty;
    }

    @Override
    public boolean add(Tuple tuple) {
        boolean wasEmpty = this.tuples.isEmpty();
        this.tuples.addOne(tuple);
        return wasEmpty;
    }
}

