/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend.historytree;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTConfig;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.IHistoryTree;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.classic.HistoryTreeClassic;

@NonNullByDefault
public final class HistoryTreeFactory {
    private HistoryTreeFactory() {
    }

    public static IHistoryTree createHistoryTree(HTConfig conf) throws IOException {
        return new HistoryTreeClassic(conf);
    }

    public static IHistoryTree createFromFile(Path existingStateFile, int expectedProviderVersion) throws IOException {
        if (!Files.isReadable(existingStateFile)) {
            throw new IOException("Selected state file does not exist or is not readable.");
        }
        if (Files.size(existingStateFile) <= 0L) {
            throw new IOException("Empty target file");
        }
        ByteBuffer buffer = ByteBuffer.allocate(4);
        Throwable throwable = null;
        Object var4_6 = null;
        try (SeekableByteChannel channel = Files.newByteChannel(existingStateFile, StandardOpenOption.READ);){
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.clear();
            channel.read(buffer);
            buffer.flip();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        int magicNumber = buffer.getInt();
        switch (magicNumber) {
            case 100641024: {
                return new HistoryTreeClassic(existingStateFile.toFile(), expectedProviderVersion);
            }
        }
        throw new IOException("Not a known history tree file");
    }
}

