/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ui.wizards.project;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2m.internal.qvt.oml.ui.QVTUIPlugin;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.undo.CreateFolderOperation;
import org.eclipse.ui.ide.undo.MoveResourcesOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SourceContainerUpdater {
    private IContainer fCurrentContainer;

    public SourceContainerUpdater(IContainer existingContainer) {
        if (existingContainer == null) {
            throw new IllegalArgumentException();
        }
        this.fCurrentContainer = existingContainer;
    }

    public static IStatus validate(String srcContainerPath) {
        IStatus result = Status.OK_STATUS;
        if (srcContainerPath != null && srcContainerPath.length() != 0) {
            if (srcContainerPath.trim().length() == 0) {
                return QVTUIPlugin.createStatus(4, Messages.SourceContainerUpdater_NonBlankSourceFolderExpected);
            }
            Path path = new Path(srcContainerPath);
            if (!path.isValidPath(srcContainerPath)) {
                return QVTUIPlugin.createStatus(4, Messages.SourceContainerUpdater_InvalidSourceFolder);
            }
            if (path.isAbsolute() || path.isUNC() || path.getDevice() != null) {
                return QVTUIPlugin.createStatus(4, Messages.SourceContainerUpdater_RelativeSourceFolderExpected);
            }
            result = ResourcesPlugin.getWorkspace().validatePath("/" + path.toString(), 7);
        }
        return result;
    }

    public IStatus setContainer(IContainer newContainer, boolean moveExistingSources, IProgressMonitor monitor, Shell shell) {
        IPath destPath;
        IStatus result = Status.OK_STATUS;
        if (newContainer.getType() == 2 && !(result = SourceContainerUpdater.ensureDestinationExists((IFolder)newContainer, monitor)).isOK()) {
            return result;
        }
        List<IResource> rootItems = SourceContainerUpdater.collectRootMoveCandidates(this.fCurrentContainer);
        IResource[] sources = rootItems.toArray(new IResource[rootItems.size()]);
        result = this.validateMoveSource(sources, destPath = newContainer.getFullPath());
        if (result.isOK()) {
            MoveResourcesOperation moveOperation = new MoveResourcesOperation(sources, destPath, "Moving");
            try {
                moveOperation.setQuietCompute(false);
                result = moveOperation.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)shell));
            }
            catch (ExecutionException e) {
                QVTUIPlugin.log(e);
                try {
                    if (moveOperation.canUndo()) {
                        moveOperation.undo(monitor, null);
                    }
                }
                catch (ExecutionException e1) {
                    QVTUIPlugin.log(e);
                }
            }
        }
        return result;
    }

    static IStatus ensureDestinationExists(IFolder container, IProgressMonitor monitor) {
        IProgressMonitor safeMonitor = monitor != null ? monitor : new NullProgressMonitor();
        try {
            CreateFolderOperation operation = new CreateFolderOperation(container, null, "Creating source container");
            return operation.execute(safeMonitor, null);
        }
        catch (ExecutionException e) {
            return QVTUIPlugin.createStatus(4, e.getLocalizedMessage(), e);
        }
    }

    private IStatus validateMoveSource(IResource[] resourceToBeMoved, IPath destPath) {
        int i = 0;
        while (i < resourceToBeMoved.length) {
            resourceToBeMoved[i].getFullPath().isPrefixOf(destPath);
            ++i;
        }
        return Status.OK_STATUS;
    }

    private static List<IResource> collectRootMoveCandidates(IContainer rootContainer) {
        final ArrayList<IResource> candidates = new ArrayList<IResource>();
        final boolean isProjectContainer = rootContainer.getType() == 4;
        try {
            rootContainer.accept(new IResourceProxyVisitor(){
                int depth = 0;

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    boolean bl;
                    if (this.depth > 0) {
                        if (proxy.getType() == 2) {
                            if (!isProjectContainer || SourceContainerUpdater.isQvtNamespaceFolder((IFolder)proxy.requestResource())) {
                                candidates.add(proxy.requestResource());
                            }
                        } else if (proxy.getType() == 1 && SourceContainerUpdater.isQvtSourceFile(proxy)) {
                            candidates.add(proxy.requestResource());
                        }
                    }
                    if (this.depth == 0) {
                        this.depth = 1;
                        bl = 1 > 0;
                    } else {
                        bl = false;
                    }
                    return bl;
                }
            }, 0);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return candidates;
    }

    static boolean isQvtNamespaceFolder(IFolder folder) {
        final boolean[] foundQvtSource = new boolean[1];
        final boolean[] foundOtherSource = new boolean[1];
        try {
            folder.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    if (SourceContainerUpdater.isQvtSourceFile(proxy)) {
                        foundQvtSource[0] = true;
                    } else if (proxy.getType() == 1) {
                        foundOtherSource[0] = true;
                    }
                    return !foundOtherSource[0];
                }
            }, 0);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return foundQvtSource[0];
    }

    static boolean isQvtSourceFile(IResourceProxy proxy) {
        return proxy.getType() == 1 && proxy.getName().endsWith(".qvto");
    }

    static class QvtSourceFinder
    implements IResourceProxyVisitor {
        private int depth = 0;
        private int nextDepth = 0;
        private List<IResource> sources = new ArrayList<IResource>();

        QvtSourceFinder() {
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (proxy.getType() == 1 && proxy.getName().endsWith(".qvto")) {
                this.sources.add(proxy.requestResource());
            }
            if (this.nextDepth == 0) {
                this.depth = 1;
            }
            return this.depth != 0;
        }
    }
}

