/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ui.wizards.project;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.m2m.internal.qvt.oml.ui.QVTUIPlugin;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.JdtProjectIntegrationHelper;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.Messages;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.NewProjectData;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.PluginClassCodeGenerator;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.PluginReference;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

class NewProjectCreationOperation
extends WorkspaceModifyOperation {
    private static final String BUILD_FILENAME_DESCRIPTOR = "build.properties";
    private static final String PLUGIN_NATURE = "org.eclipse.pde.PluginNature";
    private PluginClassCodeGenerator fGenerator;
    private NewProjectData fData;
    private IProject fProjectHandle;

    public NewProjectCreationOperation(IProject projectHandle, NewProjectData projectData) {
        if (projectHandle == null || projectData == null) {
            throw new IllegalArgumentException();
        }
        this.fData = projectData;
        this.fProjectHandle = projectHandle;
    }

    protected void createContents(IProgressMonitor monitor, IProject project) throws CoreException, InterruptedException {
    }

    private void createBuildProperties(IProject project, IProgressMonitor monitor) throws CoreException {
        IFile buildProperties = project.getFile(BUILD_FILENAME_DESCRIPTOR);
        StringWriter contents = new StringWriter();
        PrintWriter wr = new PrintWriter((Writer)contents, true);
        if (this.fData.isCreateJava()) {
            IPath sourceFolder = this.asBinIncludesFolder(this.createJavaFolder(this.fData.getSourceFolderName(), monitor));
            IPath outFolder = this.asBinIncludesFolder(this.createJavaFolder(this.fData.getOutFolderName(), monitor));
            wr.append("source.. = ").println(sourceFolder.toString());
            wr.append("output.. = ").println(outFolder.toString());
        }
        char[] alignChars = new char[15];
        Arrays.fill(alignChars, ' ');
        String indent = new String(alignChars);
        wr.print("bin.includes = META-INF/");
        if (this.fData.isCreateJava()) {
            wr.println(",\\");
            wr.append(indent).append('.');
        }
        IContainer qvtContainer = this.createJavaFolder(this.fData.getQVTSourceFolderName(), monitor);
        IPath qvtFolder = this.asBinIncludesFolder(qvtContainer);
        if (!this.fProjectHandle.equals((Object)qvtContainer) || !this.fData.isCreateJava()) {
            wr.println(",\\");
            wr.append(indent).append(qvtFolder.toString());
        }
        wr.println();
        wr.flush();
        InputStream is = this.createContentStreamForNewFile(buildProperties, contents.getBuffer().toString());
        buildProperties.create(is, false, monitor);
    }

    private void createManifest(IFolder metaFolder, IProgressMonitor monitor) throws CoreException {
        String requiredEnv;
        PluginReference[] dependencies;
        IFile manifest = metaFolder.getFile("MANIFEST.MF");
        StringWriter contents = new StringWriter();
        PrintWriter wr = new PrintWriter((Writer)contents, true);
        wr.println("Manifest-Version: 1.0");
        wr.println("Bundle-ManifestVersion: 2");
        wr.append("Bundle-Name: ").println(this.fData.getName());
        wr.append("Bundle-SymbolicName: ").println(this.fData.getID());
        wr.append("Bundle-Version: ").println(this.fData.getVersion());
        if (this.fData.isDoGenerateClass() && this.fData.getClassName().length() > 0) {
            wr.append("Bundle-Activator: ").println(this.fData.getClassName());
        }
        if (this.fData.getProviderName().length() > 0) {
            wr.append("Bundle-Vendor: ").println(this.fData.getProviderName());
        }
        if ((dependencies = this.getDependencies()).length > 0) {
            wr.append("Require-Bundle:");
            int i = 0;
            PluginReference[] pluginReferenceArray = dependencies;
            int n = dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                PluginReference pluginReference = pluginReferenceArray[n2];
                if (i++ > 0) {
                    wr.println(',');
                }
                wr.append(' ');
                wr.append(pluginReference.getId());
                ++n2;
            }
            wr.println();
        }
        if (this.fData.isCreateJava() && (requiredEnv = JdtProjectIntegrationHelper.getRequiredExecutionEnv(this.fData.getfExecutionEnv())) != null) {
            wr.println(requiredEnv);
        }
        wr.println("Bundle-ActivationPolicy: lazy");
        wr.flush();
        InputStream is = this.createContentStreamForNewFile(manifest, contents.getBuffer().toString());
        manifest.create(is, false, monitor);
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.NewProjectCreationOperation_createQVTProjectTask, (int)2);
        this.createProject((IProgressMonitor)progress.newChild(1));
        this.createContents((IProgressMonitor)progress.newChild(1), this.fProjectHandle);
        monitor.done();
    }

    private void generateTopLevelPluginClass(IProgressMonitor monitor) throws CoreException {
        this.fGenerator.generate(monitor);
        monitor.done();
    }

    private PluginReference[] getDependencies() {
        if (this.fGenerator == null) {
            return new PluginReference[0];
        }
        return this.fGenerator.getDependencies();
    }

    private void createProject(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)7);
        URI location = URIUtil.toURI((IPath)this.fData.getLocation());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(this.fProjectHandle.getName());
        if (location != null && ResourcesPlugin.getWorkspace().getRoot().getLocationURI().equals(location)) {
            location = null;
        }
        description.setLocationURI(location);
        if (!this.fProjectHandle.exists()) {
            this.fProjectHandle.create(description, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.setWorkRemaining(6);
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.fProjectHandle.open(128, (IProgressMonitor)subMonitor.newChild(1));
        if (this.fData.isPlugin()) {
            this.addNatureToProject(this.fProjectHandle, PLUGIN_NATURE, (IProgressMonitor)subMonitor.newChild(1));
            this.fGenerator = new PluginClassCodeGenerator(this.fProjectHandle, this.fData);
            if (this.fData.isCreateJava()) {
                JdtProjectIntegrationHelper.setupJava(this.fProjectHandle, true, this.fData.getSourceFolderName(), this.fData.getOutFolderName(), this.fData.getfExecutionEnv(), (IProgressMonitor)subMonitor.newChild(1));
                if (this.fData.isDoGenerateClass()) {
                    this.generateTopLevelPluginClass((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                monitor.worked(1);
            }
            subMonitor.setWorkRemaining(3);
            IFolder metaFolder = this.fProjectHandle.getFolder("META-INF");
            metaFolder.create(true, true, (IProgressMonitor)subMonitor.newChild(1));
            this.createManifest(metaFolder, (IProgressMonitor)subMonitor.newChild(1));
            this.createBuildProperties(this.fProjectHandle, (IProgressMonitor)subMonitor.newChild(1));
        } else if (this.fData.isCreateJava()) {
            subMonitor.setWorkRemaining(1);
            JdtProjectIntegrationHelper.setupJava(this.fProjectHandle, false, this.fData.getSourceFolderName(), this.fData.getOutFolderName(), this.fData.getfExecutionEnv(), (IProgressMonitor)subMonitor.newChild(1));
            if (this.fData.isDoGenerateClass()) {
                this.generateTopLevelPluginClass((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            monitor.worked(1);
        }
    }

    private void addNatureToProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    private InputStream createContentStreamForNewFile(IFile fileHandle, String contents) {
        byte[] bytes;
        String charset = null;
        try {
            charset = fileHandle.getProject().getDefaultCharset();
        }
        catch (CoreException e) {
            QVTUIPlugin.log(e.getStatus());
        }
        if (charset == null) {
            charset = ResourcesPlugin.getEncoding();
        }
        try {
            bytes = contents.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            bytes = contents.getBytes();
        }
        return new ByteArrayInputStream(bytes);
    }

    private IPath asBinIncludesFolder(IContainer container) {
        if (container.equals((Object)this.fProjectHandle)) {
            return new Path(".");
        }
        IPath result = container.getProjectRelativePath();
        while (result.hasTrailingSeparator()) {
            result = result.removeTrailingSeparator();
        }
        return result.addTrailingSeparator();
    }

    private IContainer createJavaFolder(String folderName, IProgressMonitor monitor) throws CoreException {
        if (folderName == null || folderName.trim().length() == 0) {
            return this.fProjectHandle;
        }
        IFolder folder = this.fProjectHandle.getFolder(folderName);
        if (!folder.exists()) {
            folder.create(true, true, monitor);
        }
        return folder;
    }
}

