/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.factory.PropertiesFactory;
import org.eclipse.net4j.util.lifecycle.LifecycleHook;
import org.eclipse.net4j.util.om.log.Log;
import org.eclipse.net4j.util.om.log.RollingLog;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositoryActivityLog
extends LifecycleHook<IRepository>
implements Log {
    private final IListener sessionManagerListener = new ContainerEventAdapter<ISession>(){

        protected void onAdded(IContainer<ISession> container, ISession session) {
            RepositoryActivityLog.this.sessionOpened(session, RepositoryActivityLog.this.concurrentSessions.incrementAndGet(), RepositoryActivityLog.this.sessions.incrementAndGet());
            session.addListener(RepositoryActivityLog.this.sessionListener);
        }

        protected void onRemoved(IContainer<ISession> container, ISession session) {
            session.removeListener(RepositoryActivityLog.this.sessionListener);
            RepositoryActivityLog.this.sessionClosed(session, RepositoryActivityLog.this.concurrentSessions.decrementAndGet());
        }
    };
    private final IListener sessionListener = new ContainerEventAdapter<IView>(){

        protected void onAdded(IContainer<IView> container, IView view) {
            if (view instanceof ITransaction) {
                RepositoryActivityLog.this.transactionOpened((ITransaction)view, RepositoryActivityLog.this.concurrentTransactions.incrementAndGet(), RepositoryActivityLog.this.transactions.incrementAndGet());
            } else {
                RepositoryActivityLog.this.viewOpened(view, RepositoryActivityLog.this.concurrentViews.incrementAndGet(), RepositoryActivityLog.this.views.incrementAndGet());
            }
        }

        protected void onRemoved(IContainer<IView> container, IView view) {
            if (view instanceof ITransaction) {
                RepositoryActivityLog.this.transactionClosed((ITransaction)view, RepositoryActivityLog.this.concurrentTransactions.decrementAndGet());
            } else {
                RepositoryActivityLog.this.viewClosed(view, RepositoryActivityLog.this.concurrentViews.decrementAndGet());
            }
        }
    };
    private final IRepository.WriteAccessHandler writeAccessHandler = new IRepository.WriteAccessHandler(){

        public void handleTransactionBeforeCommitting(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) throws RuntimeException {
            RepositoryActivityLog.this.commitStarted(commitContext, RepositoryActivityLog.this.concurrentCommits.incrementAndGet(), RepositoryActivityLog.this.commits.incrementAndGet());
        }

        public void handleTransactionAfterCommitted(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) {
            RepositoryActivityLog.this.commitFinished(commitContext, RepositoryActivityLog.this.concurrentCommits.decrementAndGet());
        }
    };
    private final AtomicInteger sessions = new AtomicInteger();
    private final AtomicInteger views = new AtomicInteger();
    private final AtomicInteger transactions = new AtomicInteger();
    private final AtomicInteger commits = new AtomicInteger();
    private final AtomicInteger concurrentSessions = new AtomicInteger();
    private final AtomicInteger concurrentViews = new AtomicInteger();
    private final AtomicInteger concurrentTransactions = new AtomicInteger();
    private final AtomicInteger concurrentCommits = new AtomicInteger();

    public IRepository getRepository() {
        return (IRepository)this.getDelegate();
    }

    public void setRepository(IRepository repository) {
        this.setDelegate(repository);
    }

    protected void sessionOpened(ISession session, int concurrentSessions, int sessions) {
        this.log(String.valueOf(this.formatSession(session)) + " opened" + this.formatUser(session) + " (" + concurrentSessions + "/" + sessions + ")");
    }

    protected void sessionClosed(ISession session, int concurrentSessions) {
        this.log(String.valueOf(this.formatSession(session)) + " closed" + this.formatUser(session) + " (" + concurrentSessions + ")");
    }

    protected void viewOpened(IView view, int concurrentViews, int views) {
        this.log(String.valueOf(this.formatView(view)) + " opened" + this.formatUser(view.getSession()) + " (" + concurrentViews + "/" + views + ")");
    }

    protected void viewClosed(IView view, int concurrentViews) {
        this.log(String.valueOf(this.formatView(view)) + " closed" + this.formatUser(view.getSession()) + " (" + concurrentViews + ")");
    }

    protected void transactionOpened(ITransaction transaction, int concurrentTransactions, int transactions) {
        this.log(String.valueOf(this.formatView(transaction)) + " opened" + this.formatUser(transaction.getSession()) + " (" + concurrentTransactions + "/" + transactions + ")");
    }

    protected void transactionClosed(ITransaction transaction, int concurrentTransactions) {
        this.log(String.valueOf(this.formatView(transaction)) + " closed" + this.formatUser(transaction.getSession()) + " (" + concurrentTransactions + ")");
    }

    protected void commitStarted(IStoreAccessor.CommitContext commitContext, int concurrentCommits, int commits) {
        ITransaction transaction = commitContext.getTransaction();
        this.log(String.valueOf(this.formatView(transaction)) + " committing " + commitContext.getBranchPoint().getTimeStamp() + this.formatUser(transaction.getSession()) + " (" + concurrentCommits + "/" + commits + ")");
    }

    protected void commitFinished(IStoreAccessor.CommitContext commitContext, int concurrentCommits) {
        ITransaction transaction = commitContext.getTransaction();
        this.log(String.valueOf(this.formatView(transaction)) + (commitContext.getRollbackMessage() != null ? " committed " : " rolled back ") + commitContext.getBranchPoint().getTimeStamp() + this.formatUser(transaction.getSession()) + " (" + concurrentCommits + ")");
    }

    protected String formatSession(ISession session) {
        return "Session " + session.getSessionID();
    }

    protected String formatUser(ISession session) {
        String userID = session.getUserID();
        return StringUtil.isEmpty((String)userID) ? "" : " by user " + userID;
    }

    protected String formatView(IView view) {
        return String.valueOf(view instanceof ITransaction ? "Transaction " : "View ") + view.getSessionID() + ":" + view.getViewID();
    }

    protected void hookDelegate(IRepository repository) {
        repository.getSessionManager().addListener(this.sessionManagerListener);
        repository.addHandler(this.writeAccessHandler);
    }

    protected void unhookDelegate(IRepository repository) {
        repository.removeHandler(this.writeAccessHandler);
        repository.getSessionManager().removeListener(this.sessionManagerListener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Factory
    extends PropertiesFactory {
        public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.server.repositoryActivityLogs";

        public Factory(String type) {
            super(PRODUCT_GROUP, type);
        }

        protected abstract RepositoryActivityLog create(Map<String, String> var1) throws ProductCreationException;
    }

    public static class Rolling
    extends RepositoryActivityLog {
        private final RollingLog rollingLog;

        public Rolling(String logFile, long logSize, boolean append) {
            this.rollingLog = new RollingLog(logFile, logSize, append);
        }

        public void log(String message) {
            this.rollingLog.log(message);
        }

        protected void delegateChanged(IRepository oldRepository, IRepository newRepository) {
            if (newRepository != null) {
                OM.LOG.info("Logging activities of repository " + newRepository.getName() + " to " + this.rollingLog.getLogFile());
            }
        }

        protected void doActivate() throws Exception {
            this.rollingLog.activate();
            super.doActivate();
        }

        protected void doDeactivate() throws Exception {
            super.doDeactivate();
            this.rollingLog.deactivate();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Factory
        extends org.eclipse.emf.cdo.spi.server.RepositoryActivityLog$Factory {
            public static final String TYPE = "rolling";

            public Factory() {
                super(TYPE);
            }

            @Override
            protected RepositoryActivityLog create(Map<String, String> properties) throws ProductCreationException {
                String append;
                String size;
                String file = properties.get("file");
                if (file == null) {
                    file = "activities";
                }
                if (StringUtil.isEmpty((String)(size = properties.get("size")))) {
                    size = "100000000";
                }
                if (StringUtil.isEmpty((String)(append = properties.get("append")))) {
                    append = Boolean.TRUE.toString();
                }
                return new Rolling(file, Long.parseLong(size), Boolean.parseBoolean(append));
            }
        }
    }
}

