/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.filesystem.ui.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.ctx.filesystem.ui.actions.FSAction;
import org.eclipse.rcptt.ctx.filesystem.ui.actions.FSFileEditorInput;
import org.eclipse.rcptt.filesystem.FSFile;
import org.eclipse.rcptt.filesystem.FSFolder;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class OpenFile
extends FSAction {
    public OpenFile() {
        super("Open File", Images.getImageDescriptor((String)"icons/file.gif"));
    }

    @Override
    protected void init() {
        this.setEnabled(this.selection != null && this.selection.length == 1 && this.selection[0] instanceof FSFile);
    }

    public void run() {
        FSFile file = (FSFile)this.selection[0];
        String name = this.getFullName(file);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditor((IWorkbenchPage)page, (IEditorInput)new FSFileEditorInput(file, name), (String)"org.eclipse.ui.DefaultTextEditor");
        }
        catch (PartInitException e) {
            Q7UIPlugin.log((Throwable)e);
        }
    }

    private String getFullName(FSFile file) {
        StringBuilder builder = new StringBuilder();
        builder.append(file.getName());
        EObject container = file.eContainer();
        while (container != null) {
            String folderName;
            if (container instanceof FSFolder && (folderName = ((FSFolder)container).getName()) != null) {
                builder.insert(0, folderName + "/");
            }
            container = container.eContainer();
        }
        return "contents/" + builder.toString();
    }
}

