/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting.util.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.streams.SherlockReportSession;

public class Reports {
    private final SherlockReportSession session;
    private final Map<String, List<String>> reports = new HashMap<String, List<String>>();

    public Reports(File root) {
        this.session = new SherlockReportSession(root);
        this.session.reinit();
    }

    public SherlockReportSession getSession() {
        return this.session;
    }

    public void add(String suiteId, String reportId) {
        List<String> ids = this.reports.get(suiteId);
        if (ids == null) {
            ids = new ArrayList<String>();
            this.reports.put(suiteId, ids);
        }
        ids.add(reportId);
    }

    public Iterable<String> getSuiteIds() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return Reports.this.reports.keySet().iterator();
            }
        };
    }

    public Iterable<String> getReportIds(final String suite) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return Reports.this.reports.get(suite).iterator();
            }
        };
    }

    public Iterator<Report> getReports(String suite) {
        return new ReportIterator(this.getReportIds(suite).iterator());
    }

    private class ReportIterator
    implements Iterator<Report> {
        private Iterator<String> ids;

        public ReportIterator(Iterator<String> ids) {
            this.ids = ids;
        }

        @Override
        public boolean hasNext() {
            return this.ids.hasNext();
        }

        @Override
        public Report next() {
            return Reports.this.getSession().getReport(this.ids.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

