/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.util.Stack;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.ThrowStatement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnionTypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;

public class ThrownExceptionFinder
extends ASTVisitor {
    private SimpleSet thrownExceptions;
    private Stack exceptionsStack;
    private SimpleSet caughtExceptions;
    private SimpleSet discouragedExceptions;

    public void processThrownExceptions(TryStatement tryStatement, BlockScope scope) {
        this.thrownExceptions = new SimpleSet();
        this.exceptionsStack = new Stack();
        this.caughtExceptions = new SimpleSet();
        this.discouragedExceptions = new SimpleSet();
        tryStatement.traverse((ASTVisitor)this, scope);
        this.removeCaughtExceptions(tryStatement, true);
    }

    private void acceptException(ReferenceBinding binding) {
        if (binding != null && binding.isValidBinding()) {
            this.thrownExceptions.add((Object)binding);
        }
    }

    public void endVisit(MessageSend messageSend, BlockScope scope) {
        if (messageSend.binding != null) {
            this.endVisitMethodInvocation(messageSend.binding);
        }
        super.endVisit(messageSend, scope);
    }

    public void endVisit(AllocationExpression allocationExpression, BlockScope scope) {
        if (allocationExpression.binding != null) {
            this.endVisitMethodInvocation(allocationExpression.binding);
        }
        super.endVisit(allocationExpression, scope);
    }

    public void endVisit(ThrowStatement throwStatement, BlockScope scope) {
        this.acceptException((ReferenceBinding)throwStatement.exception.resolvedType);
        super.endVisit(throwStatement, scope);
    }

    private void endVisitMethodInvocation(MethodBinding methodBinding) {
        ReferenceBinding[] thrownExceptionBindings = methodBinding.thrownExceptions;
        int length = thrownExceptionBindings == null ? 0 : thrownExceptionBindings.length;
        int i = 0;
        while (i < length) {
            this.acceptException(thrownExceptionBindings[i]);
            ++i;
        }
    }

    public ReferenceBinding[] getAlreadyCaughtExceptions() {
        Object[] allCaughtExceptions = new ReferenceBinding[this.caughtExceptions.elementSize];
        this.caughtExceptions.asArray(allCaughtExceptions);
        return allCaughtExceptions;
    }

    public ReferenceBinding[] getThrownUncaughtExceptions() {
        Object[] result = new ReferenceBinding[this.thrownExceptions.elementSize];
        this.thrownExceptions.asArray(result);
        return result;
    }

    public ReferenceBinding[] getDiscouragedExceptions() {
        Object[] allDiscouragedExceptions = new ReferenceBinding[this.discouragedExceptions.elementSize];
        this.discouragedExceptions.asArray(allDiscouragedExceptions);
        return allDiscouragedExceptions;
    }

    public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
        return this.visitType(typeDeclaration);
    }

    public boolean visit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
        return this.visitType(memberTypeDeclaration);
    }

    public boolean visit(TypeDeclaration localTypeDeclaration, BlockScope scope) {
        return this.visitType(localTypeDeclaration);
    }

    private boolean visitType(TypeDeclaration typeDeclaration) {
        return false;
    }

    public boolean visit(TryStatement tryStatement, BlockScope scope) {
        Object[] values;
        SimpleSet exceptionSet;
        this.exceptionsStack.push(this.thrownExceptions);
        this.thrownExceptions = exceptionSet = new SimpleSet();
        tryStatement.tryBlock.traverse((ASTVisitor)this, scope);
        this.removeCaughtExceptions(tryStatement, false);
        this.thrownExceptions = (SimpleSet)this.exceptionsStack.pop();
        Object[] objectArray = values = exceptionSet.values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (value != null) {
                this.thrownExceptions.add(value);
            }
            ++n2;
        }
        Block[] catchBlocks = tryStatement.catchBlocks;
        int length = catchBlocks == null ? 0 : catchBlocks.length;
        int i = 0;
        while (i < length) {
            catchBlocks[i].traverse((ASTVisitor)this, scope);
            ++i;
        }
        return false;
    }

    private void removeCaughtExceptions(TryStatement tryStatement, boolean recordUncheckedCaughtExceptions) {
        Argument[] catchArguments = tryStatement.catchArguments;
        int length = catchArguments == null ? 0 : catchArguments.length;
        int i = 0;
        while (i < length) {
            if (catchArguments[i].type instanceof UnionTypeReference) {
                UnionTypeReference unionTypeReference = (UnionTypeReference)catchArguments[i].type;
                TypeReference[] typeReferenceArray = unionTypeReference.typeReferences;
                int n = unionTypeReference.typeReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    TypeReference ref = typeReferenceArray[n2];
                    TypeBinding caughtException = ref.resolvedType;
                    if (caughtException instanceof ReferenceBinding && caughtException.isValidBinding()) {
                        if (recordUncheckedCaughtExceptions) {
                            this.removeCaughtException((ReferenceBinding)caughtException);
                            this.caughtExceptions.add((Object)caughtException);
                        } else if (!caughtException.isUncheckedException(true)) {
                            this.discouragedExceptions.add((Object)caughtException);
                        }
                    }
                    ++n2;
                }
            } else {
                TypeBinding exception = catchArguments[i].type.resolvedType;
                if (exception instanceof ReferenceBinding && exception.isValidBinding()) {
                    if (recordUncheckedCaughtExceptions) {
                        this.removeCaughtException((ReferenceBinding)exception);
                        this.caughtExceptions.add((Object)exception);
                    } else if (!exception.isUncheckedException(true)) {
                        this.discouragedExceptions.add((Object)exception);
                    }
                }
            }
            ++i;
        }
    }

    private void removeCaughtException(ReferenceBinding caughtException) {
        Object[] exceptions;
        Object[] objectArray = exceptions = this.thrownExceptions.values;
        int n = exceptions.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            ReferenceBinding exception = (ReferenceBinding)e;
            if (exception != null) {
                if (TypeBinding.equalsEquals((TypeBinding)exception, (TypeBinding)caughtException)) {
                    this.thrownExceptions.remove((Object)exception);
                } else if (caughtException.isSuperclassOf(exception)) {
                    this.thrownExceptions.remove((Object)exception);
                    this.discouragedExceptions.add((Object)exception);
                }
            }
            ++n2;
        }
    }
}

