/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring.delete;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.GroupContext;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.SuperContext;

public abstract class AbstractDeleteContextReferenceChange
extends Change {
    private IQ7Element element;
    private final IContext context;
    private String contextID;

    protected AbstractDeleteContextReferenceChange(IQ7Element element, IContext context, String contextID) {
        this.element = element;
        this.context = context;
        this.contextID = contextID;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public Object getModifiedElement() {
        return this.element.getResource();
    }

    protected final IQ7Element getElement() {
        return this.element;
    }

    protected final IContext getContext() {
        return this.context;
    }

    protected final String getContextId() {
        return this.contextID;
    }

    protected boolean isValid() throws ModelException {
        if (this.element == null || this.context == null) {
            return false;
        }
        if (this.getContextId() == null || this.getContextId().length() == 0) {
            return false;
        }
        return this.element instanceof ITestCase || this.element instanceof IContext || this.element instanceof IQ7ProjectMetadata;
    }

    protected final List<String> getContextsReferences(IQ7NamedElement copy) throws ModelException {
        if (copy instanceof ITestCase) {
            return new ArrayList<String>(Arrays.asList(((ITestCase)copy).getContexts()));
        }
        if (copy instanceof IQ7ProjectMetadata) {
            return new ArrayList<String>(Arrays.asList(((IQ7ProjectMetadata)copy).getContexts()));
        }
        if (copy instanceof IContext) {
            NamedElement namedElement = ((IContext)copy).getNamedElement();
            if (namedElement instanceof GroupContext) {
                return new ArrayList<String>((Collection<String>)((GroupContext)namedElement).getContextReferences());
            }
            if (namedElement instanceof SuperContext) {
                return ((SuperContext)namedElement).getContextReferences();
            }
        }
        throw new IllegalArgumentException();
    }
}

