/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.jface;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.CellEditor;

public class TeslaCellEditorManager {
    private static TeslaCellEditorManager manager = null;
    private Set<CellEditor> directEditManagers = new HashSet<CellEditor>();
    private boolean markNewAsForced = false;
    private CellEditor lastActivated = null;
    private int nextCellEditorActivateEventType;
    private int nextCellEditorActivateEventButton;
    private CellEditor lastActivatedByAnyMethod = null;

    public CellEditor getLastActivatedByAnyMethod() {
        return this.lastActivatedByAnyMethod;
    }

    public static synchronized TeslaCellEditorManager getInstance() {
        if (manager == null) {
            manager = new TeslaCellEditorManager();
        }
        return manager;
    }

    public synchronized void addManager(CellEditor mgr) {
        this.directEditManagers.add(mgr);
        this.lastActivatedByAnyMethod = mgr;
        if (this.markNewAsForced) {
            this.lastActivated = mgr;
        }
    }

    public synchronized boolean removeManager(CellEditor mgr) {
        this.directEditManagers.remove(mgr);
        return true;
    }

    public synchronized CellEditor[] getEditors() {
        ArrayList<CellEditor> toRemove = new ArrayList<CellEditor>();
        for (CellEditor cellEditor : this.directEditManagers) {
            if (cellEditor.getControl() == null || !cellEditor.getControl().isDisposed()) continue;
            toRemove.add(cellEditor);
        }
        this.directEditManagers.removeAll(toRemove);
        return this.directEditManagers.toArray(new CellEditor[this.directEditManagers.size()]);
    }

    public void forceRemove(CellEditor manager2) {
        this.directEditManagers.remove(manager2);
    }

    public synchronized void makeNewAsForced(boolean b) {
        this.markNewAsForced = b;
        this.lastActivated = null;
    }

    public CellEditor getLastActivated() {
        return this.lastActivated;
    }

    public synchronized void clean() {
        this.directEditManagers.clear();
        this.lastActivated = null;
    }

    public boolean isInActivation() {
        return this.markNewAsForced;
    }

    public void setNextCellEditorActivateEventType(int nextCellEditorActivateEventType) {
        this.nextCellEditorActivateEventType = nextCellEditorActivateEventType;
    }

    public int getNextCellEditorActivateEventType() {
        return this.nextCellEditorActivateEventType;
    }

    public void setNextCellEditorActivateEventButton(int nextCellEditorActivateEventButton) {
        this.nextCellEditorActivateEventButton = nextCellEditorActivateEventButton;
    }

    public int getNextCellEditorActivateEventButton() {
        return this.nextCellEditorActivateEventButton;
    }
}

