/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class Visitors {

    public static final class AnnotatedNodeVisitor
    extends ASTVisitor {
        private final Map<ASTNode, List<Annotation>> _result;

        public AnnotatedNodeVisitor(Map<ASTNode, List<Annotation>> map) {
            this._result = map;
        }

        public boolean visit(PackageDeclaration node) {
            List annotations = node.annotations();
            if (!annotations.isEmpty()) {
                this._result.put((ASTNode)node, annotations);
            }
            return false;
        }

        public boolean visit(TypeDeclaration node) {
            this.visitBodyDeclaration((BodyDeclaration)node);
            return true;
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            this.visitBodyDeclaration((BodyDeclaration)node);
            return true;
        }

        public boolean visit(EnumDeclaration node) {
            this.visitBodyDeclaration((BodyDeclaration)node);
            return true;
        }

        public boolean visit(FieldDeclaration node) {
            this.visitBodyDeclaration((BodyDeclaration)node);
            return true;
        }

        public boolean visit(EnumConstantDeclaration node) {
            this.visitBodyDeclaration((BodyDeclaration)node);
            return true;
        }

        public boolean visit(MethodDeclaration node) {
            this.visitBodyDeclaration((BodyDeclaration)node);
            return true;
        }

        public boolean visit(AnnotationTypeMemberDeclaration node) {
            this.visitBodyDeclaration((BodyDeclaration)node);
            return true;
        }

        private void visitBodyDeclaration(BodyDeclaration node) {
            List extMods = node.modifiers();
            ArrayList<Annotation> annos = null;
            for (IExtendedModifier extMod : extMods) {
                if (!extMod.isAnnotation()) continue;
                if (annos == null) {
                    annos = new ArrayList<Annotation>(2);
                    this._result.put((ASTNode)node, annos);
                }
                annos.add((Annotation)extMod);
            }
        }

        public boolean visit(SingleVariableDeclaration node) {
            List extMods = node.modifiers();
            ArrayList<Annotation> annos = null;
            for (IExtendedModifier extMod : extMods) {
                if (!extMod.isAnnotation()) continue;
                if (annos == null) {
                    annos = new ArrayList<Annotation>(2);
                    this._result.put((ASTNode)node, annos);
                }
                annos.add((Annotation)extMod);
            }
            return false;
        }

        public boolean visit(Block node) {
            return false;
        }

        public boolean visit(MarkerAnnotation node) {
            return false;
        }

        public boolean visit(NormalAnnotation node) {
            return false;
        }

        public boolean visit(SingleMemberAnnotation node) {
            return false;
        }
    }

    public static final class AnnotationVisitor
    extends ASTVisitor {
        private final List<Annotation> _annotations;

        public AnnotationVisitor(List<Annotation> annotations) {
            this._annotations = annotations;
        }

        public boolean visit(MarkerAnnotation annotation) {
            this._annotations.add((Annotation)annotation);
            return false;
        }

        public boolean visit(SingleMemberAnnotation annotation) {
            this._annotations.add((Annotation)annotation);
            return false;
        }

        public boolean visit(NormalAnnotation annotation) {
            this._annotations.add((Annotation)annotation);
            return false;
        }

        public boolean visit(Block blk) {
            return false;
        }

        public boolean visit(DoStatement doStatement) {
            return false;
        }

        public boolean visit(ForStatement forStatement) {
            return false;
        }

        public boolean visit(IfStatement ifStatement) {
            return false;
        }

        public boolean visit(TryStatement tryStatement) {
            return false;
        }

        public void reset() {
            this._annotations.clear();
        }
    }

    public static final class DeclarationFinder
    extends ASTVisitor {
        private final Annotation _anno;
        private ASTNode _result = null;

        public DeclarationFinder(Annotation annotation) {
            this._anno = annotation;
        }

        public ASTNode getAnnotatedNode() {
            return this._result;
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            return this.internalVisit((ASTNode)node);
        }

        public boolean visit(AnnotationTypeMemberDeclaration node) {
            return this.internalVisit((ASTNode)node);
        }

        public boolean visit(EnumDeclaration node) {
            return this.internalVisit((ASTNode)node);
        }

        public boolean visit(EnumConstantDeclaration node) {
            return this.internalVisit((ASTNode)node);
        }

        public boolean visit(FieldDeclaration node) {
            return this.internalVisit((ASTNode)node);
        }

        public boolean visit(MethodDeclaration node) {
            return this.internalVisit((ASTNode)node);
        }

        public boolean visit(TypeDeclaration node) {
            return this.internalVisit((ASTNode)node);
        }

        public boolean visit(SingleVariableDeclaration node) {
            return this.internalVisit((ASTNode)node);
        }

        private boolean internalVisit(ASTNode node) {
            if (this._result != null) {
                return false;
            }
            int nodeStart = node.getStartPosition();
            int nodeEnd = nodeStart + node.getLength();
            int annoStart = this._anno.getStartPosition();
            int annoEnd = annoStart + this._anno.getLength();
            if (nodeStart > annoEnd) {
                return false;
            }
            if (nodeEnd > annoStart) {
                List extendedModifiers;
                if (node.getNodeType() == 44) {
                    declaration = (SingleVariableDeclaration)node;
                    extendedModifiers = declaration.modifiers();
                } else {
                    declaration = (BodyDeclaration)node;
                    extendedModifiers = declaration.modifiers();
                }
                for (IExtendedModifier modifier : extendedModifiers) {
                    if (modifier != this._anno) continue;
                    this._result = node;
                    return false;
                }
            }
            return true;
        }

        public boolean visit(Block node) {
            return false;
        }

        public boolean visit(MarkerAnnotation node) {
            return false;
        }

        public boolean visit(NormalAnnotation node) {
            return false;
        }

        public boolean visit(SingleMemberAnnotation node) {
            return false;
        }
    }

    public static class EndingOffsetFinder
    extends ASTVisitor {
        private final int[] _sortedStartingOffset;
        private final int[] _endingOffsets;

        public EndingOffsetFinder(int[] offsets) {
            if (offsets == null) {
                throw new IllegalArgumentException("argument cannot be null.");
            }
            Arrays.sort(offsets);
            int count = 0;
            int i = 1;
            int len = offsets.length;
            while (i < len) {
                if (offsets[i - 1] != offsets[i]) {
                    ++count;
                }
                ++i;
            }
            if (count != offsets.length) {
                this._sortedStartingOffset = new int[count];
                int index = 0;
                int i2 = 0;
                int len2 = offsets.length;
                while (i2 < len2) {
                    if (i2 == 0 || offsets[i2 - 1] != offsets[i2]) {
                        this._sortedStartingOffset[index++] = offsets[i2];
                    }
                    ++i2;
                }
            } else {
                this._sortedStartingOffset = offsets;
            }
            this._endingOffsets = new int[count];
            i = 0;
            while (i < count) {
                this._endingOffsets[i] = 0;
                ++i;
            }
        }

        public void preVisit(ASTNode node) {
            int startingOffset = node.getStartPosition();
            int endingOffset = startingOffset + node.getLength();
            int startIndex = Arrays.binarySearch(this._sortedStartingOffset, startingOffset);
            int endIndex = Arrays.binarySearch(this._sortedStartingOffset, endingOffset);
            if (startIndex < 0) {
                startIndex = -startIndex - 1;
            }
            endIndex = endIndex < 0 ? -endIndex - 1 : ++endIndex;
            if (startIndex >= this._sortedStartingOffset.length) {
                return;
            }
            int i = startIndex;
            while (i < endIndex) {
                if (this._endingOffsets[i] == 0) {
                    this._endingOffsets[i] = endingOffset;
                } else if (endingOffset < this._endingOffsets[i]) {
                    this._endingOffsets[i] = endingOffset;
                }
                ++i;
            }
        }

        public int getEndingOffset(int startingOffset) {
            int index = Arrays.binarySearch(this._sortedStartingOffset, startingOffset);
            if (index == -1) {
                return 0;
            }
            return this._endingOffsets[index];
        }
    }
}

