/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.ecl.context.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.rcptt.core.ecl.context.ContextPackage;
import org.eclipse.rcptt.core.ecl.context.EclContext;
import org.eclipse.rcptt.core.ecl.context.internal.viewer.EclContextViewer;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.ecl.core.CoreFactory;
import org.eclipse.rcptt.ecl.core.Script;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.editors.EditorContent;
import org.eclipse.rcptt.ui.editors.EditorHeader;
import org.eclipse.rcptt.ui.editors.ecl.EclDocumentProvider;
import org.eclipse.rcptt.ui.editors.ecl.EclEditor;
import org.eclipse.rcptt.ui.editors.ecl.EclEditorInput;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EclContextEditor
extends EclEditor {
    private final List<Runnable> onDispose = new ArrayList<Runnable>();

    public EclContextEditor() {
        this.onDispose.add(0, () -> super.dispose());
        Image image = EclContextViewer.getEclContextImage().createImage();
        this.setTitleImage(image);
        this.onDispose.add(0, () -> ((Image)image).dispose());
    }

    public void dispose() {
        RuntimeException result = null;
        for (Runnable runnable : this.onDispose) {
            try {
                runnable.run();
            }
            catch (RuntimeException e) {
                if (result == null) {
                    result = e;
                    continue;
                }
                result.addSuppressed(e);
            }
        }
        if (result != null) {
            throw result;
        }
    }

    protected String getEclContext(NamedElement element) {
        Script script;
        if (element instanceof EclContext && (script = ((EclContext)element).getScript()) != null) {
            return script.getContent();
        }
        return "";
    }

    protected void setEclContext(NamedElement element, String value) {
        if (element instanceof EclContext) {
            Script sc = CoreFactory.eINSTANCE.createScript();
            sc.setContent(value);
            ((EclContext)element).setScript(sc);
        }
    }

    protected void checkReferences() {
    }

    protected EditorHeader createEditorHeader() {
        return new EditorHeader(this.getModel(), this.getElement()){

            protected Button createRecordButton(Composite composite, FormToolkit toolkit) {
                Button button = toolkit.createButton(composite, Messages.ContextEditorPage_CaptureButtonText, 8);
                button.setImage(Images.getImage((String)"icons/camera.png"));
                button.setBackground(null);
                GridDataFactory.fillDefaults().applyTo((Control)button);
                button.setEnabled(false);
                return button;
            }

            protected Button createReplayButton(Composite composite, FormToolkit toolkit) {
                Button button = toolkit.createButton(composite, Messages.ContextEditorPage_ApplyButtonText, 8);
                button.setImage(DebugUITools.getImage((String)"IMG_ACT_RUN"));
                button.setBackground(null);
                GridDataFactory.fillDefaults().applyTo((Control)button);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if ((e.stateMask & 0x20000) != 0) {
                            this.multiReplay();
                        } else {
                            this.replay();
                        }
                    }
                });
                return button;
            }

            protected void record() {
            }
        };
    }

    protected EditorContent createEditorContent() {
        return new EditorContent(this.header, false, true);
    }

    protected EclDocumentProvider createDocumentProvider() {
        return new EclDocumentProvider(){

            protected String getScriptContent(EclEditorInput element) throws ModelException {
                if (element.getElement() instanceof IContext) {
                    IContext eclContext = (IContext)element.getElement();
                    return EclContextEditor.this.getEclContext(eclContext.getNamedElement());
                }
                return "";
            }
        };
    }

    protected void bindScriptContent() {
        super.bindScriptContent();
        IChangeListener scenarioContentListener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                String doc;
                String script;
                try {
                    script = EclContextEditor.this.getEclContext(EclContextEditor.this.getElement());
                }
                catch (Exception e) {
                    script = "Ecl context loading failed. See error log for details.";
                    Q7UIPlugin.log((Throwable)e);
                }
                if (EclContextEditor.this.viewer.getDocument() != null && !(doc = EclContextEditor.this.viewer.getDocument().get()).equals(script)) {
                    EclContextEditor.this.viewer.getDocument().set(script);
                }
            }
        };
        IObservableValue scriptContent = EMFObservables.observeValue((EObject)this.getElement(), (EStructuralFeature)ContextPackage.Literals.ECL_CONTEXT__SCRIPT);
        scriptContent.addChangeListener(scenarioContentListener);
    }
}

