/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.utils;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class WriteAccessChecker {
    private Shell shell;
    private boolean currentThread = true;
    static final Function<IQ7Element, IResource> toResource = new Function<IQ7Element, IResource>(){

        public IResource apply(IQ7Element input) {
            return input.getResource();
        }
    };
    static final Function<IResource, String> toPath = new Function<IResource, String>(){

        public String apply(IResource input) {
            return input.getFullPath().toOSString();
        }
    };

    public WriteAccessChecker(Shell shell) {
        this.shell = shell;
    }

    public WriteAccessChecker(Shell shell, boolean currentThread) {
        this.shell = shell;
        this.currentThread = currentThread;
    }

    public WriteAccessChecker() {
    }

    private IQ7Element[] findReadOnly(IQ7Element ... models) {
        ArrayList<IQ7Element> readOnly = new ArrayList<IQ7Element>();
        IQ7Element[] iQ7ElementArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7Element model = iQ7ElementArray[n2];
            if (WriteAccessChecker.isReadOnly(model) && !readOnly.contains(model)) {
                readOnly.add(model);
            }
            ++n2;
        }
        return (IQ7Element[])Iterables.toArray(readOnly, IQ7Element.class);
    }

    public static boolean isReadOnly(IQ7Element file) {
        return file.getResource().getResourceAttributes() != null && file.getResource().getResourceAttributes().isReadOnly();
    }

    private IResource[] findReadOnly(IResource ... files) {
        ArrayList<IResource> readOnly = new ArrayList<IResource>();
        IResource[] iResourceArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IResource file = iResourceArray[n2];
            if (WriteAccessChecker.isReadOnly(file) && !readOnly.contains(file)) {
                readOnly.add(file);
            }
            ++n2;
        }
        return (IResource[])Iterables.toArray(readOnly, IResource.class);
    }

    public static boolean isReadOnly(IResource file) {
        return file.getResourceAttributes() != null && file.getResourceAttributes().isReadOnly();
    }

    public boolean makeResourceWritable(List<IQ7Element> references) throws CoreException {
        return this.makeResourceWritable(references.toArray(new IQ7Element[0]));
    }

    public boolean makeResourceWritable(IQ7Element ... models) throws CoreException {
        IQ7Element[] readOnly = this.findReadOnly(models);
        if (readOnly.length == 0) {
            return true;
        }
        String filesStr = Joiner.on((String)",\n").join((Iterable)Collections2.transform(Arrays.asList(readOnly), (Function)Functions.compose(toPath, toResource)));
        if (!this.showDialog(filesStr)) {
            return false;
        }
        IQ7Element[] iQ7ElementArray = readOnly;
        int n = readOnly.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7Element model = iQ7ElementArray[n2];
            WriteAccessChecker.setWritable((IResource)((IFile)model.getResource()), true);
            ++n2;
        }
        return true;
    }

    public boolean makeResourceWritable(IResource ... models) throws CoreException {
        Object[] readOnly = this.findReadOnly(models);
        if (readOnly.length == 0) {
            return true;
        }
        String filesStr = Joiner.on((String)",\n").join(readOnly);
        if (!this.showDialog(filesStr)) {
            return false;
        }
        Object[] objectArray = readOnly;
        int n = readOnly.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            WriteAccessChecker.setWritable((IResource)file, true);
            ++n2;
        }
        return true;
    }

    public static void setWritable(IResource file, boolean writable) throws CoreException {
        ResourceAttributes attributes = file.getResourceAttributes();
        if (attributes != null) {
            attributes.setReadOnly(!writable);
        }
        file.setResourceAttributes(attributes);
    }

    private boolean showDialog(final String filesStr) {
        if (!this.currentThread || this.shell == null) {
            final boolean[] answer = new boolean[1];
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (WriteAccessChecker.this.shell == null) {
                        WriteAccessChecker.this.shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    }
                    answer[0] = MessageDialog.openQuestion((Shell)WriteAccessChecker.this.shell, (String)Messages.ResourceAccessDialog_Title, (String)NLS.bind((String)Messages.ResourceAccessDialog_Message, (Object[])new String[]{filesStr}));
                }
            });
            return answer[0];
        }
        return MessageDialog.openQuestion((Shell)this.shell, (String)Messages.ResourceAccessDialog_Title, (String)NLS.bind((String)Messages.ResourceAccessDialog_Message, (Object[])new String[]{filesStr}));
    }
}

