/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.search.dependencies.GatherUnusedDependenciesOperation;
import org.eclipse.pde.internal.ui.search.dependencies.ShowResultsAction;
import org.eclipse.swt.widgets.Display;

public class UnusedDependenciesJob
extends Job {
    private final IPluginModelBase fModel;
    private final boolean fReadOnly;

    public UnusedDependenciesJob(String name, IPluginModelBase model, boolean readOnly) {
        super(name);
        this.fModel = model;
        this.fReadOnly = readOnly;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            try {
                GatherUnusedDependenciesOperation udo = new GatherUnusedDependenciesOperation(this.fModel);
                udo.run(monitor);
                this.showResults(udo.getList().toArray());
            }
            catch (InterruptedException | InvocationTargetException exception) {
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private Action getShowResultsAction(Object[] unused) {
        return new ShowResultsAction(this.fModel, unused, this.fReadOnly);
    }

    protected void showResults(Object[] unused) {
        Display.getDefault().asyncExec(() -> this.getShowResultsAction(unused).run());
    }
}

