/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.swt.e3x.rap;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.swt.workbench.IEclipseWorkbenchProvider;
import org.eclipse.rcptt.tesla.ui.RWTUtils;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewStackTrimToolBar;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.presentations.PaneFolder;
import org.eclipse.ui.internal.presentations.PaneFolderButtonListener;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultTabFolder;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class ClassicEclipseWorkbenchProvider
implements IEclipseWorkbenchProvider {
    private Version rapVersion;
    private static final List<String> viewTooltips = Arrays.asList("View Menu", "Maximize", "Minimize", "Restore");

    public Menu getViewMenu(IWorkbenchPart workbenchPart, IWorkbenchPartReference reference, boolean create) {
        if (workbenchPart.getSite() == null) {
            return null;
        }
        PartPane pane = ((PartSite)workbenchPart.getSite()).getPane();
        if (!(pane instanceof ViewPane)) {
            return null;
        }
        MenuManager menuManager = ((ViewPane)pane).getMenuManager();
        if (menuManager == null) {
            return null;
        }
        Menu menu = menuManager.getMenu();
        if (menu != null && !menu.isDisposed()) {
            return menu;
        }
        if (!create) {
            return null;
        }
        menuManager.createContextMenu((Control)pane.getControl().getParent());
        return menuManager.getMenu();
    }

    public List<?> getPaneFolderButtonListeners(Object paneFolder) {
        try {
            Field field = PaneFolder.class.getDeclaredField("buttonListeners");
            field.setAccessible(true);
            return (List)field.get(paneFolder);
        }
        catch (Throwable e) {
            TeslaCore.log((Throwable)e);
            return null;
        }
    }

    public Control getToolbar(IWorkbenchPartReference reference) {
        return ((WorkbenchPartReference)reference).getPane().getToolBar();
    }

    public boolean canClickView(IWorkbenchPartReference reference) {
        IWorkbenchPage page = reference.getPage();
        Perspective perspective = ((WorkbenchPage)page).getActivePerspective();
        IWorkbenchPart part = reference.getPart(true);
        return part == null || !(part instanceof IViewPart) || perspective.containsView((IViewPart)part);
    }

    public Map<Control, SWTUIElement> getWorkbenchReference(SWTUIPlayer player) {
        if (RWTUtils.getWorkbench() == null) {
            return Collections.emptyMap();
        }
        IWorkbenchWindow[] windows = RWTUtils.getWorkbench().getWorkbenchWindows();
        if (!Display.getCurrent().equals(RWTUtils.getWorkbench().getDisplay())) {
            return new HashMap<Control, SWTUIElement>();
        }
        HashMap<Control, SWTUIElement> references = new HashMap<Control, SWTUIElement>();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows;
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            Control toolBar;
            Control control;
            WorkbenchPartReference ref;
            IViewReference[] views;
            IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n2];
            IWorkbenchPage page = iWorkbenchWindow.getActivePage();
            IEditorReference[] editors = page.getEditorReferences();
            IViewReference[] iViewReferenceArray = views = page.getViewReferences();
            int n3 = views.length;
            int n4 = 0;
            while (n4 < n3) {
                IViewReference iViewReference = iViewReferenceArray[n4];
                ref = (WorkbenchPartReference)iViewReference;
                if (ref.getVisible()) {
                    control = ref.getPane().getControl();
                    references.put(control, player.wrap((Object)ref));
                    toolBar = ref.getPane().getToolBar();
                    if (toolBar != null) {
                        references.put(toolBar, player.wrap((Object)ref));
                    }
                }
                ++n4;
            }
            iViewReferenceArray = editors;
            n3 = editors.length;
            n4 = 0;
            while (n4 < n3) {
                IViewReference iEditorReference = iViewReferenceArray[n4];
                ref = (WorkbenchPartReference)iEditorReference;
                if (ref.getVisible()) {
                    control = ref.getPane().getControl();
                    references.put(control, player.wrap((Object)ref));
                    toolBar = ref.getPane().getToolBar();
                    if (toolBar != null) {
                        references.put(toolBar, player.wrap((Object)ref));
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return references;
    }

    public void processTabFolderButton(Widget widget, int buttonId) {
        if (!(widget instanceof CTabFolder) && widget instanceof Control) {
            Composite parent = ((Control)widget).getParent();
            if (parent == null) {
                return;
            }
            Control[] controlArray = parent.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                PartStack stack;
                PartPane selection;
                Object data;
                Control c = controlArray[n2];
                if (c instanceof CTabFolder && !c.isDisposed() && (data = ((CTabFolder)c).getData()) instanceof PartStack && (selection = (stack = (PartStack)data).getSelection()) != null && selection.getControl() == widget) {
                    widget = c;
                }
                ++n2;
            }
        }
        if (!(widget instanceof CTabFolder)) {
            return;
        }
        PaneFolder paneFolder = (PaneFolder)TeslaSWTAccess.getThis(PaneFolder.class, (Widget)widget, (int)12);
        if (paneFolder != null) {
            List<?> listenters = this.getPaneFolderButtonListeners(paneFolder);
            for (Object listener : listenters) {
                if (!(listener instanceof PaneFolderButtonListener)) continue;
                ((PaneFolderButtonListener)listener).stateButtonPressed(buttonId);
            }
        }
    }

    public void processTabShowList(Widget widget) {
        if (!(widget instanceof CTabFolder) && widget instanceof Control) {
            Composite parent = ((Control)widget).getParent();
            if (parent == null) {
                return;
            }
            Control[] controlArray = parent.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                PartStack stack;
                PartPane selection;
                Object data;
                Control c = controlArray[n2];
                if (c instanceof CTabFolder && !c.isDisposed() && (data = ((CTabFolder)c).getData()) instanceof PartStack && (selection = (stack = (PartStack)data).getSelection()) != null && selection.getControl() == widget) {
                    widget = c;
                }
                ++n2;
            }
        }
        if (!(widget instanceof CTabFolder)) {
            return;
        }
        PaneFolder paneFolder = (PaneFolder)TeslaSWTAccess.getThis(PaneFolder.class, (Widget)widget, (int)12);
        if (paneFolder != null) {
            List<?> listenters = this.getPaneFolderButtonListeners(paneFolder);
            for (Object listener : listenters) {
                if (!(listener instanceof PaneFolderButtonListener)) continue;
                CTabFolderEvent event = TeslaSWTAccess.createCTabFolderEvent((Widget)widget);
                ((PaneFolderButtonListener)listener).showList(event);
            }
        }
    }

    public boolean isVisible(IWorkbenchPartReference reference) {
        return reference instanceof WorkbenchPartReference && ((WorkbenchPartReference)reference).getVisible();
    }

    public boolean isActiveContainsView(IWorkbenchPage page, IWorkbenchPartReference reference) {
        Perspective perspective = ((WorkbenchPage)page).getActivePerspective();
        IWorkbenchPart part = reference.getPart(true);
        return part == null || !(part instanceof IViewPart) || perspective.containsView((IViewPart)part);
    }

    public boolean isSupported() {
        if (this.rapVersion == null) {
            Bundle rapUIBundle = Platform.getBundle((String)"org.eclipse.rap.ui");
            this.rapVersion = rapUIBundle != null ? rapUIBundle.getVersion() : Version.emptyVersion;
        }
        return this.rapVersion.getMajor() == 3;
    }

    public boolean isViewOrEditorButton(Widget widget) {
        if (!(widget instanceof ToolItem)) {
            return false;
        }
        ToolItem item = (ToolItem)widget;
        if (!viewTooltips.contains(item.getToolTipText())) {
            return false;
        }
        if (TeslaSWTAccess.getThis(DefaultTabFolder.class, (Widget)item.getParent(), (int)3) != null) {
            return true;
        }
        return TeslaSWTAccess.getThis(ViewStackTrimToolBar.class, (Object)item.getData()) != null;
    }

    public Widget extractViewOrEditorControl(CTabFolder tabFolder) {
        PartStack stack;
        PartPane selection;
        Object data = tabFolder.getData();
        if (data instanceof PartStack && (selection = (stack = (PartStack)data).getSelection()) != null) {
            return selection.getControl();
        }
        return null;
    }

    public CTabFolder getTabFolderFromButton(ToolItem button) {
        return null;
    }

    public Text getQuickAccess() {
        return null;
    }

    public void updateActiveSelection(List<Object> selectionData, SWTUIElement parent) {
    }

    public String getViewId(Widget widget) {
        if (widget instanceof Composite) {
            Listener[] listenerArray = widget.getListeners(26);
            int n = listenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Listener l = listenerArray[n2];
                if (l instanceof ViewPane) {
                    return ((ViewPane)l).getID();
                }
                ++n2;
            }
        }
        return null;
    }
}

