/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.api.tools.internal.ApiDescription;
import org.eclipse.pde.api.tools.internal.NonApiProjectDescription;
import org.eclipse.pde.api.tools.internal.ProjectApiDescription;
import org.eclipse.pde.api.tools.internal.model.ApiModelCache;
import org.eclipse.pde.api.tools.internal.model.ProjectComponent;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.scanner.ScannerMessages;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ApiDescriptionManager
implements ISaveParticipant {
    private static ApiDescriptionManager fgDefault;
    private final Map<IJavaProject, IApiDescription> fDescriptions = new HashMap<IJavaProject, IApiDescription>();
    public static final IPath API_DESCRIPTIONS_CONTAINER_PATH;

    static {
        API_DESCRIPTIONS_CONTAINER_PATH = ApiPlugin.getDefault().getStateLocation();
    }

    private ApiDescriptionManager() {
        ApiPlugin.getDefault().addSaveParticipant(this);
    }

    public static void shutdown() {
        if (fgDefault != null) {
            ApiPlugin.getDefault().removeSaveParticipant(fgDefault);
        }
    }

    public static synchronized ApiDescriptionManager getManager() {
        if (fgDefault == null) {
            fgDefault = new ApiDescriptionManager();
        }
        return fgDefault;
    }

    public synchronized IApiDescription getApiDescription(ProjectComponent component, BundleDescription bundle) {
        IJavaProject project = component.getJavaProject();
        ProjectApiDescription description = (ProjectApiDescription)this.fDescriptions.get(project);
        if (description == null) {
            description = Util.isApiProject(project) ? new ProjectApiDescription(project) : new NonApiProjectDescription(project);
            try {
                this.restoreDescription(project, description);
            }
            catch (CoreException e) {
                ApiPlugin.log(e.getStatus());
                description = new ProjectApiDescription(project);
            }
            this.fDescriptions.put(project, description);
        }
        return description;
    }

    public synchronized void clean(IJavaProject project, boolean delete, boolean remove) {
        ProjectApiDescription desc = null;
        desc = remove ? (ProjectApiDescription)this.fDescriptions.remove(project) : (ProjectApiDescription)this.fDescriptions.get(project);
        if (desc != null) {
            desc.clean();
        }
        if (delete) {
            File file = API_DESCRIPTIONS_CONTAINER_PATH.append(project.getElementName()).append(".api_description").toFile();
            if (file.exists()) {
                file.delete();
            }
            if ((file = API_DESCRIPTIONS_CONTAINER_PATH.append(project.getElementName()).toFile()).exists() && file.isDirectory()) {
                file.delete();
            }
        }
    }

    synchronized void projectChanged(IJavaProject project) {
        ProjectApiDescription desc = (ProjectApiDescription)this.fDescriptions.get(project);
        if (desc != null) {
            desc.projectChanged();
        }
    }

    synchronized void projectClasspathChanged(IJavaProject project) {
        ProjectApiDescription desc = (ProjectApiDescription)this.fDescriptions.get(project);
        if (desc != null) {
            desc.projectClasspathChanged();
        }
    }

    void flushElementCache(IJavaElement element) {
        switch (element.getElementType()) {
            case 5: {
                ICompilationUnit unit = (ICompilationUnit)element;
                IType type = unit.findPrimaryType();
                if (type == null) break;
                ApiModelCache.getCache().removeElementInfo("workspace", element.getJavaProject().getElementName(), type.getFullyQualifiedName(), 2);
                break;
            }
            case 2: {
                ApiModelCache.getCache().removeElementInfo("workspace", element.getElementName(), null, 1);
                break;
            }
        }
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public synchronized void saving(ISaveContext context) throws CoreException {
        if (context.getKind() == 3 && !Util.isJavaProject(context.getProject())) {
            return;
        }
        for (Map.Entry<IJavaProject, IApiDescription> entry : this.fDescriptions.entrySet()) {
            IJavaProject project = entry.getKey();
            ProjectApiDescription desc = (ProjectApiDescription)entry.getValue();
            if (!desc.isModified()) continue;
            File dir = API_DESCRIPTIONS_CONTAINER_PATH.append(project.getElementName()).toFile();
            dir.mkdirs();
            String xml = desc.getXML();
            try {
                Util.saveFile(new File(dir, ".api_description"), xml);
                desc.setModified(false);
            }
            catch (IOException e) {
                ApiDescriptionManager.abort(MessageFormat.format(ScannerMessages.ApiDescriptionManager_0, project.getElementName()), e);
            }
        }
    }

    private boolean restoreDescription(IJavaProject project, ProjectApiDescription description) throws CoreException {
        File file = API_DESCRIPTIONS_CONTAINER_PATH.append(project.getElementName()).append(".api_description").toFile();
        if (file.exists()) {
            try {
                String xml = Files.readString(file.toPath());
                Element root = Util.parseDocument(xml);
                if (!root.getNodeName().equals("component")) {
                    ApiDescriptionManager.abort(ScannerMessages.ComponentXMLScanner_0, null);
                }
                long timestamp = this.getLong(root, "modificationStamp");
                String version = root.getAttribute("version");
                description.setEmbeddedVersion(version);
                if ("1.2".equals(version)) {
                    description.fPackageTimeStamp = timestamp;
                    description.fManifestFile = project.getProject().getFile("META-INF/MANIFEST.MF");
                    this.restoreChildren(description, root, null, description.fPackageMap);
                    return true;
                }
            }
            catch (IOException e) {
                ApiDescriptionManager.abort(MessageFormat.format(ScannerMessages.ApiDescriptionManager_1, project.getElementName()), e);
            }
        }
        return false;
    }

    private void restoreChildren(ProjectApiDescription apiDesc, Element element, ApiDescription.ManifestNode parentNode, Map<IElementDescriptor, ApiDescription.ManifestNode> childrenMap) throws CoreException {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                this.restoreNode(apiDesc, (Element)child, parentNode, childrenMap);
            }
            ++i;
        }
    }

    private void restoreNode(ProjectApiDescription apiDesc, Element element, ApiDescription.ManifestNode parentNode, Map<IElementDescriptor, ApiDescription.ManifestNode> childrenMap) throws CoreException {
        ApiDescription.ManifestNode node = null;
        IElementDescriptor elementDesc = null;
        switch (element.getTagName()) {
            case "package": {
                int vis = this.getInt(element, "visibility");
                int res = this.getInt(element, "restrictions");
                ArrayList<IJavaElement> fragments = new ArrayList<IJavaElement>();
                NodeList childNodes = element.getChildNodes();
                String pkgName = null;
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node child = childNodes.item(i);
                    if (child.getNodeType() == 1 && ((Element)child).getTagName().equals("fragment")) {
                        Element fragment = (Element)child;
                        String handle = fragment.getAttribute("handle");
                        IJavaElement je = JavaCore.create((String)handle);
                        if (je.getElementType() != 4) {
                            ApiDescriptionManager.abort(ScannerMessages.ApiDescriptionManager_2 + handle, null);
                        }
                        pkgName = je.getElementName();
                        fragments.add(je);
                    }
                    ++i;
                }
                if (!fragments.isEmpty()) {
                    elementDesc = Factory.packageDescriptor(pkgName);
                    node = apiDesc.newPackageNode(fragments.toArray(new IPackageFragment[fragments.size()]), parentNode, elementDesc, vis, res);
                    break;
                }
                ApiDescriptionManager.abort(ScannerMessages.ApiDescriptionManager_2, null);
                break;
            }
            case "type": {
                String handle = element.getAttribute("handle");
                int vis = this.getInt(element, "visibility");
                int res = this.getInt(element, "restrictions");
                IJavaElement je = JavaCore.create((String)handle);
                if (je.getElementType() != 7) {
                    ApiDescriptionManager.abort(ScannerMessages.ApiDescriptionManager_3 + handle, null);
                }
                IType type = (IType)je;
                elementDesc = Factory.typeDescriptor(type.getFullyQualifiedName('$'));
                ProjectApiDescription.TypeNode tn = apiDesc.newTypeNode(type, parentNode, elementDesc, vis, res);
                node = tn;
                tn.fTimeStamp = this.getLong(element, "modificationStamp");
                break;
            }
            case "field": {
                if (!(parentNode.element instanceof IReferenceTypeDescriptor)) break;
                IReferenceTypeDescriptor type = (IReferenceTypeDescriptor)parentNode.element;
                int vis = this.getInt(element, "visibility");
                int res = this.getInt(element, "restrictions");
                String name = element.getAttribute("name");
                elementDesc = type.getField(name);
                node = apiDesc.newNode(parentNode, elementDesc, vis, res);
                break;
            }
            case "method": {
                if (!(parentNode.element instanceof IReferenceTypeDescriptor)) break;
                IReferenceTypeDescriptor type = (IReferenceTypeDescriptor)parentNode.element;
                int vis = this.getInt(element, "visibility");
                int res = this.getInt(element, "restrictions");
                String name = element.getAttribute("name");
                String sig = element.getAttribute("signature");
                if (sig.indexOf(46) != -1) {
                    sig = sig.replace('.', '/');
                }
                elementDesc = type.getMethod(name, sig);
                node = apiDesc.newNode(parentNode, elementDesc, vis, res);
                break;
            }
            case "fragment": {
                return;
            }
        }
        if (node != null) {
            childrenMap.put(elementDesc, node);
            this.restoreChildren(apiDesc, element, node, node.children);
        } else {
            ApiDescriptionManager.abort(ScannerMessages.ApiDescriptionManager_4, null);
        }
    }

    private int getInt(Element element, String attr) {
        String attribute = element.getAttribute(attr);
        try {
            return Integer.parseInt(attribute);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private long getLong(Element element, String attr) {
        String attribute = element.getAttribute(attr);
        if (attribute != null) {
            try {
                return Long.parseLong(attribute);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    private static void abort(String message, Throwable exception) throws CoreException {
        IStatus status = Status.error((String)message, (Throwable)exception);
        throw new CoreException(status);
    }
}

