/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.player.specific;

import org.eclipse.rcptt.tesla.internal.ui.player.PlayerSelectionFilter;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.swt.util.GetWindowUtil;
import org.eclipse.rcptt.tesla.swt.util.IndexUtil;
import org.eclipse.swt.widgets.Shell;

public class GetWindowPlayer {
    private SWTUIPlayer player;
    private SWTUIElement[] ignoreWindows;

    public GetWindowPlayer(SWTUIPlayer player, SWTUIElement[] ignoreWindows) {
        this.player = player;
        this.ignoreWindows = ignoreWindows;
    }

    public SWTUIElement selectShell(PlayerSelectionFilter f) {
        String from = GetWindowUtil.decodeFrom(f.path);
        if (from != null) {
            return this.selectShellBy(f, GetWindowUtil.byFrom(from));
        }
        String klass = GetWindowUtil.decodeClass(f.path);
        if (klass != null) {
            return this.selectShellBy(f, GetWindowUtil.byClass(klass));
        }
        String pattern = f.pattern != null ? f.pattern.trim() : null;
        return this.selectShellBy(f, GetWindowUtil.byText(pattern));
    }

    private SWTUIElement selectShellBy(PlayerSelectionFilter f, IndexUtil.Criterion crite) {
        return this.selectShellBy(f.parent, f.index, f.after, crite);
    }

    private SWTUIElement selectShellBy(SWTUIElement parent, Integer index, SWTUIElement after, IndexUtil.Criterion crite) {
        SWTUIElement ret = IndexUtil.selectFrom(this.children(parent, after), index, crite);
        if (ret != null) {
            return ret;
        }
        if (parent != null) {
            return this.selectShellBy(null, index, after, crite);
        }
        return null;
    }

    private SWTUIElement[] children(SWTUIElement parent, SWTUIElement after) {
        Class[] classes = new Class[]{Shell.class};
        return this.player.children.collectFor(parent, this.ignoreWindows, true, classes, after);
    }
}

