/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.debug.ui.actions.ToggleBreakpointAction;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BlockTextSelection;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.rcptt.core.Scenarios;
import org.eclipse.rcptt.core.ecl.parser.model.OccurrencesSettings;
import org.eclipse.rcptt.core.model.IElementChangedListener;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7ElementDelta;
import org.eclipse.rcptt.core.model.IQ7Folder;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.Q7ElementChangedEvent;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.core.scenario.ScenarioPackage;
import org.eclipse.rcptt.core.workspace.Q7Utils;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.launching.Q7LaunchManager;
import org.eclipse.rcptt.internal.ui.HookUtils;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.builder.NamedElementReferencesResolver;
import org.eclipse.rcptt.ui.debug.EclLineBreakpointAdapter;
import org.eclipse.rcptt.ui.debug.ToggleBreakpointEnablementAction;
import org.eclipse.rcptt.ui.dialogs.AddProjectReferencesDialog;
import org.eclipse.rcptt.ui.dialogs.ChangesWarningDialog;
import org.eclipse.rcptt.ui.dialogs.RemoveProjectReferencesDialog;
import org.eclipse.rcptt.ui.editors.EditorContent;
import org.eclipse.rcptt.ui.editors.EditorHeader;
import org.eclipse.rcptt.ui.editors.FilenameUpdater;
import org.eclipse.rcptt.ui.editors.INamedElementEditor;
import org.eclipse.rcptt.ui.editors.ScriptSection;
import org.eclipse.rcptt.ui.editors.context.ContextEditor;
import org.eclipse.rcptt.ui.editors.ecl.ECLEditorPlugin;
import org.eclipse.rcptt.ui.editors.ecl.EclContentAssistProcessor;
import org.eclipse.rcptt.ui.editors.ecl.EclDocumentProvider;
import org.eclipse.rcptt.ui.editors.ecl.EclEditorInput;
import org.eclipse.rcptt.ui.editors.ecl.EclSourceViewer;
import org.eclipse.rcptt.ui.editors.ecl.EclSourceViewerConfiguration;
import org.eclipse.rcptt.ui.editors.ecl.EnhancedSourceViewer;
import org.eclipse.rcptt.ui.editors.ecl.MarkAllOccurencesJob;
import org.eclipse.rcptt.ui.editors.ecl.MarkAllOccurencesJobCanceler;
import org.eclipse.rcptt.ui.editors.ecl.actions.EclContentAssistAction;
import org.eclipse.rcptt.ui.editors.ecl.actions.EclOpenDeclarationAction;
import org.eclipse.rcptt.ui.editors.ecl.actions.EclScrollLinesAction;
import org.eclipse.rcptt.ui.editors.ecl.actions.EclTextNavigationAction;
import org.eclipse.rcptt.ui.editors.ecl.actions.FormatAction;
import org.eclipse.rcptt.ui.editors.ecl.actions.NavigateNextSubWordAction;
import org.eclipse.rcptt.ui.editors.ecl.actions.NavigatePreviousSubWordAction;
import org.eclipse.rcptt.ui.editors.ecl.actions.SelectNextSubWordAction;
import org.eclipse.rcptt.ui.editors.ecl.actions.SelectPreviousSubWordAction;
import org.eclipse.rcptt.ui.editors.ecl.actions.SmartLineEndAction;
import org.eclipse.rcptt.ui.editors.ecl.actions.SmartLineStartAction;
import org.eclipse.rcptt.ui.editors.ecl.actions.ToggleCommentAction;
import org.eclipse.rcptt.ui.panels.main.ControlPanelWindow;
import org.eclipse.rcptt.ui.utils.WorkbenchUtils;
import org.eclipse.rcptt.ui.utils.WriteAccessChecker;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.operations.OperationHistoryActionHandler;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;

public class EclEditor
extends AbstractDecoratedTextEditor
implements IElementChangedListener,
IGotoMarker,
INamedElementEditor,
IEclipsePreferences.IPreferenceChangeListener {
    public EclSourceViewer viewer;
    private IQ7NamedElement model;
    private NamedElement element;
    private IQ7NamedElement handle;
    private FilenameUpdater filenameUpdater;
    private List<IAction> actions = new ArrayList<IAction>();
    private final Object reconcilerLock = new Object();
    private Annotation[] occurrencesAnnotations = null;
    private MarkAllOccurencesJob occurrencesFinderJob = null;
    private MarkAllOccurencesJobCanceler occurrencesFinderJobCanceler = null;
    private ISelectionListener occurrencesPostSelectionListener = null;
    private int highlightedLine = -1;
    private static final String SCENARIO_ERROR = "Test case contains errors. Please see error log for details.";
    public EditorHeader header;
    public EditorContent editorContent;
    private static final String GO_TO_DECLARATION_ACTION = "org.eclipse.rcptt.ui.actions.open.declaration";
    private static final String GO_TO_DECLARATION_GROUP = "GROUP_DECLARATION";
    private static final String FORMAT_ACTION = "org.eclipse.rcptt.ui.edit.text.ecl.format.source";
    public static final String EDITOR_MATCHING_BRACKETS = "matchingBrackets";
    public static final String EDITOR_MATCHING_BRACKETS_COLOR = "matchingBracketsColor";

    public void selectLine(int start, int length) {
        this.selectAndReveal(start, length);
        this.setFocus();
    }

    public MarkAllOccurencesJob getMarkAllOccurencesJob() {
        return this.occurrencesFinderJob;
    }

    public void replaceOccurencesAnnotation(IAnnotationModel annotationModel, Map<Annotation, Position> annotationsToAdd) {
        ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.occurrencesAnnotations, annotationsToAdd);
    }

    public void setOccurencesAnnotation(Annotation[] arr) {
        this.occurrencesAnnotations = arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOccurrenceAnnotations() {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null || this.occurrencesAnnotations == null) {
            return;
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.occurrencesAnnotations, null);
            } else {
                int i = 0;
                int length = this.occurrencesAnnotations.length;
                while (i < length) {
                    annotationModel.removeAnnotation(this.occurrencesAnnotations[i]);
                    ++i;
                }
            }
            this.occurrencesAnnotations = null;
        }
    }

    public Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    private void updateOccurrenceAnnotations(ITextSelection selection) {
        OccurrencesSettings settings = ECLEditorPlugin.getMarkSettings();
        if (this.occurrencesFinderJob != null) {
            this.occurrencesFinderJob.cancel();
        }
        if (!settings.enabled) {
            this.removeOccurrenceAnnotations();
            return;
        }
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer == null) {
            return;
        }
        IDocument document = viewer.getDocument();
        if (document == null) {
            return;
        }
        this.occurrencesFinderJob = new MarkAllOccurencesJob(selection, this);
        this.occurrencesFinderJob.run((IProgressMonitor)new NullProgressMonitor());
    }

    private void installOccurrencesFinder() {
        ISelectionProvider selectionProvider;
        IDocument document = this.viewer.getDocument();
        if (document != null && (selectionProvider = this.getSelectionProvider()) != null) {
            new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    EclEditor.this.updateOccurrenceAnnotations((ITextSelection)event.getSelection());
                }
            };
            this.occurrencesPostSelectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    if ((part instanceof EclEditor || part instanceof ContextEditor) && selection instanceof ITextSelection) {
                        EclEditor.this.updateOccurrenceAnnotations((ITextSelection)selection);
                    }
                }
            };
            this.getEditorSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(this.occurrencesPostSelectionListener);
            if (this.occurrencesFinderJobCanceler == null) {
                this.occurrencesFinderJobCanceler = new MarkAllOccurencesJobCanceler();
                this.occurrencesFinderJobCanceler.install(this);
            }
        }
    }

    private void uninstallOccurrencesFinder() {
        ISelectionProvider selectionProvider;
        IDocument document;
        if (this.occurrencesFinderJob != null) {
            this.occurrencesFinderJob.cancel();
            this.occurrencesFinderJob = null;
        }
        if (this.occurrencesFinderJobCanceler != null) {
            this.occurrencesFinderJobCanceler.uninstall(this);
            this.occurrencesFinderJobCanceler = null;
        }
        if (this.viewer != null && (document = this.viewer.getDocument()) != null && (selectionProvider = this.getSelectionProvider()) != null) {
            this.getEditorSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.occurrencesPostSelectionListener);
        }
        this.removeOccurrenceAnnotations();
    }

    protected IVerticalRulerColumn createAnnotationRulerColumn(CompositeRuler ruler) {
        AnnotationRulerColumn column = (AnnotationRulerColumn)super.createAnnotationRulerColumn(ruler);
        column.addAnnotationType((Object)"org.eclipse.rcptt.core.builder.q7Problem");
        return column;
    }

    public void highlightLine(int line) {
        this.highlightedLine = line;
        this.getControl().redraw();
    }

    public void resetLineHighlighting() {
        this.highlightedLine = -1;
        this.getControl().redraw();
    }

    public EclEditor() {
        this.setDocumentProvider((IDocumentProvider)this.createDocumentProvider());
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new EclSourceViewerConfiguration(this));
        ECLEditorPlugin.getPreferences().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    protected EclDocumentProvider createDocumentProvider() {
        return new EclDocumentProvider();
    }

    @Override
    public boolean isDirty() {
        block3: {
            try {
                if (this.model != null) break block3;
                return false;
            }
            catch (ModelException e) {
                Q7UIPlugin.log(e);
                return true;
            }
        }
        return this.model.hasUnsavedChanges();
    }

    public EclSourceViewer getViewer() {
        return this.viewer;
    }

    private IFile getInputFile(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (IToggleBreakpointsTarget.class.isAssignableFrom(adapter) && this.model != null) {
            return new EclLineBreakpointAdapter(this.getModel().getResource());
        }
        if (IGotoMarker.class.isAssignableFrom(adapter)) {
            return this;
        }
        if (IResource.class.isAssignableFrom(adapter) && this.model != null) {
            return this.model.getResource();
        }
        if (ISourceViewer.class.isAssignableFrom(adapter)) {
            return this.getSourceViewer();
        }
        return super.getAdapter(adapter);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        try {
            IFile inputFile = this.getInputFile(input);
            if (inputFile == null) {
                throw new PartInitException(Messages.NamedElementEditor_InvalidInputType);
            }
            this.handle = (IQ7NamedElement)RcpttCore.create((IResource)inputFile);
            this.filenameUpdater = new FilenameUpdater(this.handle);
            this.updateElement();
            RcpttCore.addElementChangedListener((IElementChangedListener)this);
            this.setPartName(this.element.getName());
            this.scheduleCheckReferences();
            IEditorInput oldInput = this.getEditorInput();
            EclEditorInput newInput = this.createEditorInput();
            super.doSetInput((IEditorInput)newInput);
            if (oldInput != null && !oldInput.equals((Object)newInput)) {
                this.update(this.getModel(), (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Throwable e) {
            throw new PartInitException(Messages.NamedElementEditor_LoadingFailed, e);
        }
    }

    protected EclEditorInput createEditorInput() {
        return new EclEditorInput(this.model);
    }

    public IQ7NamedElement getModel() {
        return this.model;
    }

    public NamedElement getElement() {
        return this.element;
    }

    protected void afterMissingReferencesAdded() {
    }

    @Override
    public void renamed(boolean wasDirty) {
    }

    private void scheduleCheckReferences() {
        new Job(Messages.NamedElementEditor_Job){

            protected IStatus run(IProgressMonitor monitor) {
                EclEditor.this.checkReferences();
                return Status.OK_STATUS;
            }
        }.schedule(500L);
    }

    protected void checkReferences() {
        try {
            Map<IProject, Set<IQ7NamedElement>> missing;
            if (this.getModel() == null) {
                return;
            }
            IQ7Project prj = this.getModel().getQ7Project();
            IQ7ProjectMetadata metadata = prj.getMetadata();
            if (metadata != null && metadata.exists()) {
                String[] verifications;
                int n;
                final ArrayList<String> diff = new ArrayList<String>();
                String[] contexts = metadata.getContexts();
                if (contexts != null && contexts.length > 0) {
                    Scenario el = (Scenario)this.getElement();
                    EList ctxs = el.getContexts();
                    String[] stringArray = contexts;
                    n = contexts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String c = stringArray[n2];
                        if (ctxs.contains((Object)c)) {
                            diff.add(c);
                        }
                        ++n2;
                    }
                }
                if ((verifications = metadata.getVerifications()) != null && verifications.length > 0) {
                    Scenario el = (Scenario)this.getElement();
                    EList scenarioVerifications = el.getVerifications();
                    String[] stringArray = verifications;
                    int n3 = verifications.length;
                    n = 0;
                    while (n < n3) {
                        String v = stringArray[n];
                        if (scenarioVerifications.contains((Object)v)) {
                            diff.add(v);
                        }
                        ++n;
                    }
                }
                if (diff.size() > 0) {
                    this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (RemoveProjectReferencesDialog.open(EclEditor.this.getSite().getShell(), EclEditor.this.getModel(), diff)) {
                                EclEditor.this.editorContent.update(EclEditor.this.getModel(), EclEditor.this.getElement());
                            }
                        }
                    });
                }
            }
            if (!(missing = NamedElementReferencesResolver.resolveMissingReferences(this.getModel())).isEmpty()) {
                IFile file = Q7Utils.getLocation((NamedElement)this.getElement());
                final IProject project = file.getProject();
                this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (AddProjectReferencesDialog.open(EclEditor.this.getSite().getShell(), project, missing)) {
                            EclEditor.this.afterMissingReferencesAdded();
                        }
                    }
                });
            }
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
        }
    }

    private void updateElement() throws ModelException, PartInitException {
        this.makeWorkingCopy();
        this.element = this.model.getNamedElement();
        if (this.element == null) {
            this.discardWorkingCopy();
            throw new PartInitException(Messages.NamedElementEditor_InvalidInputFormat);
        }
        new ContentAdapter(this.element);
        this.firePropertyChange(260);
    }

    private void discardWorkingCopy() throws ModelException {
        if (this.model != null) {
            this.model.discardWorkingCopy();
            this.model = null;
        }
    }

    public void removed(NamedElement element) {
        WorkbenchUtils.uiRun(new Runnable(){

            @Override
            public void run() {
                EclEditor.this.getSite().getPage().closeEditor((IEditorPart)EclEditor.this, false);
            }
        });
    }

    private void makeWorkingCopy() throws ModelException {
        RcpttCore.removeElementChangedListener((IElementChangedListener)this);
        if (this.model != null) {
            this.discardWorkingCopy();
        }
        this.model = this.handle.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
        if (this.viewer != null) {
            this.viewer.setElement(this.model);
        }
        RcpttCore.addElementChangedListener((IElementChangedListener)this);
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        block8: {
            if (Q7LaunchManager.getInstance().isElementUnderDebugging((IQ7Element)this.model)) {
                new ChangesWarningDialog(this.getSite().getShell()).open();
            }
            RcpttCore.removeElementChangedListener((IElementChangedListener)this);
            Shell shell = this.getSite().getShell();
            WriteAccessChecker writeAccessChecker = new WriteAccessChecker(shell);
            if (writeAccessChecker.makeResourceWritable(new IQ7Element[]{this.model})) break block8;
            RcpttCore.addElementChangedListener((IElementChangedListener)this);
            return;
        }
        try {
            try {
                this.normalizeDelimeters(this.viewer.getDocument());
                this.model.commitWorkingCopy(true, monitor);
                this.setPartName(this.element.getName());
                this.firePropertyChange(257);
            }
            catch (Exception e) {
                Q7UIPlugin.log(e);
                RcpttCore.addElementChangedListener((IElementChangedListener)this);
            }
        }
        catch (Throwable throwable) {
            RcpttCore.addElementChangedListener((IElementChangedListener)this);
            throw throwable;
        }
        RcpttCore.addElementChangedListener((IElementChangedListener)this);
        try {
            this.filenameUpdater.update(this.model);
        }
        catch (Exception e) {
            Q7UIPlugin.log(e);
        }
    }

    private void normalizeDelimeters(IDocument doc) throws BadLocationException {
        int i = 0;
        while (i < doc.getNumberOfLines()) {
            String delim = doc.getLineDelimiter(i);
            if (delim != null && delim.length() > 1) {
                int offset = doc.getLineOffset(i);
                int len = doc.getLineLength(i);
                doc.replace(offset + len - delim.length(), delim.length(), "\n");
            }
            ++i;
        }
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(parent);
        parent.setLayoutData((Object)new GridData(1808));
        Composite top = toolkit.createComposite(parent);
        top.setLayoutData((Object)new GridData(1808));
        this.header = this.createEditorHeader();
        Composite content = this.header.createContent(top, toolkit);
        this.editorContent = this.createEditorContent();
        this.editorContent.createSections(content, toolkit);
        this.editorContent.setSelectionProvider(this.getSite());
        ScriptSection section = this.editorContent.getScriptSection();
        if (section != null) {
            ToolBarManager manager = new ToolBarManager(0x800100);
            ToolBar toolBar = manager.createControl(section.getToolbar());
            toolBar.moveAbove(null);
            Action clearAction = new Action(){

                public void run() {
                    EclEditor.this.getViewer().getDocument().set("");
                }
            };
            clearAction.setImageDescriptor(Images.getImageDescriptor("icons/panel/clear.gif"));
            clearAction.setToolTipText(Messages.ScriptComposite_ClearActionToolTip);
            manager.add((IAction)clearAction);
            manager.update(true);
            super.createPartControl(section.getContent());
        }
        this.editorContent.setViewer(this.viewer);
        this.configureViewer();
        HookUtils.textHook(parent, new Runnable(){

            @Override
            public void run() {
                EclEditor.this.updateActions();
            }
        });
        this.getControl().addLineBackgroundListener(new LineBackgroundListener(){

            public void lineGetBackground(LineBackgroundEvent event) {
                if (EclEditor.this.highlightedLine != -1 && event.lineBackground == null) {
                    StyledText text = EclEditor.this.getControl();
                    if (EclEditor.this.highlightedLine == text.getLineAtOffset(event.lineOffset)) {
                        event.lineBackground = EclEditor.this.getControl().getDisplay().getSystemColor(29);
                    }
                }
            }
        });
        this.installOccurrencesFinder();
    }

    protected EditorContent createEditorContent() {
        return new EditorContent(this.header, true, true);
    }

    protected EditorHeader createEditorHeader() {
        return new EditorHeader(this.model, this.element){

            @Override
            protected void record() {
                if (EclEditor.this.model instanceof ITestCase) {
                    try {
                        ControlPanelWindow.openControlPanel(EclEditor.this.getEditorSite().getShell(), (ITestCase)EclEditor.this.model);
                    }
                    catch (ModelException e) {
                        Q7UIPlugin.log(e);
                        MessageDialog.openConfirm((Shell)EclEditor.this.getSite().getShell(), (String)Messages.ShowControlPanel_ErrorDialogTitle, (String)Messages.ShowControlPanel_ErrorDialogMsg);
                    }
                }
            }
        };
    }

    public void setAction(String actionID, IAction action) {
        super.setAction(actionID, action);
        this.actions.add(action);
    }

    private void updateActions() {
        this.updateContentDependentActions();
        this.updateSelectionDependentActions();
        this.updatePropertyDependentActions();
        this.updateStateDependentActions();
        boolean editorsActive = !(this.viewer != null && this.viewer.getControl() != null && this.viewer.getControl().isFocusControl() || !this.header.isInFocus() && !this.editorContent.isInFocus());
        this.updateEnabled(!editorsActive, "MoveLineDown", "MoveLineUp", "CopyLineUp", "CopyLineDown", "CutLine", "CutLineToBeginning", "CutLineToEnd");
        this.updateEnabled(!editorsActive, "ContentAssistProposal");
    }

    private void updateEnabled(boolean editorsActive, String ... ids) {
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            IAction action = this.getAction(id);
            if (action != null) {
                action.setEnabled(editorsActive);
            }
            ++n2;
        }
    }

    public void close(boolean save) {
        super.close(save);
        try {
            this.discardWorkingCopy();
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
        }
    }

    public void dispose() {
        try {
            this.discardWorkingCopy();
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
        }
        this.uninstallOccurrencesFinder();
        super.dispose();
        RcpttCore.removeElementChangedListener((IElementChangedListener)this);
    }

    protected ISourceViewer createSourceViewer(Composite parent, final IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        this.viewer = new EclSourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles){

            public void doOperation(int operation) {
                boolean headerInFocus = EclEditor.this.header.isInFocus();
                boolean editorInFocus = EclEditor.this.editorContent.isInFocus();
                if (!EclEditor.this.viewer.getControl().isFocusControl() && (headerInFocus || editorInFocus)) {
                    try {
                        switch (operation) {
                            case 7: {
                                if (headerInFocus) {
                                    EclEditor.this.header.doSelectAll();
                                    return;
                                }
                                if (editorInFocus) {
                                    EclEditor.this.editorContent.doSelectAll();
                                    return;
                                }
                                break;
                            }
                            case 4: {
                                if (headerInFocus) {
                                    EclEditor.this.header.copy();
                                    return;
                                }
                                if (editorInFocus) {
                                    EclEditor.this.editorContent.copy();
                                    return;
                                }
                                break;
                            }
                            case 3: {
                                if (headerInFocus) {
                                    EclEditor.this.header.cut();
                                    return;
                                }
                                if (editorInFocus) {
                                    EclEditor.this.editorContent.cut();
                                    return;
                                }
                                break;
                            }
                            case 5: {
                                if (headerInFocus) {
                                    EclEditor.this.header.paste();
                                    return;
                                }
                                if (editorInFocus) {
                                    EclEditor.this.editorContent.paste();
                                    return;
                                }
                                break;
                            }
                            case 1: {
                                if (headerInFocus) {
                                    EclEditor.this.header.undo();
                                    return;
                                }
                                if (editorInFocus) {
                                    EclEditor.this.editorContent.undo();
                                    return;
                                }
                            }
                            case 2: {
                                if (headerInFocus) {
                                    EclEditor.this.header.redo();
                                    return;
                                }
                                if (editorInFocus) {
                                    EclEditor.this.editorContent.redo();
                                    return;
                                }
                                return;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                    finally {
                        EclEditor.this.updateActions();
                    }
                }
                super.doOperation(operation);
            }

            public boolean canDoOperation(int operation) {
                if (!EclEditor.this.viewer.getControl().isFocusControl() && (EclEditor.this.header.isInFocus() || EclEditor.this.editorContent.isInFocus())) {
                    switch (operation) {
                        case 7: {
                            return true;
                        }
                        case 4: {
                            return EclEditor.this.header.isInFocus() && EclEditor.this.header.canCopy() || EclEditor.this.editorContent.isInFocus() && EclEditor.this.editorContent.canCopy();
                        }
                        case 5: {
                            return EclEditor.this.header.isInFocus() && EclEditor.this.header.canPaste() || EclEditor.this.editorContent.isInFocus() && EclEditor.this.editorContent.canPaste();
                        }
                        case 3: {
                            return EclEditor.this.header.isInFocus() && EclEditor.this.header.canCut() || EclEditor.this.editorContent.isInFocus() && EclEditor.this.editorContent.canCut();
                        }
                        case 1: {
                            return EclEditor.this.header.isInFocus() && EclEditor.this.header.canUndo() || EclEditor.this.editorContent.isInFocus() && EclEditor.this.editorContent.canUndo();
                        }
                        case 2: {
                            return EclEditor.this.header.isInFocus() && EclEditor.this.header.canRedo() || EclEditor.this.editorContent.isInFocus() && EclEditor.this.editorContent.canRedo();
                        }
                    }
                    return false;
                }
                switch (operation) {
                    case 1: {
                        IUndoContext ctx = EclEditor.this.getUndoContext();
                        if (ctx == null) break;
                        return EclEditor.this.getHistory().canUndo(ctx);
                    }
                    case 2: {
                        IUndoContext ctx = EclEditor.this.getUndoContext();
                        if (ctx == null) break;
                        return EclEditor.this.getHistory().canRedo(ctx);
                    }
                }
                return super.canDoOperation(operation);
            }
        };
        this.getSourceViewerDecorationSupport(this.viewer);
        Control rulerControl = ruler.getControl();
        rulerControl.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (1 == e.button) {
                    ToggleBreakpointAction action = new ToggleBreakpointAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart(), EclEditor.this.getViewer().getDocument(), (IVerticalRulerInfo)ruler);
                    action.update();
                    action.run();
                }
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        this.viewer.setElement(this.getModel());
        return this.viewer;
    }

    IOperationHistory getHistory() {
        if (PlatformUI.getWorkbench() == null) {
            return null;
        }
        return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
    }

    private IUndoContext getUndoContext() {
        IUndoManager undoManager;
        if (this.getViewer() instanceof ITextViewerExtension6 && (undoManager = this.getViewer().getUndoManager()) instanceof IUndoManagerExtension) {
            return ((IUndoManagerExtension)undoManager).getUndoContext();
        }
        return null;
    }

    private void registerUndoRedoAction(String actionId, ResourceAction action) {
        IAction oldAction = this.getAction(actionId);
        if (oldAction instanceof OperationHistoryActionHandler) {
            ((OperationHistoryActionHandler)oldAction).dispose();
        }
        if (action == null) {
            return;
        }
        this.setAction(actionId, (IAction)action);
        IActionBars actionBars = this.getEditorSite().getActionBars();
        if (actionBars != null) {
            actionBars.setGlobalActionHandler(actionId, (IAction)action);
        }
    }

    protected void createUndoRedoActions() {
        TextOperationAction action;
        ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.rcptt.ui.editors.ecl.EclEditorPluginResources");
        if (this.getAction(ITextEditorActionConstants.UNDO) == null) {
            action = new TextOperationAction(bundle, "Editor.Undo.", (ITextEditor)this, 1);
            action.setHelpContextId(IAbstractTextEditorHelpContextIds.UNDO_ACTION);
            action.setActionDefinitionId("org.eclipse.ui.edit.undo");
            this.setAction(ITextEditorActionConstants.UNDO, (IAction)action);
            this.registerUndoRedoAction(ITextEditorActionConstants.UNDO, (ResourceAction)action);
        }
        if (this.getAction(ITextEditorActionConstants.REDO) == null) {
            action = new TextOperationAction(bundle, "Editor.Redo.", (ITextEditor)this, 2);
            action.setHelpContextId(IAbstractTextEditorHelpContextIds.REDO_ACTION);
            action.setActionDefinitionId("org.eclipse.ui.edit.redo");
            this.setAction(ITextEditorActionConstants.REDO, (IAction)action);
            this.registerUndoRedoAction(ITextEditorActionConstants.REDO, (ResourceAction)action);
        }
    }

    private void configureViewer() {
        this.viewer.setEditable(true);
        this.bindScriptContent();
    }

    public StyledText getControl() {
        return this.viewer.getTextWidget();
    }

    public void setSelection(int line, int column, int length) {
        BlockTextSelection selection = new BlockTextSelection(this.viewer.getDocument(), line - 1, column - 1, line - 1, column + length - 1, 0);
        this.viewer.setSelection((ISelection)selection, true);
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.rcptt.ui.editors.ecl.EclEditorPluginResources");
        this.setAction("ContentAssistProposal", (IAction)new TextOperationAction(bundle, "ContentAssistProposal.", (ITextEditor)this, 13));
        this.setActionActivationCode("ContentAssistProposal", ' ', -1, 262144);
        this.setAction("ContentAssistTip", (IAction)new TextOperationAction(bundle, "ContentAssistTip.", (ITextEditor)this, 14));
        Object action = new TextOperationAction(bundle, "Uncomment.", (ITextEditor)this, 12);
        action.setActionDefinitionId("org.eclipse.rcptt.ui.edit.text.ecl.uncomment");
        this.setAction("Uncomment", (IAction)action);
        this.markAsStateDependentAction("Uncomment", true);
        action = new ToggleCommentAction(bundle, "ToggleComment.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.rcptt.ui.edit.text.ecl.toggle.comment");
        this.setAction("ToggleComment", (IAction)action);
        this.markAsStateDependentAction("ToggleComment", true);
        this.configureToggleCommentAction();
        action = new EclContentAssistAction(bundle, "Editor.ContentAssistProposal.", this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        this.addFormatAction(null);
    }

    private void configureToggleCommentAction() {
        IAction action = this.getAction("ToggleComment");
        if (action instanceof ToggleCommentAction) {
            ISourceViewer sourceViewer = this.getSourceViewer();
            SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
            ((ToggleCommentAction)action).configure(sourceViewer, configuration);
        }
    }

    protected void createNavigationActions() {
        Object action;
        super.createNavigationActions();
        StyledText textWidget = this.getSourceViewer().getTextWidget();
        int i = 0;
        while (i < ACTION_MAP.length) {
            AbstractTextEditor.IdMapEntry entry = ACTION_MAP[i];
            action = new EclTextNavigationAction(this, textWidget, entry.getAction());
            action.setActionDefinitionId(entry.getActionId());
            this.setAction(entry.getActionId(), (IAction)action);
            ++i;
        }
        action = new SmartLineStartAction(this, textWidget, false);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.lineStart");
        this.setAction("org.eclipse.ui.edit.text.goto.lineStart", (IAction)action);
        action = new SmartLineStartAction(this, textWidget, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.lineStart");
        this.setAction("org.eclipse.ui.edit.text.select.lineStart", (IAction)action);
        action = new SmartLineEndAction(this, textWidget, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.lineEnd");
        this.setAction("org.eclipse.ui.edit.text.select.lineEnd", (IAction)action);
        action = new NavigatePreviousSubWordAction(this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.goto.wordPrevious", (IAction)action);
        textWidget.setKeyBinding(17039363, 0);
        action = new NavigateNextSubWordAction(this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordNext");
        this.setAction("org.eclipse.ui.edit.text.goto.wordNext", (IAction)action);
        textWidget.setKeyBinding(0x1040004, 0);
        action = new SelectPreviousSubWordAction(this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.select.wordPrevious", (IAction)action);
        textWidget.setKeyBinding(17170435, 0);
        action = new SelectNextSubWordAction(this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordNext");
        this.setAction("org.eclipse.ui.edit.text.select.wordNext", (IAction)action);
        textWidget.setKeyBinding(17170436, 0);
        action = new EclScrollLinesAction(this, -1);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.scroll.lineUp");
        this.setAction("org.eclipse.ui.edit.text.scroll.lineUp", (IAction)action);
        action = new EclScrollLinesAction(this, 1);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.scroll.lineDown");
        this.setAction("org.eclipse.ui.edit.text.scroll.lineDown", (IAction)action);
        action = new EclOpenDeclarationAction(this);
        action.setActionDefinitionId(GO_TO_DECLARATION_ACTION);
        this.setAction(GO_TO_DECLARATION_ACTION, (IAction)action);
    }

    private boolean hasContainerChanges(IQ7ElementDelta delta) {
        IQ7ElementDelta[] deltas;
        IPath p2;
        IPath p1;
        IQ7Element element = delta.getElement();
        if ((element instanceof IQ7Project || element instanceof IQ7Folder) && delta.getKind() == 2 && (p1 = delta.getElement().getPath()).isPrefixOf(p2 = this.model.getPath())) {
            return true;
        }
        IQ7ElementDelta[] iQ7ElementDeltaArray = deltas = delta.getAffectedChildren();
        if (deltas.length != 0) {
            IQ7ElementDelta childDelta = iQ7ElementDeltaArray[0];
            return this.hasContainerChanges(childDelta);
        }
        return false;
    }

    private IQ7Element[] hasContainerMoveChanges(IQ7ElementDelta delta) {
        IQ7ElementDelta[] deltas;
        IPath p2;
        IPath p1;
        IQ7Element element = delta.getElement();
        if ((element instanceof IQ7Project || element instanceof IQ7Folder) && delta.getKind() == 2 && (p1 = delta.getElement().getPath()).isPrefixOf(p2 = this.model.getPath())) {
            if ((delta.getFlags() & 0x10) != 0 || (delta.getFlags() & 0x20) != 0) {
                return new IQ7Element[]{delta.getElement(), delta.getMovedToElement()};
            }
            return null;
        }
        IQ7ElementDelta[] iQ7ElementDeltaArray = deltas = delta.getAffectedChildren();
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7ElementDelta childDelta = iQ7ElementDeltaArray[n2];
            IQ7Element[] el = this.hasContainerMoveChanges(childDelta);
            if (el != null) {
                return el;
            }
            ++n2;
        }
        return null;
    }

    public void elementChanged(Q7ElementChangedEvent event) {
        IQ7NamedElement[] namedElements;
        if (this.model == null) {
            return;
        }
        IQ7ElementDelta delta = event.getDelta();
        IQ7Element[] moveTo = this.hasContainerMoveChanges(delta);
        if (moveTo != null) {
            IPath relativePath = this.model.getPath().removeFirstSegments(moveTo[0].getPath().segmentCount());
            IPath newPath = moveTo[1].getPath().append(relativePath);
            this.replaceResource(RcpttCore.create((IResource)ResourcesPlugin.getWorkspace().getRoot().findMember(newPath)));
            return;
        }
        IQ7NamedElement[] iQ7NamedElementArray = namedElements = delta.getNamedElements();
        int n = namedElements.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7NamedElement e = iQ7NamedElementArray[n2];
            IQ7ElementDelta childDelta = delta.getChildBy(e);
            if (this.model.equals(e)) {
                switch (childDelta.getKind()) {
                    case 2: {
                        if ((childDelta.getFlags() & 0x10) == 0 && (childDelta.getFlags() & 0x20) == 0) {
                            this.resourceRemoved(e);
                            break;
                        }
                    }
                    case 4: {
                        IQ7Element el;
                        if ((childDelta.getFlags() & 1) == 0 && (childDelta.getFlags() & 0x10) == 0 && (childDelta.getFlags() & 0x20) == 0) break;
                        if ((childDelta.getFlags() & 0x20) != 0 && (el = childDelta.getMovedToElement()) != null && el instanceof IQ7NamedElement) {
                            this.replaceResource(el);
                            return;
                        }
                        this.resourceChanged(e);
                        return;
                    }
                }
            }
            ++n2;
        }
        IQ7ElementDelta[] children = delta.getAffectedChildren();
        IQ7Project project = this.model.getQ7Project();
        IQ7ElementDelta[] iQ7ElementDeltaArray = children;
        int n3 = children.length;
        int n4 = 0;
        while (n4 < n3) {
            IQ7ElementDelta c = iQ7ElementDeltaArray[n4];
            if (c.getElement().equals(project) && (c.getFlags() & 0x400) != 0) {
                this.resourceClosed(this.model);
            }
            ++n4;
        }
        if (this.hasContainerChanges(delta)) {
            this.resourceRemoved(this.model);
            return;
        }
    }

    private void replaceResource(final IQ7Element el) {
        try {
            RcpttCore.removeElementChangedListener((IElementChangedListener)this);
            this.discardWorkingCopy();
            RcpttCore.addElementChangedListener((IElementChangedListener)this);
            WorkbenchUtils.uiRun(new Runnable(){

                @Override
                public void run() {
                    EclEditor.this.update((IQ7NamedElement)el, (IProgressMonitor)new NullProgressMonitor());
                }
            });
        }
        catch (ModelException e2) {
            Q7UIPlugin.log(e2);
        }
        this.resourceChanged((IQ7NamedElement)el);
    }

    private void resourceRemoved(IQ7NamedElement e) {
        WorkbenchUtils.uiRun(new Runnable(){

            @Override
            public void run() {
                EclEditor.this.close(false);
            }
        });
    }

    private void resourceClosed(IQ7NamedElement e) {
        WorkbenchUtils.uiRun(new Runnable(){

            @Override
            public void run() {
                EclEditor.this.close(true);
            }
        });
    }

    private void update(IQ7NamedElement newOrigin, IProgressMonitor monitor) {
        try {
            try {
                RcpttCore.removeElementChangedListener((IElementChangedListener)this);
                this.discardWorkingCopy();
                this.handle = newOrigin;
                this.updateElement();
                WorkbenchUtils.uiRun(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            EclEditor.super.doSetInput((IEditorInput)EclEditor.this.createEditorInput());
                        }
                        catch (CoreException e) {
                            Q7UIPlugin.log(e);
                        }
                        EclEditor.this.header.update(EclEditor.this.model, EclEditor.this.element);
                        EclEditor.this.editorContent.update(EclEditor.this.model, EclEditor.this.element);
                        EclEditor.this.setPartName(EclEditor.this.element.getName());
                        EclEditor.this.scheduleCheckReferences();
                        EclEditor.this.bindScriptContent();
                    }
                });
                this.firePropertyChange(257);
            }
            catch (Exception e) {
                WorkbenchUtils.uiRun(new Runnable(){

                    @Override
                    public void run() {
                        EclEditor.this.close(false);
                    }
                });
                Q7UIPlugin.log(e);
                RcpttCore.addElementChangedListener((IElementChangedListener)this);
            }
        }
        finally {
            RcpttCore.addElementChangedListener((IElementChangedListener)this);
        }
    }

    protected void bindScriptContent() {
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        document.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                String value = EclEditor.this.viewer.getDocument().get();
                EclEditor.this.setEclContext(EclEditor.this.element, value);
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        IChangeListener scenarioContentListener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                String doc;
                String script;
                try {
                    script = EclEditor.this.getEclContext(EclEditor.this.element);
                }
                catch (Exception e) {
                    script = EclEditor.SCENARIO_ERROR;
                    Q7UIPlugin.log(e);
                }
                if (EclEditor.this.viewer.getDocument() != null && !(doc = EclEditor.this.viewer.getDocument().get()).equals(script)) {
                    EclEditor.this.viewer.getDocument().set(script);
                }
            }
        };
        IObservableValue scriptContent = EMFObservables.observeValue((EObject)this.element, (EStructuralFeature)ScenarioPackage.Literals.SCENARIO__CONTENT);
        scriptContent.addChangeListener(scenarioContentListener);
        IObservableValue teslaContent = EMFObservables.observeValue((EObject)this.element, (EStructuralFeature)ScenarioPackage.Literals.SCENARIO__TESLA_CONTENT);
        teslaContent.addChangeListener(scenarioContentListener);
    }

    private void resourceChanged(final IQ7NamedElement e) {
        WorkbenchUtils.uiRun(new Runnable(){

            @Override
            public void run() {
                String title = Messages.NamedElementEditor_ResourceChangedDialogTitle;
                String msg = Messages.bind((String)Messages.NamedElementEditor_ResourceChangedDialogMsg, (Object)EclEditor.this.getInputFile(EclEditor.this.getEditorInput()).getName());
                if (EclEditor.this.isDirty()) {
                    if (MessageDialog.openQuestion((Shell)EclEditor.this.getSite().getShell(), (String)title, (String)msg)) {
                        EclEditor.this.update(e, EclEditor.this.getProgressMonitor());
                        EclEditor.this.setPartName(EclEditor.this.getElement().getName());
                        EclEditor.this.firePropertyChange(257);
                    } else {
                        EclEditor.this.firePropertyChange(257);
                    }
                } else {
                    EclEditor.this.update(e, EclEditor.this.getProgressMonitor());
                }
                EclEditor.this.scheduleCheckReferences();
            }
        });
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "group.edit", "ShiftRight");
        this.addAction(menu, "group.edit", "ShiftLeft");
        this.addGoToDeclarationAction(menu);
        this.addFormatAction(menu);
    }

    private void addFormatAction(IMenuManager menu) {
        this.removeActionActivationCode(FORMAT_ACTION);
        FormatAction action = new FormatAction(this.doGetSourceViewer());
        action.setActionDefinitionId(FORMAT_ACTION);
        this.setAction(FORMAT_ACTION, (IAction)action);
        if (menu != null) {
            this.addAction(menu, "group.edit", FORMAT_ACTION);
        }
    }

    private void addGoToDeclarationAction(IMenuManager menu) {
        this.removeActionActivationCode(GO_TO_DECLARATION_ACTION);
        EclOpenDeclarationAction action = new EclOpenDeclarationAction(this);
        action.setActionDefinitionId(GO_TO_DECLARATION_ACTION);
        this.setAction(GO_TO_DECLARATION_ACTION, (IAction)action);
        if (menu != null) {
            this.addGroup(menu, "group.edit", GO_TO_DECLARATION_GROUP);
            this.addAction(menu, GO_TO_DECLARATION_GROUP, GO_TO_DECLARATION_ACTION);
        }
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        super.rulerContextMenuAboutToShow(menu);
        if (this.viewer != null && this.viewer.getTextWidget() != null) {
            this.viewer.getTextWidget().setFocus();
        }
        ToggleBreakpointAction action1 = new ToggleBreakpointAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart(), this.getViewer().getDocument(), (IVerticalRulerInfo)this.getVerticalRuler());
        action1.update();
        menu.appendToGroup("debug", (IAction)action1);
        ToggleBreakpointEnablementAction action2 = new ToggleBreakpointEnablementAction((SourceViewer)this.viewer, (IVerticalRulerInfo)this.getVerticalRuler());
        action2.update();
        menu.appendToGroup("debug", (IAction)action2);
    }

    public void showSearchMatch(int searchFor, int offset, int length) {
        this.editorContent.showSearchMatch(searchFor, offset, length);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.rcptt.ui.eclEditor"});
    }

    public IPreferenceStore doGetPreferenceStore() {
        return this.getPreferenceStore();
    }

    public TextViewer doGetSourceViewer() {
        return (TextViewer)this.getSourceViewer();
    }

    public int doWidgetOffset2ModelOffset(TextViewer viewer, int caretOffset) {
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            return extension.widgetOffset2ModelOffset(caretOffset);
        }
        return caretOffset + viewer.getVisibleRegion().getOffset();
    }

    public int doModelOffset2WidgetOffset(TextViewer viewer, int modelOffset) {
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            return extension.modelOffset2WidgetOffset(modelOffset);
        }
        return modelOffset - viewer.getVisibleRegion().getOffset();
    }

    protected void setEclContext(NamedElement element, String value) {
        if (element instanceof Scenario) {
            Scenarios.setEclContent((Scenario)((Scenario)element), (String)value);
        }
    }

    protected String getEclContext(NamedElement element) {
        if (element instanceof Scenario) {
            return Scenarios.getScriptContent((Scenario)((Scenario)element));
        }
        return "";
    }

    @Override
    public void setTags(String tags) {
        if (this.element != null) {
            this.element.setTags(tags);
        }
    }

    public Object getReconcilerLock() {
        return this.reconcilerLock;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        super.configureSourceViewerDecorationSupport(support);
        char[] matchChars = new char[]{'[', ']', '{', '}'};
        DefaultCharacterPairMatcher matcher = new DefaultCharacterPairMatcher(matchChars, "__dftl_partitioning");
        support.setCharacterPairMatcher((ICharacterPairMatcher)matcher);
        support.setMatchingCharacterPainterPreferenceKeys(EDITOR_MATCHING_BRACKETS, EDITOR_MATCHING_BRACKETS_COLOR);
        IPreferenceStore store = this.getPreferenceStore();
        store.setDefault(EDITOR_MATCHING_BRACKETS, true);
        store.setDefault(EDITOR_MATCHING_BRACKETS_COLOR, "128,128,128");
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        EnhancedSourceViewer enhancedSourceview = (EnhancedSourceViewer)this.getSourceViewer();
        if (enhancedSourceview == null) {
            return;
        }
        ContentAssistant currentContentAssistant = (ContentAssistant)enhancedSourceview.getContentAssistant();
        String propertyToChange = event.getKey();
        if (propertyToChange.compareTo("ECL_CONTENT_ASSIST_ACTIVATIONSTATE") == 0) {
            currentContentAssistant.enableAutoActivation(ECLEditorPlugin.getECLScriptContentAssistActivationState());
        } else if (propertyToChange.compareTo("ECL_CONTENT_ASSIST_DELAY") == 0) {
            currentContentAssistant.setAutoActivationDelay(ECLEditorPlugin.getECLScriptContentAssistDelay());
        } else if (propertyToChange.compareTo("ECL_CONTENT_ASSIST_TRIGGERS") == 0) {
            EclContentAssistProcessor generalContentAssistProcessor = new EclContentAssistProcessor();
            currentContentAssistant.setContentAssistProcessor((IContentAssistProcessor)generalContentAssistProcessor, "__dftl_partition_content_type");
        }
    }

    private class ContentAdapter
    extends EContentAdapter {
        private final NamedElement element;

        public ContentAdapter(NamedElement element) {
            this.element = element;
            element.eAdapters().add((Object)this);
        }

        public void notifyChanged(Notification msg) {
            super.notifyChanged(msg);
            EclEditor.this.setPartName(this.element.getName());
            if (msg.getEventType() == 9 || msg.getEventType() == 8) {
                return;
            }
            EclEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    EclEditor.this.firePropertyChange(257);
                }
            });
            if (msg.getFeature() != null && (msg.getFeature().equals(ScenarioPackage.Literals.SCENARIO__CONTEXTS) || msg.getFeature().equals(ScenarioPackage.Literals.SCENARIO__VERIFICATIONS) || msg.getFeature().equals(ScenarioPackage.Literals.GROUP_CONTEXT__CONTEXT_REFERENCES))) {
                EclEditor.this.checkReferences();
            }
        }
    }
}

