/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import org.eclipse.jdt.internal.ui.util.PatternMatcher;
import org.eclipse.jdt.internal.ui.util.StringMatcher;

public class JavaElementPrefixPatternMatcher {
    static final String STAR = "*";
    private PatternMatcher fElementNamePattern;
    private StringMatcher fRestPattern;

    public JavaElementPrefixPatternMatcher(String pattern) {
        int elementNameEnd = this.findNameEnd(pattern);
        String elementName = pattern.substring(0, elementNameEnd);
        String rest = pattern.substring(elementNameEnd);
        if (rest.startsWith(STAR)) {
            elementNameEnd = 0;
            rest = pattern;
        }
        this.fElementNamePattern = elementNameEnd == 0 ? null : new PatternMatcher(elementName);
        boolean ignoreCase = rest.toLowerCase().equals(rest);
        this.fRestPattern = new StringMatcher(String.valueOf(rest) + STAR, ignoreCase, false);
    }

    private int findNameEnd(String pattern) {
        int len = pattern.length();
        if (len != 0 && Character.isJavaIdentifierStart(pattern.charAt(0))) {
            int i = 1;
            while (i < len) {
                if (!Character.isJavaIdentifierPart(pattern.charAt(i))) {
                    return i;
                }
                ++i;
            }
            return len;
        }
        return 0;
    }

    public boolean matches(String label) {
        int elementNameEnd = this.findNameEnd(label);
        if (this.fElementNamePattern == null) {
            return this.fRestPattern.match(label);
        }
        if (!this.fElementNamePattern.matches(label.substring(0, elementNameEnd))) {
            return false;
        }
        return this.fRestPattern.match(label.substring(elementNameEnd));
    }
}

