/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class MarkerResolutionSelectionDialog
extends SelectionDialog {
    private static final int LIST_WIDTH = 60;
    private static final int LIST_HEIGHT = 10;
    private IMarkerResolution[] resolutions;
    private ListViewer listViewer;

    public MarkerResolutionSelectionDialog(Shell shell, IMarkerResolution[] markerResolutions) {
        super(shell);
        if (markerResolutions == null || markerResolutions.length == 0) {
            throw new IllegalArgumentException();
        }
        this.resolutions = markerResolutions;
        this.setTitle(IDEWorkbenchMessages.MarkerResolutionSelectionDialog_title);
        this.setMessage(IDEWorkbenchMessages.MarkerResolutionSelectionDialog_messageLabel);
        this.setInitialSelections(new Object[]{markerResolutions[0]});
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.ui.ide.marker_resolution_selection_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        this.listViewer = new ListViewer(composite, 2820);
        GridData data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        data.widthHint = this.convertWidthInCharsToPixels(60);
        this.listViewer.getList().setLayoutData((Object)data);
        this.listViewer.getList().setFont(parent.getFont());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element == null ? "" : ((IMarkerResolution)element).getLabel();
            }
        });
        this.listViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.listViewer.setInput((Object)this.resolutions);
        this.listViewer.setSelection((ISelection)new StructuredSelection(this.getInitialElementSelections()), true);
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MarkerResolutionSelectionDialog.this.getOkButton().setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MarkerResolutionSelectionDialog.this.okPressed();
            }
        });
        return composite;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.listViewer.getSelection();
        this.setResult(selection.toList());
        super.okPressed();
    }
}

