/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.shared.target.IEditBundleContainerPage;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class EditDirectoryContainerPage
extends WizardPage
implements IEditBundleContainerPage {
    protected static final int TYPING_DELAY = 200;
    private static ITargetPlatformService fTargetService;
    protected Combo fInstallLocation;
    protected ITargetLocation fContainer;
    private Job fTextChangedJob;
    private static final String SETTINGS_LOCATION_1 = "location1";
    private static final String SETTINGS_LOCATION_2 = "location2";
    private static final String SETTINGS_LOCATION_3 = "location3";

    protected EditDirectoryContainerPage(ITargetLocation container) {
        this();
        this.fContainer = container;
    }

    protected EditDirectoryContainerPage() {
        super("EditDirectoryContainer");
    }

    public EditDirectoryContainerPage(ITargetLocation container, String name) {
        super(name);
        this.fContainer = container;
    }

    public void createControl(Composite parent) {
        this.setMessage(this.getDefaultMessage());
        this.setTitle(this.getDefaultTitle());
        this.setPageComplete(false);
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 1808, 0, 0);
        this.createLocationArea(comp);
        this.setControl((Control)comp);
        this.initializeInputFields(this.fContainer);
        if ("EditDirectoryContainer".equalsIgnoreCase(this.getName())) {
            if (this.fContainer == null) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, "org.eclipse.pde.doc.user.location_add_directory_wizard");
            } else {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, "org.eclipse.pde.doc.user.location_edit_directory_wizard");
            }
        }
    }

    protected String getDefaultTitle() {
        if (this.fContainer == null) {
            return Messages.AddDirectoryContainerPage_0;
        }
        return Messages.EditDirectoryContainerPage_0;
    }

    protected String getDefaultMessage() {
        return Messages.AddDirectoryContainerPage_1;
    }

    protected void createLocationArea(Composite parent) {
        Composite locationComp = SWTFactory.createComposite(parent, 2, 1, 768, 0, 0);
        SWTFactory.createLabel(locationComp, Messages.AddDirectoryContainerPage_2, 1);
        this.fInstallLocation = SWTFactory.createCombo(locationComp, 2048, 1, this.getLocationComboItems());
        this.fInstallLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean isItem = false;
                String[] items = EditDirectoryContainerPage.this.fInstallLocation.getItems();
                int i = 0;
                while (i < items.length) {
                    if (EditDirectoryContainerPage.this.fInstallLocation.getText().equals(items[i])) {
                        isItem = true;
                        break;
                    }
                    ++i;
                }
                EditDirectoryContainerPage.this.containerChanged(isItem ? 0 : 200);
            }
        });
        if (this.fContainer instanceof AbstractBundleContainer) {
            try {
                String location = ((AbstractBundleContainer)this.fContainer).getLocation(false);
                this.fInstallLocation.setText(location);
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getMessage());
            }
        }
        Composite buttonComp = SWTFactory.createComposite(locationComp, 2, 2, 2, 0, 0);
        GridData gd = (GridData)buttonComp.getLayoutData();
        gd.horizontalAlignment = 131072;
        Button browseButton = SWTFactory.createPushButton(buttonComp, Messages.AddDirectoryContainerPage_3, null);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(EditDirectoryContainerPage.this.getShell());
                dialog.setFilterPath(EditDirectoryContainerPage.this.fInstallLocation.getText());
                dialog.setText(Messages.AddDirectoryContainerPage_4);
                dialog.setMessage(Messages.AddDirectoryContainerPage_5);
                String result = dialog.open();
                if (result != null) {
                    EditDirectoryContainerPage.this.fInstallLocation.setText(result);
                }
            }
        });
        Button variablesButton = SWTFactory.createPushButton(buttonComp, Messages.EditDirectoryContainerPage_1, null);
        variablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(EditDirectoryContainerPage.this.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    EditDirectoryContainerPage.this.fInstallLocation.setText(String.valueOf(EditDirectoryContainerPage.this.fInstallLocation.getText()) + variable);
                }
            }
        });
    }

    protected void initializeInputFields(ITargetLocation container) {
        if (container instanceof AbstractBundleContainer) {
            try {
                String currentLocation = ((AbstractBundleContainer)container).getLocation(false);
                boolean found = false;
                String[] items = this.fInstallLocation.getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i].equals(currentLocation)) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    this.fInstallLocation.add(currentLocation);
                }
                this.fInstallLocation.setText(currentLocation);
                this.containerChanged(0L);
            }
            catch (CoreException e) {
                PDEPlugin.log(e);
            }
        } else {
            this.fInstallLocation.setText("");
        }
    }

    private String[] getLocationComboItems() {
        ArrayList<String> previousLocations = new ArrayList<String>(4);
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String location = settings.get(SETTINGS_LOCATION_1);
            if (location != null) {
                previousLocations.add(location);
            }
            if ((location = settings.get(SETTINGS_LOCATION_2)) != null) {
                previousLocations.add(location);
            }
            if ((location = settings.get(SETTINGS_LOCATION_3)) != null) {
                previousLocations.add(location);
            }
        }
        previousLocations.add(this.getDefaultLocation());
        return previousLocations.toArray(new String[previousLocations.size()]);
    }

    protected String getDefaultLocation() {
        return "${eclipse_home}";
    }

    @Override
    public void storeSettings() {
        String newLocation = this.fInstallLocation.getText().trim();
        int length = newLocation.length();
        if (length > 0 && newLocation.charAt(length - 1) == File.separatorChar) {
            newLocation = newLocation.substring(0, length - 1);
        }
        String[] items = this.fInstallLocation.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(newLocation)) {
                return;
            }
            ++i;
        }
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String location = settings.get(SETTINGS_LOCATION_2);
            if (location != null) {
                settings.put(SETTINGS_LOCATION_3, location);
            }
            if ((location = settings.get(SETTINGS_LOCATION_1)) != null) {
                settings.put(SETTINGS_LOCATION_2, location);
            }
            settings.put(SETTINGS_LOCATION_1, newLocation);
        }
    }

    @Override
    public ITargetLocation getBundleContainer() {
        return this.fContainer;
    }

    protected void containerChanged(long delay) {
        if (this.fTextChangedJob == null) {
            this.fTextChangedJob = new CreateContainerJob(this.getShell().getDisplay(), Messages.EditDirectoryContainerPage_3);
        } else {
            this.fTextChangedJob.cancel();
        }
        this.fTextChangedJob.schedule(delay);
    }

    protected boolean validateInput() {
        if (this.fInstallLocation.isDisposed()) {
            return false;
        }
        if (this.fInstallLocation.getText().trim().length() == 0) {
            this.setMessage(this.getDefaultMessage());
            return false;
        }
        String locationString = null;
        try {
            locationString = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.fInstallLocation.getText().trim());
        }
        catch (CoreException e) {
            this.setMessage(e.getMessage(), 2);
            return true;
        }
        File location = new File(locationString);
        if (!location.isDirectory()) {
            this.setMessage(Messages.AddDirectoryContainerPage_6, 2);
        } else {
            this.setMessage(this.getDefaultMessage());
        }
        return true;
    }

    protected ITargetLocation createContainer(ITargetLocation previous) throws CoreException {
        return EditDirectoryContainerPage.getTargetPlatformService().newDirectoryLocation(this.fInstallLocation.getText());
    }

    protected static ITargetPlatformService getTargetPlatformService() throws CoreException {
        if (fTargetService == null && (fTargetService = (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class.getName())) == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.AddDirectoryContainerPage_9));
        }
        return fTargetService;
    }

    private class CreateContainerJob
    extends UIJob {
        public CreateContainerJob(Display jobDisplay, String name) {
            super(jobDisplay, name);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            try {
                if (EditDirectoryContainerPage.this.validateInput()) {
                    EditDirectoryContainerPage.this.fContainer = EditDirectoryContainerPage.this.createContainer(EditDirectoryContainerPage.this.fContainer);
                    EditDirectoryContainerPage.this.setPageComplete(true);
                } else {
                    EditDirectoryContainerPage.this.fContainer = null;
                    EditDirectoryContainerPage.this.setPageComplete(false);
                }
                return Status.OK_STATUS;
            }
            catch (CoreException e) {
                EditDirectoryContainerPage.this.fContainer = null;
                EditDirectoryContainerPage.this.setErrorMessage(e.getMessage());
                EditDirectoryContainerPage.this.setPageComplete(false);
                return e.getStatus();
            }
        }
    }
}

