/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.internal.patch.WorkspacePatcher;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.ui.PlatformUI;

public class FuzzFactorDialog
extends Dialog {
    private Text valueText;
    private Text errorMessageText;
    private WorkspacePatcher patcher;
    private int fuzzFactor;

    public FuzzFactorDialog(Shell parentShell, WorkspacePatcher patcher) {
        super(parentShell);
        this.patcher = patcher;
    }

    public int getFuzzFactor() {
        return this.fuzzFactor;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        FuzzFactorDialog.applyDialogFont((Control)composite);
        Label label = new Label(composite, 64);
        label.setText(TeamUIMessages.FuzzFactorDialog_message);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        this.valueText = new Text(composite, 2052);
        data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        this.valueText.setLayoutData((Object)data);
        this.valueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FuzzFactorDialog.this.validateInput();
            }
        });
        this.fuzzFactor = this.patcher.getFuzz();
        if (this.fuzzFactor >= 0) {
            this.valueText.setText(new Integer(this.fuzzFactor).toString());
        }
        Button guessButton = new Button(composite, 0);
        guessButton.setText(TeamUIMessages.FuzzFactorDialog_guess);
        data = new GridData();
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = guessButton.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        guessButton.setLayoutData((Object)data);
        guessButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FuzzFactorDialog.this.patcher.setFuzz(-1);
                int fuzz = FuzzFactorDialog.this.guessFuzzFactor();
                if (fuzz >= 0) {
                    String value = new Integer(fuzz).toString();
                    FuzzFactorDialog.this.valueText.setText(value);
                }
            }
        });
        this.errorMessageText = new Text(composite, 72);
        this.errorMessageText.setLayoutData((Object)new GridData(768));
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        this.validateInput();
        FuzzFactorDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void validateInput() {
        String message = null;
        String value = this.valueText.getText();
        try {
            this.fuzzFactor = Integer.parseInt(value);
            if (this.fuzzFactor < 0) {
                message = TeamUIMessages.FuzzFactorDialog_numberOutOfRange;
            }
        }
        catch (NumberFormatException numberFormatException) {
            message = TeamUIMessages.FuzzFactorDialog_notANumber;
        }
        this.setErrorMessage(message);
    }

    private void setErrorMessage(String errorMessage) {
        if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
            this.errorMessageText.setText(errorMessage == null ? " \n " : errorMessage);
            boolean hasError = errorMessage != null && StringConverter.removeWhiteSpaces((String)errorMessage).length() > 0;
            this.errorMessageText.setEnabled(hasError);
            this.errorMessageText.setVisible(hasError);
            this.errorMessageText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(errorMessage == null);
            }
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(TeamUIMessages.FuzzFactorDialog_title);
    }

    private int guessFuzzFactor() {
        final int[] result = new int[]{-1};
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    result[0] = FuzzFactorDialog.this.patcher.guessFuzzFactor(monitor);
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return result[0];
    }
}

