/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.push.PushBranchWizard;
import org.eclipse.egit.ui.internal.push.PushOperationUI;
import org.eclipse.egit.ui.internal.push.SimpleConfigurePushDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.swt.widgets.Shell;

public class PushUpstreamOrBranchActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(true, event);
        if (repository == null) {
            return null;
        }
        Shell shell = this.getShell(event);
        RemoteConfig config = SimpleConfigurePushDialog.getConfiguredRemote(repository);
        PushUpstreamOrBranchActionHandler.pushOrConfigure(repository, config, shell);
        return null;
    }

    public static void pushOrConfigure(Repository repository, RemoteConfig config, Shell shell) {
        if (config != null) {
            PushOperationUI op = new PushOperationUI(repository, config.getName(), false);
            op.start();
        } else {
            Ref head = PushUpstreamOrBranchActionHandler.getHeadIfSymbolic(repository);
            if (head != null) {
                PushBranchWizard pushBranchWizard = new PushBranchWizard(repository, head);
                WizardDialog dlg = new WizardDialog(shell, (IWizard)pushBranchWizard);
                dlg.open();
            }
        }
    }

    @Override
    public boolean isEnabled() {
        Repository repository = this.getRepository();
        if (repository == null) {
            return false;
        }
        Ref head = PushUpstreamOrBranchActionHandler.getHeadIfSymbolic(repository);
        return head != null;
    }

    private static Ref getHeadIfSymbolic(Repository repository) {
        try {
            Ref head = repository.getRef("HEAD");
            if (head != null && head.isSymbolic()) {
                return head;
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

