/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.util.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.util.StringUtils;
import org.eclipse.swt.SWT;

public class KeysAndButtons {
    public static final String BUTTON_LEFT = "Left";
    public static final String BUTTON_RIGHT = "Right";
    public static final String BUTTON_MIDDLE = "Middle";
    public static final String BUTTON_4 = "Button4";
    public static final String BUTTON_5 = "Button5";
    public static final Map<Integer, String> MODIFIERS = new LinkedHashMap<Integer, String>();
    public static final int[] ORDERED_MODIFIERS;
    public static final int[] REVERSE_MODIFIERS;
    public static final Map<Integer, String> BUTTON_NAMES_BY_MASK;
    private static final Map<String, Integer> STATES_BY_NAME;
    private static final Map<String, Integer> BUTTON_NUMBERS;
    private static final String[] BUTTON_NAMES;
    private static final int[] BUTTON_MASKS_BY_NUMBER;

    static {
        MODIFIERS.put(SWT.MOD1, "M1");
        MODIFIERS.put(SWT.MOD2, "M2");
        MODIFIERS.put(SWT.MOD3, "M3");
        MODIFIERS.put(SWT.MOD4, "M4");
        ORDERED_MODIFIERS = new int[]{SWT.MOD1, SWT.MOD2, SWT.MOD3, SWT.MOD4};
        REVERSE_MODIFIERS = new int[]{SWT.MOD4, SWT.MOD3, SWT.MOD2, SWT.MOD1};
        BUTTON_NAMES_BY_MASK = new LinkedHashMap<Integer, String>();
        BUTTON_NAMES_BY_MASK.put(524288, BUTTON_LEFT);
        BUTTON_NAMES_BY_MASK.put(0x100000, BUTTON_MIDDLE);
        BUTTON_NAMES_BY_MASK.put(0x200000, BUTTON_RIGHT);
        BUTTON_NAMES_BY_MASK.put(0x800000, BUTTON_4);
        BUTTON_NAMES_BY_MASK.put(0x2000000, BUTTON_5);
        STATES_BY_NAME = new HashMap<String, Integer>();
        for (Map.Entry<Integer, String> entry : MODIFIERS.entrySet()) {
            STATES_BY_NAME.put(entry.getValue(), entry.getKey());
        }
        for (Map.Entry<Integer, String> entry : BUTTON_NAMES_BY_MASK.entrySet()) {
            STATES_BY_NAME.put(entry.getValue(), entry.getKey());
        }
        BUTTON_NUMBERS = new HashMap<String, Integer>();
        BUTTON_NUMBERS.put(BUTTON_LEFT, 1);
        BUTTON_NUMBERS.put(BUTTON_MIDDLE, 2);
        BUTTON_NUMBERS.put(BUTTON_RIGHT, 3);
        BUTTON_NUMBERS.put(BUTTON_4, 4);
        BUTTON_NUMBERS.put(BUTTON_5, 5);
        String[] stringArray = new String[6];
        stringArray[1] = BUTTON_LEFT;
        stringArray[2] = BUTTON_MIDDLE;
        stringArray[3] = BUTTON_RIGHT;
        stringArray[4] = BUTTON_4;
        stringArray[5] = BUTTON_5;
        BUTTON_NAMES = stringArray;
        int[] nArray = new int[6];
        nArray[1] = 524288;
        nArray[2] = 0x100000;
        nArray[3] = 0x200000;
        nArray[4] = 0x800000;
        nArray[5] = 0x2000000;
        BUTTON_MASKS_BY_NUMBER = nArray;
    }

    public static int getButtonMask(int button) throws CoreException {
        if (button <= 0 || button >= BUTTON_MASKS_BY_NUMBER.length) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.util.swt", String.format("Cannot find button mast for button #%d", button)));
        }
        return BUTTON_MASKS_BY_NUMBER[button];
    }

    public static int getButtonMaskSafe(int button) {
        if (button <= 0 || button >= BUTTON_MASKS_BY_NUMBER.length) {
            return 0;
        }
        return BUTTON_MASKS_BY_NUMBER[button];
    }

    public static String getButtonName(int button) throws CoreException {
        if (button <= 0 || button >= BUTTON_NAMES.length) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.util.swt", String.format("Cannot find button name for button #%d", button)));
        }
        return BUTTON_NAMES[button];
    }

    public static String getButtonNameSafe(int button, String def) {
        if (button <= 0 || button >= BUTTON_NAMES.length) {
            return def;
        }
        return BUTTON_NAMES[button];
    }

    public static String getButtonNameSafe(int button) {
        return KeysAndButtons.getButtonNameSafe(button, BUTTON_LEFT);
    }

    public static int getButtonNumber(String name) throws CoreException {
        if (name != null && name.length() > 0) {
            name = String.format("%c%s", Character.valueOf(name.charAt(0)), name.substring(1).toLowerCase());
        }
        if (!BUTTON_NUMBERS.containsKey(name)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.util.swt", String.format("Unknown button name '%s'", name)));
        }
        return BUTTON_NUMBERS.get(name);
    }

    public static String stateMaskToStr(int stateMask) {
        ArrayList<String> result = new ArrayList<String>();
        KeysAndButtons.processMap(MODIFIERS, stateMask, result);
        KeysAndButtons.processMap(BUTTON_NAMES_BY_MASK, stateMask, result);
        return StringUtils.join((char)'+', result);
    }

    public static int stateMaskFromStr(String str) throws CoreException {
        if (str == null || str.length() == 0) {
            return 0;
        }
        String errorMessage = KeysAndButtons.validateStateStr(str);
        if (errorMessage != null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ui", errorMessage));
        }
        int result = 0;
        for (String entry : StringUtils.split((char)'+', (String)str)) {
            result |= STATES_BY_NAME.get(entry).intValue();
        }
        return result;
    }

    public static String validateStateStr(String state) {
        if (state == null || state.length() == 0) {
            return null;
        }
        for (String entry : StringUtils.split((char)'+', (String)state)) {
            if (STATES_BY_NAME.containsKey(entry)) continue;
            return String.format("Cannot parse state '%s': unknown entry '%s'", state, entry);
        }
        return null;
    }

    private static void processMap(Map<Integer, String> map, int stateMask, List<String> acc) {
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            if ((stateMask & entry.getKey()) == 0) continue;
            acc.add(entry.getValue());
        }
    }
}

