/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.ICommentInputDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EInputValidator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class CommentInputDialog
extends FormDialog
implements ICommentInputDialog {
    private static final String ADD_COMMENT_DIALOG_TITLE = "Enter Comment Details";
    private static final String ADD_COMMENT_DIALOG_VALUE = "Comments Description:";
    private static final String BASIC_PARAMS_HEADER_MSG = "Enter the mandatory basic parameters for this comment";
    private String fCommentValue = "";
    private Text fCommentInputTextField;
    private final IInputValidator fValidator;

    public CommentInputDialog(Shell aParentShell) {
        super(aParentShell);
        this.setBlockOnOpen(false);
        this.fValidator = new R4EInputValidator();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String validateResult = this.validateEmptyInput(this.fCommentInputTextField);
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "No input given for Comment", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, validateResult, null), 4);
                dialog.open();
                return;
            }
            this.fCommentValue = this.fCommentInputTextField.getText().trim();
        } else {
            this.fCommentValue = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ADD_COMMENT_DIALOG_TITLE);
        shell.setMinimumSize(400, 300);
    }

    protected void createFormContent(IManagedForm mform) {
        FormToolkit toolkit = mform.getToolkit();
        ScrolledForm sform = mform.getForm();
        sform.setExpandVertical(true);
        Composite composite = sform.getBody();
        GridLayout layout = new GridLayout(4, false);
        composite.setLayout((Layout)layout);
        GridData textGridData = null;
        Section basicSection = toolkit.createSection(composite, 450);
        GridData basicSectionGridData = new GridData(4, 4, true, true);
        basicSectionGridData.horizontalSpan = 4;
        basicSection.setLayoutData((Object)basicSectionGridData);
        basicSection.setText("Basic Parameters");
        basicSection.setDescription(BASIC_PARAMS_HEADER_MSG);
        basicSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                CommentInputDialog.this.getShell().setSize(CommentInputDialog.this.getShell().computeSize(-1, -1));
            }
        });
        Composite basicSectionClient = toolkit.createComposite((Composite)basicSection);
        basicSectionClient.setLayout((Layout)layout);
        basicSection.setClient((Control)basicSectionClient);
        Label label = toolkit.createLabel(basicSectionClient, ADD_COMMENT_DIALOG_VALUE);
        label.setToolTipText("The Comment Description");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fCommentInputTextField = toolkit.createText(basicSectionClient, "", 2626);
        textGridData = new GridData(4, 4, true, true);
        textGridData.horizontalSpan = 3;
        textGridData.heightHint = this.fCommentInputTextField.getLineHeight() * 7;
        this.fCommentInputTextField.setToolTipText("The Comment Description");
        this.fCommentInputTextField.setLayoutData((Object)textGridData);
        this.fCommentInputTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CommentInputDialog.this.fCommentInputTextField.getText().length() > 0) {
                    CommentInputDialog.this.getButton(0).setEnabled(true);
                } else {
                    CommentInputDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        this.fCommentInputTextField.setFocus();
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return bar;
    }

    protected boolean isResizable() {
        return true;
    }

    public String getCommentValue() {
        return this.fCommentValue;
    }

    private String validateEmptyInput(Text aText) {
        if (this.fValidator != null) {
            return this.fValidator.isValid(aText.getText());
        }
        return null;
    }

    protected void setShellStyle(int newShellStyle) {
        int newstyle = newShellStyle & 0xFFFEFFFF;
        super.setShellStyle(newstyle |= 0);
    }

    public int open() {
        super.open();
        this.pumpMessages();
        return super.getReturnCode();
    }

    protected void pumpMessages() {
        Shell sh = this.getShell();
        Display disp = sh.getDisplay();
        while (!sh.isDisposed()) {
            if (disp.readAndDispatch()) continue;
            disp.sleep();
        }
        disp.update();
    }
}

