/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Diff {
    public static final String CHANGE_TYPE_ADDITION = "addition";
    public static final String CHANGE_TYPE_DELETION = "deletion";
    public static final String CHANGE_TYPE_CHANGE = "change";
    private static final String DIFF_RANGE_CATEGORY = "org.eclipse.mylyn.reviews.r4e.ui.DIFF_RANGE_CATEGORY";
    CompareConfiguration fConfig;
    boolean fIsThreeWay;
    IDocument fAncestorDoc;
    Position fAncestorPos;
    IDocument fLeftDoc;
    Position fLeftPos;
    IDocument fRightDoc;
    Position fRightPos;
    Diff fParent;
    boolean fResolved;
    int fDirection;
    boolean fIsToken = false;
    List<Diff> fDiffs;
    boolean fIsWhitespace = false;

    Diff(Diff parent, int dir, IDocument ancestorDoc, Position aRange, int ancestorStart, int ancestorEnd, IDocument leftDoc, Position lRange, int leftStart, int leftEnd, IDocument rightDoc, Position rRange, int rightStart, int rightEnd, boolean aThreeWay, CompareConfiguration aConfig) {
        this.fParent = parent != null ? parent : this;
        this.fDirection = dir;
        this.fAncestorDoc = ancestorDoc;
        this.fLeftDoc = leftDoc;
        this.fRightDoc = rightDoc;
        this.fIsThreeWay = aThreeWay;
        this.fConfig = aConfig;
        this.fLeftPos = this.createPosition(leftDoc, lRange, leftStart, leftEnd);
        this.fRightPos = this.createPosition(rightDoc, rRange, rightStart, rightEnd);
        if (ancestorDoc != null) {
            this.fAncestorPos = this.createPosition(ancestorDoc, aRange, ancestorStart, ancestorEnd);
        }
    }

    public Position getPosition(char type) {
        switch (type) {
            case 'A': {
                return this.fAncestorPos;
            }
            case 'L': {
                return this.fLeftPos;
            }
            case 'R': {
                return this.fRightPos;
            }
        }
        return null;
    }

    public IDocument getDocument(char type) {
        switch (type) {
            case 'A': {
                return this.fAncestorDoc;
            }
            case 'L': {
                return this.fLeftDoc;
            }
            case 'R': {
                return this.fRightDoc;
            }
        }
        return null;
    }

    boolean isInRange(char type, int pos) {
        Position p = this.getPosition(type);
        return pos >= p.offset && pos < p.offset + p.length;
    }

    public String changeType() {
        boolean rightEmpty;
        boolean leftEmpty = this.fLeftPos.length == 0;
        boolean bl = rightEmpty = this.fRightPos.length == 0;
        if (this.fDirection == 3) {
            if (!leftEmpty && rightEmpty) {
                return CHANGE_TYPE_ADDITION;
            }
            if (leftEmpty && !rightEmpty) {
                return CHANGE_TYPE_DELETION;
            }
        } else {
            if (leftEmpty && !rightEmpty) {
                return CHANGE_TYPE_ADDITION;
            }
            if (!leftEmpty && rightEmpty) {
                return CHANGE_TYPE_DELETION;
            }
        }
        return CHANGE_TYPE_CHANGE;
    }

    public Image getImage() {
        int code = 3;
        switch (this.fDirection) {
            case 2: {
                code += 4;
                break;
            }
            case 3: {
                code += 8;
                break;
            }
            case 1: 
            case 4: {
                code += 12;
            }
        }
        if (code != 0) {
            return this.fConfig.getImage(code);
        }
        return null;
    }

    Position createPosition(IDocument doc, Position range, int start, int end) {
        try {
            int dl;
            int l = end - start;
            if (range != null) {
                dl = range.length;
                if (l > dl) {
                    l = dl;
                }
            } else {
                dl = doc.getLength();
                if (start + l > dl) {
                    l = dl - start;
                }
            }
            Position p = null;
            try {
                p = new Position(start, l);
            }
            catch (RuntimeException runtimeException) {
                p = new Position(0, 0);
            }
            try {
                doc.addPosition(DIFF_RANGE_CATEGORY, p);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            return p;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    void add(Diff d) {
        if (this.fDiffs == null) {
            this.fDiffs = new ArrayList<Diff>();
        }
        this.fDiffs.add(d);
    }

    public boolean isDeleted() {
        if (this.fAncestorPos != null && this.fAncestorPos.isDeleted()) {
            return true;
        }
        return this.fLeftPos.isDeleted() || this.fRightPos.isDeleted();
    }

    void setResolved(boolean r) {
        this.fResolved = r;
        if (r) {
            this.fDiffs = null;
        }
    }

    public boolean isResolved() {
        if (!this.fResolved && this.fDiffs != null) {
            for (Diff d : this.fDiffs) {
                if (d.isResolved()) continue;
                return false;
            }
            return true;
        }
        return this.fResolved;
    }

    Position getPosition(int contributor) {
        if (contributor == 76) {
            return this.fLeftPos;
        }
        if (contributor == 82) {
            return this.fRightPos;
        }
        if (contributor == 65) {
            return this.fAncestorPos;
        }
        return null;
    }

    public boolean overlaps(int contributor, int start, int end, int docLength) {
        Position h = this.getPosition(contributor);
        if (h != null) {
            int ds = h.getOffset();
            int de = ds + h.getLength();
            if (start < de && end >= ds) {
                return true;
            }
            if (start == docLength && start <= de && end >= ds) {
                return true;
            }
        }
        return false;
    }

    public int getMaxDiffHeight() {
        Point region = new Point(0, 0);
        int h = this.getLineRange((IDocument)this.fLeftDoc, (Position)this.fLeftPos, (Point)region).y;
        if (this.fIsThreeWay) {
            h = Math.max(h, this.getLineRange((IDocument)this.fAncestorDoc, (Position)this.fAncestorPos, (Point)region).y);
        }
        return Math.max(h, this.getLineRange((IDocument)this.fRightDoc, (Position)this.fRightPos, (Point)region).y);
    }

    public int getAncestorHeight() {
        Point region = new Point(0, 0);
        return this.getLineRange((IDocument)this.fAncestorDoc, (Position)this.fAncestorPos, (Point)region).y;
    }

    public int getLeftHeight() {
        Point region = new Point(0, 0);
        return this.getLineRange((IDocument)this.fLeftDoc, (Position)this.fLeftPos, (Point)region).y;
    }

    public int getRightHeight() {
        Point region = new Point(0, 0);
        return this.getLineRange((IDocument)this.fRightDoc, (Position)this.fRightPos, (Point)region).y;
    }

    public Diff[] getChangeDiffs(int contributor, IRegion region) {
        if (this.fDiffs != null && this.intersectsRegion(contributor, region)) {
            ArrayList<Diff> result = new ArrayList<Diff>();
            for (Diff diff2 : this.fDiffs) {
                Diff diff = diff2;
                if (!diff.intersectsRegion(contributor, region)) continue;
                result.add(diff);
            }
            return result.toArray(new Diff[result.size()]);
        }
        return new Diff[0];
    }

    private boolean intersectsRegion(int contributor, IRegion region) {
        Position p = this.getPosition(contributor);
        if (p != null) {
            return p.overlapsWith(region.getOffset(), region.getLength());
        }
        return false;
    }

    public boolean hasChildren() {
        return this.fDiffs != null && !this.fDiffs.isEmpty();
    }

    public int getKind() {
        return this.fDirection;
    }

    public boolean isToken() {
        return this.fIsToken;
    }

    public Diff getParent() {
        return this.fParent;
    }

    public Iterator<Diff> childIterator() {
        if (this.fDiffs == null) {
            return new ArrayList().iterator();
        }
        return this.fDiffs.iterator();
    }

    protected Point getLineRange(IDocument doc, Position p, Point region) {
        if (p == null || doc == null) {
            region.x = 0;
            region.y = 0;
            return region;
        }
        int start = p.getOffset();
        int length = p.getLength();
        int startLine = 0;
        try {
            startLine = doc.getLineOfOffset(start);
        }
        catch (BadLocationException badLocationException) {}
        int lineCount = 0;
        if (length != 0) {
            int endLine = 0;
            try {
                endLine = doc.getLineOfOffset(start + length - 1);
            }
            catch (BadLocationException badLocationException) {}
            lineCount = endLine - startLine + 1;
        }
        region.x = startLine;
        region.y = lineCount;
        return region;
    }
}

