/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards.floating;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewModelLoadingProperties;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.passage.lic.emf.validation.ErrorMessages;
import org.eclipse.passage.lic.licenses.model.api.FloatingLicensePack;
import org.eclipse.passage.loc.dashboard.ui.wizards.WithMentor;
import org.eclipse.passage.loc.internal.api.FloatingLicenseRequest;
import org.eclipse.passage.loc.internal.api.OperatorLicenseService;
import org.eclipse.passage.loc.internal.dashboard.ui.i18n.IssueLicensePageMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public final class IssueLicensePackPage
extends WizardPage {
    private final IEclipseContext context;
    private final Supplier<FloatingLicenseRequest> data;
    private final ErrorMessages validate;
    private final Adapter update = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            IssueLicensePackPage.this.updatePageComplete();
        }
    };
    private FloatingLicensePack license;
    private Composite base;

    IssueLicensePackPage(String name, Supplier<FloatingLicenseRequest> data, IEclipseContext context) {
        super(name);
        this.context = context;
        this.data = data;
        this.validate = new ErrorMessages();
        this.setTitle(IssueLicensePageMessages.IssueLicensePackPage_page_title);
        this.setDescription(IssueLicensePageMessages.IssueLicensePackPage_page_description);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.init();
        }
        super.setVisible(visible);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        this.setControl((Control)composite);
        this.base = new Composite(composite, 0);
        this.base.setLayout((Layout)new GridLayout(1, false));
        this.base.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.updatePage();
        Dialog.applyDialogFont((Control)composite);
    }

    private void init() {
        this.createLicensePack();
        this.updatePage();
    }

    private void createLicensePack() {
        if (this.license != null) {
            this.license.eAdapters().remove((Object)this.update);
        }
        this.license = ((OperatorLicenseService)this.context.get(OperatorLicenseService.class)).createFloatingLicensePack(this.data.get(), Optional.ofNullable(this.license));
        this.license.eAdapters().add((Object)this.update);
    }

    private void updatePage() {
        if (this.base == null || this.base.isDisposed()) {
            this.setPageComplete(false);
            return;
        }
        this.renderEmfForms();
        this.updatePageComplete();
    }

    private void updatePageComplete() {
        this.setPageComplete(this.validatePage());
    }

    private void renderEmfForms() {
        if (this.license == null) {
            return;
        }
        try {
            Arrays.asList(this.base.getChildren()).forEach(Widget::dispose);
            ECPSWTViewRenderer.INSTANCE.render(this.base, (EObject)this.license, this.properties());
            this.base.layout();
        }
        catch (ECPRendererException eCPRendererException) {
            // empty catch block
        }
    }

    private VViewModelProperties properties() {
        VViewModelLoadingProperties properties = VViewFactory.eINSTANCE.createViewModelLoadingProperties();
        properties.addInheritableProperty("viewpoint", (Object)"wizard");
        properties.addInheritableProperty("useOnModifyDatabinding", (Object)"true");
        new WithMentor((EObject)this.license, this.context).inProperties((VViewModelProperties)properties);
        return properties;
    }

    protected boolean validatePage() {
        Optional errors = this.validate.apply((EObject)this.license);
        this.setErrorMessage(errors.orElse(null));
        return errors.isEmpty();
    }

    FloatingLicensePack pack() {
        return this.license;
    }
}

