/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.panel;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.passage.lic.agreements.model.api.Agreement;
import org.eclipse.passage.lic.agreements.model.api.AgreementGroup;
import org.eclipse.passage.lic.emf.meta.ClassMetadata;
import org.eclipse.passage.lic.emf.meta.ComposableClassMetadata;
import org.eclipse.passage.lic.features.model.api.Feature;
import org.eclipse.passage.lic.features.model.api.FeatureSet;
import org.eclipse.passage.lic.features.model.api.FeatureVersion;
import org.eclipse.passage.lic.internal.agreements.model.AgreementsClassMetadata;
import org.eclipse.passage.lic.internal.features.model.FeaturesClassMetadata;
import org.eclipse.passage.lic.internal.licenses.model.LicensesClassMetadata;
import org.eclipse.passage.lic.internal.products.model.ProductsClassMetadata;
import org.eclipse.passage.lic.internal.users.model.UsersClassMetadata;
import org.eclipse.passage.lic.licenses.model.api.LicensePlan;
import org.eclipse.passage.lic.products.model.api.Product;
import org.eclipse.passage.lic.products.model.api.ProductLine;
import org.eclipse.passage.lic.products.model.api.ProductVersion;
import org.eclipse.passage.lic.products.model.api.ProductVersionFeature;
import org.eclipse.passage.lic.users.model.api.User;
import org.eclipse.passage.lic.users.model.api.UserOrigin;
import org.eclipse.passage.loc.dashboard.ui.panel.DashboardPanelAdvisor;
import org.eclipse.passage.loc.dashboard.ui.panel.DefaultDashboardPanelAdvisor;
import org.eclipse.passage.loc.internal.agreements.AgreementRegistry;
import org.eclipse.passage.loc.internal.features.FeatureRegistry;
import org.eclipse.passage.loc.internal.licenses.LicenseRegistry;
import org.eclipse.passage.loc.internal.products.ProductRegistry;
import org.eclipse.passage.loc.internal.users.UserRegistry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class DashboardPanelPart {
    private final FeatureRegistry features;
    private final ProductRegistry products;
    private final UserRegistry users;
    private final AgreementRegistry agreements;
    private final LicenseRegistry licenses;
    private final DashboardPanelAdvisor dashboard;

    @Inject
    public DashboardPanelPart(IEclipseContext context) {
        this.features = (FeatureRegistry)context.get(FeatureRegistry.class);
        this.products = (ProductRegistry)context.get(ProductRegistry.class);
        this.users = (UserRegistry)context.get(UserRegistry.class);
        this.agreements = (AgreementRegistry)context.get(AgreementRegistry.class);
        this.licenses = (LicenseRegistry)context.get(LicenseRegistry.class);
        this.dashboard = this.dashboard(context);
    }

    private DashboardPanelAdvisor dashboard(IEclipseContext context) {
        DashboardPanelAdvisor advisor = (DashboardPanelAdvisor)context.get(DashboardPanelAdvisor.class);
        if (advisor == null) {
            advisor = new DefaultDashboardPanelAdvisor();
        }
        return advisor;
    }

    @PostConstruct
    public void postConstruct(Composite parent, IEclipseContext context) {
        this.dashboard.init(context);
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        area.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        this.createHeaderInfo(area);
        this.createFeatureInfo(area);
        this.createProductInfo(area);
        this.createUserInfo(area);
        this.createAgreementInfo(area);
        this.createLicenseInfo(area);
        this.createFooterInfo(area);
        ComposableClassMetadata metadata = (ComposableClassMetadata)EclipseContextFactory.getServiceContext((BundleContext)FrameworkUtil.getBundle(this.getClass()).getBundleContext()).get(ComposableClassMetadata.class);
        metadata.consider((ClassMetadata)new FeaturesClassMetadata());
        metadata.consider((ClassMetadata)new ProductsClassMetadata());
        metadata.consider((ClassMetadata)new UsersClassMetadata());
        metadata.consider((ClassMetadata)new AgreementsClassMetadata());
        metadata.consider((ClassMetadata)new LicensesClassMetadata());
    }

    protected void createHeaderInfo(Composite parent) {
        this.dashboard.createHeaderInfo(parent);
    }

    protected void createFeatureInfo(Composite parent) {
        this.dashboard.createFeatureInfo(parent, this.features);
    }

    protected void createProductInfo(Composite parent) {
        this.dashboard.createProductInfo(parent, this.products);
    }

    protected void createUserInfo(Composite parent) {
        this.dashboard.createUserInfo(parent, this.users);
    }

    protected void createAgreementInfo(Composite parent) {
        this.dashboard.createAgreementInfo(parent, this.agreements);
    }

    protected void createLicenseInfo(Composite parent) {
        this.dashboard.createLicenseInfo(parent, this.licenses);
    }

    protected void createFooterInfo(Composite parent) {
        this.dashboard.createFooterInfo(parent);
    }

    @Inject
    @Optional
    public void createdFeatureSet(@UIEventTopic(value="org/eclipse/passage/lic/features/registry/FeatureSet/create") FeatureSet input) {
        this.dashboard.updateFeatureInfo(this.features);
    }

    @Inject
    @Optional
    public void deletedFeatureSet(@UIEventTopic(value="org/eclipse/passage/lic/features/registry/FeatureSet/delete") FeatureSet input) {
        this.dashboard.updateFeatureInfo(this.features);
    }

    @Inject
    @Optional
    public void createdFeature(@UIEventTopic(value="org/eclipse/passage/lic/features/registry/Feature/create") Feature input) {
        this.dashboard.updateFeatureInfo(this.features);
    }

    @Inject
    @Optional
    public void deletedFeature(@UIEventTopic(value="org/eclipse/passage/lic/features/registry/Feature/delete") Feature input) {
        this.dashboard.updateFeatureInfo(this.features);
    }

    @Inject
    @Optional
    public void createdFeatureVersion(@UIEventTopic(value="org/eclipse/passage/lic/features/registry/FeatureVersion/create") FeatureVersion input) {
        this.dashboard.updateFeatureInfo(this.features);
    }

    @Inject
    @Optional
    public void deletedFeatureVersion(@UIEventTopic(value="org/eclipse/passage/lic/features/registry/FeatureVersion/delete") FeatureVersion input) {
        this.dashboard.updateFeatureInfo(this.features);
    }

    @Inject
    @Optional
    public void createdProductLine(@UIEventTopic(value="org/eclipse/passage/lic/products/registry/ProductLine/create") ProductLine input) {
        this.dashboard.updateProductInfo(this.products);
    }

    @Inject
    @Optional
    public void deletedProductLine(@UIEventTopic(value="org/eclipse/passage/lic/products/registry/ProductLine/delete") ProductLine input) {
        this.dashboard.updateProductInfo(this.products);
    }

    @Inject
    @Optional
    public void createdProduct(@UIEventTopic(value="org/eclipse/passage/lic/products/registry/Product/create") Product input) {
        this.dashboard.updateProductInfo(this.products);
    }

    @Inject
    @Optional
    public void deletedProduct(@UIEventTopic(value="org/eclipse/passage/lic/products/registry/Product/delete") Product input) {
        this.dashboard.updateProductInfo(this.products);
    }

    @Inject
    @Optional
    public void createdProductVersion(@UIEventTopic(value="org/eclipse/passage/lic/products/registry/ProductVersion/create") ProductVersion input) {
        this.dashboard.updateProductInfo(this.products);
    }

    @Inject
    @Optional
    public void deletedProductVersion(@UIEventTopic(value="org/eclipse/passage/lic/products/registry/ProductVersion/delete") ProductVersion input) {
        this.dashboard.updateProductInfo(this.products);
    }

    @Inject
    @Optional
    public void createdProductVersionFeature(@UIEventTopic(value="org/eclipse/passage/lic/products/registry/ProductVersionFeature/create") ProductVersionFeature input) {
        this.dashboard.updateProductInfo(this.products);
    }

    @Inject
    @Optional
    public void deletedProductVersionFeature(@UIEventTopic(value="org/eclipse/passage/lic/products/registry/ProductVersionFeature/delete") ProductVersionFeature input) {
        this.dashboard.updateProductInfo(this.products);
    }

    @Inject
    @Optional
    public void createdUserOrigin(@UIEventTopic(value="org/eclipse/passage/lic/users/registry/UserOrigin/create") UserOrigin input) {
        this.dashboard.updateUserInfo(this.users);
    }

    @Inject
    @Optional
    public void deletedUserOrigin(@UIEventTopic(value="org/eclipse/passage/lic/users/registry/UserOrigin/delete") UserOrigin input) {
        this.dashboard.updateUserInfo(this.users);
    }

    @Inject
    @Optional
    public void createdUser(@UIEventTopic(value="org/eclipse/passage/lic/users/registry/User/create") User input) {
        this.dashboard.updateUserInfo(this.users);
    }

    @Inject
    @Optional
    public void deletedUser(@UIEventTopic(value="org/eclipse/passage/lic/users/registry/User/delete") User input) {
        this.dashboard.updateUserInfo(this.users);
    }

    @Inject
    @Optional
    public void createdAgreementsGroup(@UIEventTopic(value="org/eclipse/passage/lic/agreements/registry/AgreementGroup/create") AgreementGroup input) {
        this.dashboard.updateAgreementInfo(this.agreements);
    }

    @Inject
    @Optional
    public void deletedAgreementsGroup(@UIEventTopic(value="org/eclipse/passage/lic/agreements/registry/AgreementGroup/delete") AgreementGroup input) {
        this.dashboard.updateAgreementInfo(this.agreements);
    }

    @Inject
    @Optional
    public void createdAgreement(@UIEventTopic(value="org/eclipse/passage/lic/agreements/registry/Agreement/create") Agreement input) {
        this.dashboard.updateAgreementInfo(this.agreements);
    }

    @Inject
    @Optional
    public void deletedAgreement(@UIEventTopic(value="org/eclipse/passage/lic/agreements/registry/Agreement/delete") Agreement input) {
        this.dashboard.updateAgreementInfo(this.agreements);
    }

    @Inject
    @Optional
    public void createdLicensePlan(@UIEventTopic(value="org/eclipse/passage/lic/licenses/registry/LicensePlan/create") LicensePlan input) {
        this.dashboard.updateLicenseInfo(this.licenses);
    }

    @Inject
    @Optional
    public void deletedLicensePlan(@UIEventTopic(value="org/eclipse/passage/lic/licenses/registry/LicensePlan/delete") LicensePlan input) {
        this.dashboard.updateLicenseInfo(this.licenses);
    }

    @PreDestroy
    public void preDestroy(IEclipseContext context) {
        this.dashboard.dispose(context);
    }

    @Focus
    public void onFocus() {
    }

    @Persist
    public void save() {
    }
}

