/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox.requirements;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.api.requirements.Requirement;
import org.eclipse.passage.lic.base.BaseNamedData;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.SumOfCollections;
import org.eclipse.passage.lic.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.base.diagnostic.code.ServiceCannotOperate;
import org.eclipse.passage.lic.equinox.requirements.LicCapabilityNamespace;
import org.eclipse.passage.lic.equinox.requirements.RequirementFromCapability;
import org.eclipse.passage.lic.equinox.requirements.RequirementsFromManifest;
import org.eclipse.passage.lic.internal.equinox.i18n.AccessMessages;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWiring;

final class RequirementsFromBundle
extends BaseNamedData<ServiceInvocationResult<Collection<Requirement>>> {
    public RequirementsFromBundle(Bundle bundle) {
        super(key -> new FromBundle(bundle).read((String)key));
    }

    public String key() {
        return new LicCapabilityNamespace().get();
    }

    private static final class FromBundle {
        private final Bundle bundle;

        FromBundle(Bundle bundle) {
            this.bundle = bundle;
        }

        ServiceInvocationResult<Collection<Requirement>> read(String key) {
            Optional<BundleWiring> wiring = Optional.ofNullable((BundleWiring)this.bundle.adapt(BundleWiring.class));
            if (!wiring.isPresent()) {
                return this.fromManifest(String.format(AccessMessages.RequirementsFromBundle_no_wiring, this.bundle.getSymbolicName()));
            }
            Optional<List> capabilities = Optional.ofNullable(wiring.get().getCapabilities(key));
            if (!capabilities.isPresent()) {
                return this.fromManifest(String.format(AccessMessages.RequirementsFromBundle_no_capabilities, this.bundle.getSymbolicName()));
            }
            return capabilities.get().stream().map(capability -> new RequirementFromCapability(this.bundle, (BundleCapability)capability)).map(RequirementFromCapability::get).reduce((BinaryOperator<ServiceInvocationResult>)new BaseServiceInvocationResult.Sum((BinaryOperator)new SumOfCollections())).orElse((ServiceInvocationResult)new BaseServiceInvocationResult(Collections.emptyList()));
        }

        private ServiceInvocationResult<Collection<Requirement>> fromManifest(String why) {
            return new BaseServiceInvocationResult.Sum((BinaryOperator)new SumOfCollections()).apply((ServiceInvocationResult)new BaseServiceInvocationResult((Diagnostic)new BaseDiagnostic(Collections.emptyList(), Collections.singletonList(new Trouble((TroubleCode)new ServiceCannotOperate(), why)))), new RequirementsFromManifest(this.bundle).get());
        }
    }
}

