/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Cached<S, T>
implements Supplier<T> {
    private final S source;
    private final Function<S, T> retrieve;
    private final List<T> value = new ArrayList<T>(1);

    public Cached(S source, Function<S, T> retrieve) {
        Objects.requireNonNull(source, "Source cannot be null");
        Objects.requireNonNull(retrieve, "Retriever function cannot be null");
        this.source = source;
        this.retrieve = retrieve;
    }

    @Override
    public T get() {
        if (this.value.isEmpty()) {
            this.value.add(this.retrieve.apply(this.source));
        }
        return this.value.get(0);
    }
}

