/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.jetty;

import java.nio.file.Path;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.passage.lbc.internal.base.interaction.IncomingLicense;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.io.LicensingFolder;
import org.eclipse.passage.lic.internal.base.io.UserHomePath;
import org.eclipse.passage.lic.internal.jetty.interaction.Command;
import org.eclipse.passage.lic.internal.jetty.interaction.Scope;

final class UploadLicense
extends Command {
    private final Path storage;

    public UploadLicense(String scope) {
        this(scope, new LicensingFolder((Supplier)new UserHomePath()).get());
    }

    public UploadLicense(String scope, Path storage) {
        this((Scope)new Scope.Of(scope), new String[]{"upload"}, storage);
    }

    private UploadLicense(Scope scope, String[] names, Path storage) {
        super(scope, names);
        this.storage = storage;
    }

    public void upload(String from) {
        ServiceInvocationResult result = new IncomingLicense(from, this.storage).upload();
        if (result.data().isPresent()) {
            this.reportDestination((List)result.data().get());
        }
        this.reportDiagnostic(result.diagnostic());
    }

    private void reportDestination(List<Path> list) {
        System.out.println("Floating lincens(es) uploaded to ");
        list.forEach(path -> System.out.println("\t" + path.toAbsolutePath()));
    }

    public void upload(String ... args) {
        if (args.length == 1) {
            this.upload(args[0]);
        } else {
            System.out.println(this.help());
        }
    }

    private String help() {
        return "[fls:upload] scans the given folder for floating licenses and uploads all findings at the Server's disposal.\nUsage:\n\t" + this.scope.id() + ":upload <path-to-folder>\n\t";
    }
}

