/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.yars.internal.api;

import java.util.function.Consumer;
import org.eclipse.passage.loc.yars.internal.api.DefaultDosHandler;
import org.eclipse.passage.loc.yars.internal.api.ListMedia;
import org.eclipse.passage.loc.yars.internal.api.ReportException;
import org.eclipse.passage.loc.yars.internal.api.Unsafe;

public final class DosHandleMedia<T>
implements ListMedia<T> {
    private final ListMedia<T> delegate;
    private final Consumer<ReportException> dosHandler;

    public DosHandleMedia(ListMedia<T> delegate, Consumer<ReportException> dosHandler) {
        this.delegate = delegate;
        this.dosHandler = dosHandler;
    }

    public DosHandleMedia(ListMedia<T> delegate) {
        this(delegate, new DefaultDosHandler());
    }

    @Override
    public final void start() {
        this.safeCall(this.delegate::start);
    }

    @Override
    public final void finish() {
        this.safeCall(this.delegate::finish);
    }

    @Override
    public final void startNode(T node) {
        this.safeCall(() -> this.delegate.startNode(node));
    }

    @Override
    public final void finishNode(T node) {
        this.safeCall(() -> this.delegate.finishNode(node));
    }

    @Override
    public final void inner(String data, String name) {
        this.safeCall(() -> this.delegate.inner(data, name));
    }

    private void safeCall(Unsafe<ReportException> unsafe) {
        try {
            unsafe.call();
        }
        catch (ReportException e) {
            this.dosHandler.accept(e);
        }
    }
}

