/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.workbench;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.emf.meta.ComposableClassMetadata;
import org.eclipse.passage.lic.emf.meta.EntityMetadata;
import org.eclipse.passage.lic.internal.api.MandatoryService;
import org.eclipse.passage.lic.jface.resource.LicensingImages;
import org.eclipse.passage.loc.internal.emf.EditingDomainRegistry;
import org.eclipse.passage.loc.internal.emf.EditingDomainRegistryAccess;
import org.eclipse.passage.loc.internal.workbench.i18n.WorkbenchMessages;
import org.eclipse.passage.loc.internal.workbench.wizards.BaseClassifierWizard;
import org.eclipse.passage.moveto.lic.emf.edit.EClassResources;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public abstract class CreateClassifier<C>
implements Supplier<Optional<C>> {
    protected final MandatoryService context;
    private final String domain;
    private final Class<C> clazz;

    public CreateClassifier(MandatoryService context, String domain, Class<C> classifier) {
        Objects.requireNonNull(context, WorkbenchMessages.CreateDomainResource_e_null_context);
        Objects.requireNonNull(domain, WorkbenchMessages.CreateDomainResource_e_null_domain);
        Objects.requireNonNull(classifier, WorkbenchMessages.CreateDomainResource_e_null_classifier);
        this.context = context;
        this.domain = domain;
        this.clazz = classifier;
    }

    @Override
    public Optional<C> get() {
        EditingDomainRegistryAccess registryAccess = (EditingDomainRegistryAccess)this.context.get(EditingDomainRegistryAccess.class);
        EditingDomainRegistry registry = registryAccess.getDomainRegistry(this.domain);
        return this.showWizard(this.clazz, registry).filter(this.clazz::isInstance).flatMap(e -> Optional.of(this.clazz.cast(e)));
    }

    protected Optional<EObject> showWizard(Class<C> type, EditingDomainRegistry<?> registry) {
        Optional found = ((ComposableClassMetadata)this.context.get(ComposableClassMetadata.class)).find(type);
        if (!found.isPresent()) {
            return Optional.empty();
        }
        EntityMetadata metadata = (EntityMetadata)found.get();
        EClass eClass = metadata.eClass();
        ResourceLocator resourceLocator = new EClassResources(eClass).get();
        String typeName = resourceLocator.getString(NLS.bind((String)"_UI_{0}_type", (Object)eClass.getName()));
        BaseClassifierWizard<?> wizard = this.createWizard(type, metadata, registry);
        Shell parentShell = (Shell)this.context.get(Shell.class);
        WizardDialog dialog = new WizardDialog(parentShell, wizard);
        dialog.create();
        dialog.setTitle(typeName);
        dialog.setMessage(this.dialogMessage(typeName));
        Shell createdShell = dialog.getShell();
        Point location = createdShell.getLocation();
        createdShell.setLocation(location.x + 40, location.y + 40);
        createdShell.setText(NLS.bind((String)WorkbenchMessages.CreateClassifier_text_new_type, (Object)typeName));
        createdShell.setImage(LicensingImages.getImage((String)eClass.getName()));
        dialog.open();
        return wizard.created();
    }

    protected abstract String dialogMessage(String var1);

    protected abstract BaseClassifierWizard<?> createWizard(Class<C> var1, EntityMetadata var2, EditingDomainRegistry<?> var3);
}

