/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.jetty;

import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.passage.lbc.internal.base.Port;
import org.eclipse.passage.lbc.internal.jetty.JettyException;
import org.eclipse.passage.lbc.internal.jetty.JettyHandler;
import org.eclipse.passage.lbc.internal.jetty.i18n.Messages;

final class JettyServer {
    private final Logger logger = Log.getLogger(JettyServer.class);
    private Server server;

    JettyServer() {
    }

    void launch(Port port) throws JettyException {
        try {
            this.server = new Server(((Integer)port.get().get()).intValue());
            this.server.setHandler((Handler)new JettyHandler());
            this.server.start();
            this.logger.info(String.format(Messages.started, port.get()), new Object[0]);
        }
        catch (Exception exception) {
            throw new JettyException(String.format(Messages.error_onstart, exception.getClass(), exception.getMessage()), exception);
        }
    }

    void terminate() throws JettyException {
        try {
            this.server.stop();
            this.logger.info(String.format(Messages.stopped, new Object[0]), new Object[0]);
        }
        catch (Exception exception) {
            throw new JettyException(String.format(Messages.error_onstop, exception.getClass(), exception.getMessage()), exception);
        }
    }
}

