/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui.internal.pde;

import java.io.File;
import java.net.URI;
import java.util.Objects;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.oomph.ui.internal.pde.TargetSnapshot;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.osgi.framework.Version;

public final class TargetElement
implements Comparable<TargetElement> {
    private static final String SOURCE = "Source";
    private final TargetSnapshot snapshot;
    private final Type type;
    private final String name;
    private final Version version;
    private final boolean source;
    private final String location;

    private TargetElement(TargetSnapshot snapshot, Type type, String name, String version, boolean source, String location) {
        this.snapshot = Objects.requireNonNull(snapshot);
        this.type = Objects.requireNonNull(type);
        this.name = Objects.requireNonNull(name);
        this.version = Version.parseVersion((String)version);
        this.source = source;
        this.location = location;
    }

    public TargetSnapshot getSnapshot() {
        return this.snapshot;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean isSource() {
        return this.source;
    }

    public String getLocation() {
        return this.location;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.version});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TargetElement other = (TargetElement)obj;
        return this.name.equals(other.name) && this.type == other.type && this.version.equals((Object)other.version);
    }

    @Override
    public int compareTo(TargetElement o) {
        int result = this.name.compareTo(o.name);
        if (result == 0 && (result = Integer.compare(this.type.ordinal(), o.type.ordinal())) == 0) {
            result = this.version.compareTo(o.version);
        }
        return result;
    }

    public String toString() {
        return this.typeString() + "[" + this.name + "@" + String.valueOf(this.version) + "]";
    }

    private String typeString() {
        return (this.source ? SOURCE : "") + String.valueOf((Object)this.type);
    }

    public static TargetElement fromFeature(TargetSnapshot snapshot, TargetFeature targetFeature) {
        String location = targetFeature.getLocation();
        return new TargetElement(snapshot, Type.Feature, targetFeature.getId(), targetFeature.getVersion(), false, location);
    }

    public static TargetElement fromBundle(TargetSnapshot snapshot, TargetBundle targetBundle) {
        BundleInfo bundleInfo = targetBundle.getBundleInfo();
        Type type = targetBundle.isFragment() ? Type.Fragment : Type.Bundle;
        String name = bundleInfo.getSymbolicName();
        String version = bundleInfo.getVersion();
        boolean source = targetBundle.isSourceBundle();
        URI uri = targetBundle.getBundleInfo().getLocation();
        String location = "file".equals(uri.getScheme()) ? new File(uri.getPath()).getAbsolutePath() : uri.toString();
        return new TargetElement(snapshot, type, name, version, source, location);
    }

    public static enum Type {
        Feature,
        Bundle,
        Fragment;

    }
}

