/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.minmax;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericStack;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.addons.minmax.Messages;
import org.eclipse.e4.ui.workbench.addons.minmax.TrimPaneLayout;
import org.eclipse.e4.ui.workbench.addons.minmax.TrimStackIdHelper;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.renderers.swt.TrimmedPartLayout;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class TrimStack {
    public static String CONTRIBUTION_URI = "bundleclass://org.eclipse.e4.ui.workbench.addons.swt/org.eclipse.e4.ui.workbench.addons.minmax.TrimStack";
    private static final String LAYOUT_ICON_URI = "platform:/plugin/org.eclipse.e4.ui.workbench.addons.swt/icons/full/obj16/layout_co.svg";
    private static final String RESTORE_ICON_URI = "platform:/plugin/org.eclipse.e4.ui.workbench.addons.swt/icons/full/etool16/fastview_restore.svg";
    public static final String USE_OVERLAYS_KEY = "UseOverlays";
    static final String STATE_XSIZE = "XSize";
    static final String STATE_YSIZE = "YSize";
    public static final String MINIMIZED_AND_SHOWING = "MinimizedAndShowing";
    private Image layoutImage;
    private Image restoreImage;
    private ToolBar trimStackTB;
    private Menu trimStackMenu;
    private boolean cachedUseOverlays = true;
    private boolean isShowing = false;
    private MUIElement minimizedElement;
    private Composite hostPane;
    @Inject
    @Named(value="org.eclipse.e4.ui.workbench.IResourceUtilities")
    private IResourceUtilities<ImageDescriptor> resUtils;
    private final Map<String, Image> imageMap = new HashMap<String, Image>();
    ControlListener caResizeListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            if (TrimStack.this.hostPane != null && TrimStack.this.hostPane.isVisible()) {
                TrimStack.this.setPaneLocation();
            }
        }
    };
    @Inject
    EModelService modelService;
    @Inject
    EPartService partService;
    @Inject
    MWindow window;
    @Inject
    MToolControl toolControl;
    @Inject
    protected IEventBroker eventBroker;
    private final Listener escapeListener = event -> {
        if (event.character == '\u001b') {
            this.showStack(false);
            this.partService.requestActivation();
        }
    };
    private final EventHandler closeHandler = event -> {
        MPart innerPart;
        if (!this.isShowing) {
            return;
        }
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        if (changedElement instanceof MPerspectiveStack) {
            this.showStack(false);
            return;
        }
        if (changedElement instanceof MCompositePart && (innerPart = this.getLeafPart(changedElement)) != null) {
            this.fixToolItemSelection();
            return;
        }
        if (changedElement == this.getLeafPart(this.minimizedElement)) {
            this.fixToolItemSelection();
            return;
        }
        this.showStack(false);
    };
    private final EventHandler shutdownHandler = event -> this.showStack(false);
    private final EventHandler openHandler = event -> {
        if (this.isShowing) {
            return;
        }
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        if (this.getLeafPart(this.minimizedElement) == changedElement && !(this.minimizedElement instanceof MPerspectiveStack)) {
            this.showStack(true);
            return;
        }
        MUIElement selectedElement = null;
        if (this.minimizedElement instanceof MPlaceholder) {
            selectedElement = ((MPlaceholder)this.minimizedElement).getRef();
        } else if (this.minimizedElement instanceof MPartStack) {
            selectedElement = ((MPartStack)this.minimizedElement).getSelectedElement();
        }
        if (selectedElement == null) {
            return;
        }
        if (selectedElement instanceof MPlaceholder) {
            selectedElement = ((MPlaceholder)selectedElement).getRef();
        }
        if (changedElement != selectedElement) {
            return;
        }
        this.showStack(true);
    };
    private final EventHandler toBeRenderedHandler = event -> {
        if (this.minimizedElement == null || this.trimStackTB == null) {
            return;
        }
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        if (changedElement == this.minimizedElement && !this.minimizedElement.isToBeRendered()) {
            this.restoreStack();
            return;
        }
        MElementContainer parentElement = changedElement.getParent();
        if (parentElement == this.minimizedElement) {
            this.trimStackTB.getDisplay().asyncExec(this::updateTrimStackItems);
        }
    };
    private final EventHandler childrenHandler = event -> {
        if (this.minimizedElement == null || this.trimStackTB == null) {
            return;
        }
        Object changedObj = event.getProperty("ChangedElement");
        if (changedObj == this.minimizedElement) {
            this.trimStackTB.getDisplay().asyncExec(this::updateTrimStackItems);
        }
    };
    private final EventHandler widgetHandler = event -> {
        Object changedObj = event.getProperty("ChangedElement");
        if (changedObj != this.minimizedElement) {
            return;
        }
        if (this.minimizedElement.getWidget() != null) {
            this.trimStackTB.getDisplay().asyncExec(this::updateTrimStackItems);
        }
    };
    private final SelectionListener toolItemSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            ToolItem toolItem = (ToolItem)e.widget;
            MUIElement uiElement = (MUIElement)toolItem.getData();
            if (!toolItem.getSelection()) {
                TrimStack.this.partService.requestActivation();
                TrimStack.this.showStack(false);
                return;
            }
            if (uiElement instanceof MPart) {
                TrimStack.this.partService.activate((MPart)uiElement);
            } else if (uiElement instanceof MPerspective) {
                uiElement.getParent().setSelectedElement(uiElement);
            }
            TrimStack.this.showStack(true);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private int fixedSides;
    private Composite originalParent;

    /*
     * WARNING - void declaration
     */
    @Inject
    @Optional
    private void subscribeTopicTagsChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/tags/*") Event event) {
        void changedElement;
        Object changedObj = event.getProperty("ChangedElement");
        if (!(changedObj instanceof MToolControl)) {
            return;
        }
        MToolControl mToolControl = (MToolControl)changedObj;
        if (changedElement.getObject() != this) {
            return;
        }
        if (UIEvents.isREMOVE((Event)event) && UIEvents.contains((Event)event, (String)"OldValue", (Object)MINIMIZED_AND_SHOWING)) {
            this.showStack(false);
        }
    }

    private Image getOverrideImage(MUIElement element) {
        Image result = null;
        Object imageObject = element.getTransientData().get("e4_override_icon_image_key");
        if (imageObject != null && imageObject instanceof Image && !((Image)imageObject).isDisposed()) {
            result = (Image)imageObject;
        }
        return result;
    }

    private String getOverrideTitleToolTip(MUIElement element) {
        String label;
        Object result = null;
        Object stringObject = element.getTransientData().get("e4_override_title_tool_tip_key");
        if (stringObject != null && stringObject instanceof String) {
            result = (String)stringObject;
        }
        if (result == null || ((String)result).length() == 0) {
            return null;
        }
        if (element instanceof MUILabel && (label = ((MUILabel)element).getLocalizedLabel()) != null && label.length() > 0) {
            result = label + " (" + (String)result + ")";
        }
        return result;
    }

    @Inject
    @Optional
    private void handleTransientDataEvents(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/transientData/*") Event event) {
        ToolItem toolItem;
        if (this.trimStackTB == null || this.trimStackTB.isDisposed() || this.minimizedElement.getWidget() == null) {
            return;
        }
        Object changedElement = event.getProperty("ChangedElement");
        if (!(changedElement instanceof MUIElement)) {
            return;
        }
        String key = UIEvents.isREMOVE((Event)event) ? (String)((Map.Entry)event.getProperty("OldValue")).getKey() : (String)((Map.Entry)event.getProperty("NewValue")).getKey();
        if (key.equals("e4_override_icon_image_key")) {
            ToolItem toolItem2 = this.getChangedToolItem((MUIElement)changedElement);
            if (toolItem2 != null) {
                toolItem2.setImage(this.getImage((MUILabel)toolItem2.getData()));
            }
        } else if (key.equals("e4_override_title_tool_tip_key") && (toolItem = this.getChangedToolItem((MUIElement)changedElement)) != null) {
            toolItem.setToolTipText(this.getLabelText((MUILabel)toolItem.getData()));
        }
    }

    @Inject
    @Optional
    private void subscribeTopicIconUriChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/UILabel/iconURI/*") Event event) {
        if (this.trimStackTB == null || this.trimStackTB.isDisposed() || this.minimizedElement.getWidget() == null) {
            return;
        }
        Object changedElement = event.getProperty("ChangedElement");
        if (!(changedElement instanceof MUIElement)) {
            return;
        }
        ToolItem toolItem = this.getChangedToolItem((MUIElement)changedElement);
        if (toolItem != null) {
            toolItem.setImage(this.getImage((MUILabel)toolItem.getData()));
        }
    }

    private ToolItem getChangedToolItem(MUIElement changedElement) {
        ToolItem[] toolItems;
        ToolItem[] toolItemArray = toolItems = this.trimStackTB.getItems();
        int n = toolItems.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem toolItem = toolItemArray[n2];
            if (changedElement.equals(toolItem.getData())) {
                return toolItem;
            }
            ++n2;
        }
        return null;
    }

    private void fixToolItemSelection() {
        if (this.trimStackTB == null || this.trimStackTB.isDisposed()) {
            return;
        }
        if (!this.isShowing) {
            ToolItem[] toolItemArray = this.trimStackTB.getItems();
            int n = toolItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ToolItem item = toolItemArray[n2];
                item.setSelection(false);
                ++n2;
            }
        } else if ((this.isEditorStack() || this.minimizedElement instanceof MPlaceholder) && this.trimStackTB.getItemCount() > 1) {
            this.trimStackTB.getItem(1).setSelection(true);
        } else if (this.isPerspectiveStack()) {
            MPerspectiveStack pStack = (MPerspectiveStack)this.minimizedElement;
            MUIElement selElement = pStack.getSelectedElement();
            ToolItem[] toolItemArray = this.trimStackTB.getItems();
            int n = toolItemArray.length;
            int n3 = 0;
            while (n3 < n) {
                ToolItem item;
                item.setSelection((item = toolItemArray[n3]).getData() == selElement);
                ++n3;
            }
        } else {
            MPartStack partStack = (MPartStack)this.minimizedElement;
            MUIElement selElement = partStack.getSelectedElement();
            if (selElement instanceof MPlaceholder) {
                selElement = ((MPlaceholder)selElement).getRef();
            }
            ToolItem[] toolItemArray = this.trimStackTB.getItems();
            int n = toolItemArray.length;
            int n4 = 0;
            while (n4 < n) {
                ToolItem item = toolItemArray[n4];
                boolean isSel = item.getData() == selElement;
                item.setSelection(isSel);
                ++n4;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isEditorStack() {
        void ph;
        MUIElement mUIElement = this.minimizedElement;
        if (!(mUIElement instanceof MPlaceholder)) {
            return false;
        }
        MPlaceholder mPlaceholder = (MPlaceholder)mUIElement;
        return ph.getRef() instanceof MArea;
    }

    private boolean isPerspectiveStack() {
        return this.minimizedElement instanceof MPerspectiveStack;
    }

    private MPart getLeafPart(MUIElement element) {
        if (element instanceof MPlaceholder) {
            return this.getLeafPart(((MPlaceholder)element).getRef());
        }
        if (element instanceof MElementContainer) {
            return this.getLeafPart(((MElementContainer)element).getSelectedElement());
        }
        if (element instanceof MPart) {
            return (MPart)element;
        }
        return null;
    }

    @PostConstruct
    void addListeners() {
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", this.childrenHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*", this.toBeRenderedHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/widget/*", this.widgetHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/bringToTop", this.openHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/activate", this.closeHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/appShutdownStarted", this.shutdownHandler);
    }

    private Composite getCAComposite() {
        if (this.trimStackTB == null) {
            return null;
        }
        Shell theShell = this.trimStackTB.getShell();
        if (theShell.getLayout() instanceof TrimmedPartLayout) {
            TrimmedPartLayout tpl = (TrimmedPartLayout)theShell.getLayout();
            if (!tpl.clientArea.isDisposed()) {
                return tpl.clientArea;
            }
        }
        return null;
    }

    @PreDestroy
    void removeListeners() {
        this.eventBroker.unsubscribe(this.toBeRenderedHandler);
        this.eventBroker.unsubscribe(this.childrenHandler);
        this.eventBroker.unsubscribe(this.widgetHandler);
        this.eventBroker.unsubscribe(this.openHandler);
        this.eventBroker.unsubscribe(this.closeHandler);
    }

    @PostConstruct
    void createWidget(Composite parent, MToolControl me) {
        if (this.minimizedElement == null) {
            this.minimizedElement = this.findElement();
        }
        MElementContainer meParent = me.getParent();
        int orientation = 256;
        if (meParent instanceof MTrimBar) {
            MTrimBar bar = (MTrimBar)meParent;
            if (bar.getSide() == SideValue.RIGHT || bar.getSide() == SideValue.LEFT) {
                orientation = 512;
            }
            me.getTags().add("Draggable");
        }
        this.trimStackTB = new ToolBar(parent, orientation | 0x800000 | 0x40);
        this.trimStackTB.addDisposeListener(e -> {
            this.showStack(false);
            this.trimStackTB = null;
            this.trimStackMenu = null;
        });
        this.trimStackTB.addListener(35, event -> {
            while (this.trimStackMenu.getItemCount() > 0) {
                this.trimStackMenu.getItem(0).dispose();
            }
            Point point = this.trimStackTB.getDisplay().map(null, (Control)this.trimStackTB, new Point(event.x, event.y));
            ToolItem selectedToolItem = this.trimStackTB.getItem(point);
            if (selectedToolItem == null) {
                return;
            }
            Object data = selectedToolItem.getData();
            if (data instanceof MPart) {
                this.createPartMenu((MPart)data);
            } else if (data instanceof MPerspective) {
                this.createEmtpyEditorAreaMenu();
            } else if (this.isEditorStack()) {
                this.createEmtpyEditorAreaMenu();
            } else {
                this.createUseOverlaysMenu();
            }
        });
        this.trimStackMenu = new Menu((Control)this.trimStackTB);
        this.trimStackTB.setMenu(this.trimStackMenu);
        ToolItem restoreBtn = new ToolItem(this.trimStackTB, 8);
        restoreBtn.setToolTipText(Messages.TrimStack_RestoreText);
        restoreBtn.setImage(this.getRestoreImage());
        restoreBtn.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.minimizedElement.getTags().remove("Minimized");
        }));
        this.updateTrimStackItems();
    }

    private void createEmtpyEditorAreaMenu() {
        MenuItem restoreItem = new MenuItem(this.trimStackMenu, 0);
        restoreItem.setText(Messages.TrimStack_RestoreText);
        restoreItem.addListener(13, event -> {
            boolean bl = this.minimizedElement.getTags().remove("Minimized");
        });
    }

    private void createUseOverlaysMenu() {
        MenuItem useOverlaysItem = new MenuItem(this.trimStackMenu, 32);
        useOverlaysItem.setText(Messages.TrimStack_Show_In_Original_Location);
        useOverlaysItem.setSelection(!this.useOverlays());
        useOverlaysItem.addListener(13, event -> {
            if (this.toolControl != null) {
                this.toolControl.getPersistedState().put(USE_OVERLAYS_KEY, Boolean.toString(!this.useOverlays()));
            }
        });
    }

    private void createPartMenu(MPart selectedPart) {
        MenuItem orientationItem = new MenuItem(this.trimStackMenu, 64);
        orientationItem.setText(Messages.TrimStack_OrientationMenu);
        Menu orientationMenu = new Menu(orientationItem);
        orientationItem.setMenu(orientationMenu);
        MenuItem defaultItem = new MenuItem(orientationMenu, 16);
        defaultItem.setText(Messages.TrimStack_DefaultOrientationItem);
        defaultItem.addListener(13, event -> {
            boolean doRefresh = this.minimizedElement.getTags().remove("Horizontal");
            if (this.isShowing && (doRefresh |= this.minimizedElement.getTags().remove("Vertical"))) {
                this.setPaneLocation();
            }
        });
        MenuItem horizontalItem = new MenuItem(orientationMenu, 16);
        horizontalItem.setText(Messages.TrimStack_Horizontal);
        horizontalItem.addListener(13, event -> {
            if (!this.minimizedElement.getTags().contains("Horizontal")) {
                this.minimizedElement.getTags().remove("Vertical");
                this.minimizedElement.getTags().add("Horizontal");
                if (this.isShowing) {
                    this.setPaneLocation();
                }
            }
        });
        MenuItem verticalItem = new MenuItem(orientationMenu, 16);
        verticalItem.setText(Messages.TrimStack_Vertical);
        verticalItem.addListener(13, event -> {
            if (!this.minimizedElement.getTags().contains("Vertical")) {
                this.minimizedElement.getTags().remove("Horizontal");
                this.minimizedElement.getTags().add("Vertical");
                if (this.isShowing) {
                    this.setPaneLocation();
                }
            }
        });
        if (this.minimizedElement.getTags().contains("Horizontal")) {
            horizontalItem.setSelection(true);
        } else if (this.minimizedElement.getTags().contains("Vertical")) {
            verticalItem.setSelection(true);
        } else {
            defaultItem.setSelection(true);
        }
        MenuItem restoreItem = new MenuItem(this.trimStackMenu, 0);
        restoreItem.setText(Messages.TrimStack_RestoreText);
        restoreItem.addListener(13, event -> {
            this.minimizedElement.getTags().remove("Minimized");
            this.partService.activate(selectedPart);
        });
        if (!this.isEditorStack()) {
            MenuItem closeItem = new MenuItem(this.trimStackMenu, 0);
            closeItem.setText(Messages.TrimStack_CloseText);
            closeItem.addListener(13, event -> this.partService.hidePart(selectedPart));
        }
    }

    @PreDestroy
    void destroy() {
        for (Image image : this.imageMap.values()) {
            image.dispose();
        }
        if (this.layoutImage != null) {
            this.layoutImage.dispose();
            this.layoutImage = null;
        }
        if (this.restoreImage != null) {
            this.restoreImage.dispose();
            this.restoreImage = null;
        }
    }

    public MUIElement getMinimizedElement() {
        return this.minimizedElement;
    }

    private MUIElement findElement() {
        MUIElement result;
        List ps = this.modelService.findElements((MUIElement)this.window, null, MPerspectiveStack.class);
        if (ps.isEmpty()) {
            String toolControlId = this.toolControl.getElementId();
            int index = toolControlId.indexOf(40);
            String stackId = toolControlId.substring(0, index);
            result = this.modelService.find(stackId, (MUIElement)this.window);
        } else {
            List perspectives;
            String toolControlId = this.toolControl.getElementId();
            Map<TrimStackIdHelper.TrimStackIdPart, String> parsedIds = TrimStackIdHelper.parseTrimStackId(toolControlId);
            String stackId = parsedIds.get((Object)TrimStackIdHelper.TrimStackIdPart.ELEMENT_ID);
            String perspId = parsedIds.get((Object)TrimStackIdHelper.TrimStackIdPart.PERSPECTIVE_ID);
            MPerspective persp = null;
            if (perspId != null && (perspectives = this.modelService.findElements((MUIElement)ps.get(0), perspId, MPerspective.class)) != null && !perspectives.isEmpty()) {
                persp = (MPerspective)perspectives.get(0);
            }
            result = persp != null ? this.modelService.find(stackId, persp) : this.modelService.find(stackId, (MUIElement)this.window);
        }
        return result;
    }

    private String getLabelText(MUILabel label) {
        String text;
        if (label instanceof MUIElement && (text = this.getOverrideTitleToolTip((MUIElement)label)) != null && text.length() > 0) {
            return text;
        }
        String string = label.getLocalizedLabel();
        return string == null ? "" : string;
    }

    private Image getImage(MUILabel element) {
        Image image;
        if (element instanceof MUIElement && (image = this.getOverrideImage((MUIElement)element)) != null) {
            return image;
        }
        String iconURI = element.getIconURI();
        if (iconURI != null && iconURI.length() > 0) {
            Image image2 = this.imageMap.get(iconURI);
            if (image2 == null) {
                image2 = ((ImageDescriptor)this.resUtils.imageDescriptorFromURI(URI.createURI((String)iconURI))).createImage();
                this.imageMap.put(iconURI, image2);
            }
            return image2;
        }
        return null;
    }

    private MUILabel getLabelElement(MUIElement element) {
        if (element instanceof MPlaceholder) {
            element = ((MPlaceholder)element).getRef();
        }
        return (MUILabel)(element instanceof MUILabel ? element : null);
    }

    /*
     * Unable to fully structure code
     */
    private void updateTrimStackItems() {
        if (this.trimStackTB != null && !this.trimStackTB.isDisposed() && this.minimizedElement.getWidget() != null) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            this.trimStackTB.getItem(this.trimStackTB.getItemCount() - 1).dispose();
lbl4:
            // 2 sources

            ** while (this.trimStackTB.getItemCount() > 1)
        }
lbl5:
        // 1 sources

        if (this.isEditorStack() && this.trimStackTB.getItemCount() == 1) {
            ti = new ToolItem(this.trimStackTB, 32);
            ti.setToolTipText(Messages.TrimStack_SharedAreaTooltip);
            ti.setImage(this.getLayoutImage());
            ti.addSelectionListener(this.toolItemSelectionListener);
        } else {
            var2_3 = this.minimizedElement;
            if (var2_3 instanceof MPlaceholder) {
                ph = (MPlaceholder)var2_3;
                if (ph.getRef() instanceof MPart) {
                    part = (MPart)ph.getRef();
                    ti = new ToolItem(this.trimStackTB, 32);
                    ti.setData((Object)part);
                    ti.setImage(this.getImage((MUILabel)part));
                    ti.setToolTipText(this.getLabelText((MUILabel)part));
                    ti.addSelectionListener(this.toolItemSelectionListener);
                }
            } else {
                var4_7 = this.minimizedElement;
                if (var4_7 instanceof MGenericStack) {
                    theStack = (MGenericStack)var4_7;
                    hasRenderedElements = false;
                    for (MUIElement stackElement : theStack.getChildren()) {
                        if (!stackElement.isToBeRendered()) continue;
                        hasRenderedElements = true;
                        break;
                    }
                    if (hasRenderedElements) {
                        for (MUIElement stackElement : theStack.getChildren()) {
                            if (!stackElement.isToBeRendered()) continue;
                            labelElement = this.getLabelElement(stackElement);
                            newItem = new ToolItem(this.trimStackTB, 32);
                            newItem.setData((Object)labelElement);
                            newItem.setImage(this.getImage(labelElement));
                            newItem.setToolTipText(this.getLabelText(labelElement));
                            newItem.addSelectionListener(this.toolItemSelectionListener);
                        }
                    } else if (theStack.getTags().contains("NoAutoCollapse")) {
                        ti = new ToolItem(this.trimStackTB, 32);
                        ti.setToolTipText(Messages.TrimStack_EmptyStackTooltip);
                        ti.setImage(this.getLayoutImage());
                        ti.addSelectionListener(this.toolItemSelectionListener);
                    } else {
                        this.restoreStack();
                        return;
                    }
                }
            }
        }
        this.trimStackTB.pack();
        this.trimStackTB.requestLayout();
    }

    void restoreStack() {
        this.showStack(false);
        this.minimizedElement.setVisible(true);
        this.minimizedElement.getTags().remove("Minimized");
        MUIElement mUIElement = this.minimizedElement;
        if (mUIElement instanceof MPartStack) {
            MPartStack theStack = (MPartStack)mUIElement;
            MStackElement curSel = (MStackElement)theStack.getSelectedElement();
            Control ctrl = (Control)this.minimizedElement.getWidget();
            if (ctrl instanceof CTabFolder && ((CTabFolder)ctrl).getSelection() == null) {
                theStack.setSelectedElement(null);
                theStack.setSelectedElement((MUIElement)curSel);
            }
        }
        this.toolControl.setToBeRendered(false);
        if (this.hostPane != null && !this.hostPane.isDisposed()) {
            this.hostPane.dispose();
        }
        this.hostPane = null;
    }

    public void showStack(boolean show) {
        CTabFolder c;
        Control ctrl = (Control)this.minimizedElement.getWidget();
        if (ctrl == null) {
            return;
        }
        CTabFolder ctf = ctrl instanceof CTabFolder ? (c = (CTabFolder)ctrl) : null;
        Composite clientAreaComposite = this.getCAComposite();
        if (clientAreaComposite == null || clientAreaComposite.isDisposed()) {
            return;
        }
        if (show && !this.isShowing) {
            if (this.useOverlays()) {
                this.hostPane = this.getHostPane();
                this.originalParent = ctrl.getParent();
                ctrl.setParent(this.hostPane);
                if (ctf != null) {
                    Rectangle bb = ctf.getBounds();
                    --bb.width;
                    ctf.setBounds(bb);
                }
                clientAreaComposite.addControlListener(this.caResizeListener);
                this.setPaneLocation();
                this.hostPane.addListener(31, this.escapeListener);
                this.hostPane.layout(true);
                this.hostPane.moveAbove(null);
                this.hostPane.setVisible(true);
                this.cachedUseOverlays = true;
            } else {
                this.minimizedElement.setVisible(true);
                ctrl.addListener(31, this.escapeListener);
                this.cachedUseOverlays = false;
            }
            this.isShowing = true;
            this.toolControl.getTags().add(MINIMIZED_AND_SHOWING);
            MUIElement mUIElement = this.minimizedElement;
            if (mUIElement instanceof MPartStack) {
                MPlaceholder ph;
                MPartStack theStack = (MPartStack)mUIElement;
                MStackElement curSel = (MStackElement)theStack.getSelectedElement();
                if (ctf != null && ctf.getSelection() == null) {
                    theStack.setSelectedElement(null);
                    theStack.setSelectedElement((MUIElement)curSel);
                }
                if (curSel instanceof MPart) {
                    this.partService.activate((MPart)curSel);
                } else if (curSel instanceof MPlaceholder && (ph = (MPlaceholder)curSel).getRef() instanceof MPart) {
                    this.partService.activate((MPart)ph.getRef());
                }
            } else if (this.isEditorStack()) {
                MArea area = (MArea)((MPlaceholder)this.minimizedElement).getRef();
                MPart partToActivate = null;
                MUIElement selectedElement = area.getSelectedElement();
                while (partToActivate == null && selectedElement != null) {
                    if (selectedElement instanceof MPart) {
                        partToActivate = (MPart)selectedElement;
                        continue;
                    }
                    if (selectedElement instanceof MPlaceholder) {
                        MPlaceholder ph = (MPlaceholder)selectedElement;
                        if (ph.getRef() instanceof MPart) {
                            partToActivate = (MPart)ph.getRef();
                            continue;
                        }
                        selectedElement = null;
                        continue;
                    }
                    if (!(selectedElement instanceof MElementContainer)) continue;
                    MElementContainer container = (MElementContainer)selectedElement;
                    selectedElement = container.getSelectedElement();
                }
                if (partToActivate == null) {
                    List parts = this.modelService.findElements((MUIElement)area, null, MPart.class, null);
                    for (MPart part : parts) {
                        if (!this.partService.isPartVisible(part)) continue;
                        partToActivate = part;
                        break;
                    }
                }
                if (partToActivate != null) {
                    this.partService.activate(partToActivate);
                }
            } else {
                MPlaceholder ph;
                MUIElement mUIElement2 = this.minimizedElement;
                if (mUIElement2 instanceof MPlaceholder && (ph = (MPlaceholder)mUIElement2).getRef() instanceof MPart) {
                    MPart part = (MPart)ph.getRef();
                    this.partService.activate(part);
                }
            }
            this.fixToolItemSelection();
        } else if (!show && this.isShowing) {
            if (this.cachedUseOverlays) {
                clientAreaComposite.removeControlListener(this.caResizeListener);
                ctrl.setParent(this.originalParent);
                this.hostPane.dispose();
                this.hostPane = null;
            } else {
                if (ctrl != null && !ctrl.isDisposed()) {
                    ctrl.removeListener(31, this.escapeListener);
                }
                this.minimizedElement.setVisible(false);
            }
            this.isShowing = false;
            this.toolControl.getTags().remove(MINIMIZED_AND_SHOWING);
            this.fixToolItemSelection();
        }
    }

    private boolean useOverlays() {
        if (this.toolControl == null) {
            return true;
        }
        String useOverlays = (String)this.toolControl.getPersistedState().get(USE_OVERLAYS_KEY);
        if (useOverlays == null) {
            useOverlays = "true";
        }
        return Boolean.parseBoolean(useOverlays);
    }

    private void setPaneLocation() {
        Composite clientAreaComposite = this.getCAComposite();
        if (clientAreaComposite == null || clientAreaComposite.isDisposed()) {
            return;
        }
        Rectangle caRect = clientAreaComposite.getBounds();
        Point paneSize = this.hostPane.getSize();
        if (paneSize.x > caRect.width) {
            paneSize.x = caRect.width;
        }
        if (paneSize.y > caRect.height) {
            paneSize.y = caRect.height;
        }
        if (this.minimizedElement.getTags().contains("Horizontal")) {
            paneSize.x = caRect.width;
        }
        if (this.minimizedElement.getTags().contains("Vertical")) {
            paneSize.y = caRect.height;
        }
        Point loc = new Point(0, 0);
        loc.x = this.isFixed(16384) ? caRect.x : caRect.x + caRect.width - paneSize.x;
        loc.y = this.isFixed(128) ? caRect.y : caRect.y + caRect.height - paneSize.y;
        this.hostPane.setSize(paneSize);
        this.hostPane.setLocation(loc);
    }

    private void setHostSize() {
        if (this.hostPane == null || this.hostPane.isDisposed()) {
            return;
        }
        int xSize = 600;
        String xSizeStr = (String)this.toolControl.getPersistedState().get(STATE_XSIZE);
        if (xSizeStr != null) {
            xSize = Integer.parseInt(xSizeStr);
        }
        int ySize = 400;
        String ySizeStr = (String)this.toolControl.getPersistedState().get(STATE_YSIZE);
        if (ySizeStr != null) {
            ySize = Integer.parseInt(ySizeStr);
        }
        this.hostPane.setSize(xSize, ySize);
    }

    private Composite getHostPane() {
        this.hostPane = new Composite((Composite)this.trimStackTB.getShell(), 0);
        this.hostPane.setData("org.eclipse.e4.ui.ignoreDialog", (Object)Boolean.TRUE);
        this.hostPane.addDisposeListener(e -> {
            Composite composite = this.hostPane = null;
        });
        this.setHostSize();
        this.fixedSides = this.getFixedSides();
        this.hostPane.setLayout((Layout)new TrimPaneLayout(this.toolControl, this.fixedSides));
        return this.hostPane;
    }

    /*
     * WARNING - void declaration
     */
    private int getFixedSides() {
        void bar;
        MElementContainer tcParent = this.toolControl.getParent();
        if (!(tcParent instanceof MTrimBar)) {
            return 0;
        }
        MTrimBar mTrimBar = (MTrimBar)tcParent;
        Composite trimComp = (Composite)bar.getWidget();
        Rectangle trimBounds = trimComp.getBounds();
        Point trimCenter = new Point(trimBounds.width / 2, trimBounds.height / 2);
        Control trimCtrl = (Control)this.toolControl.getWidget();
        Rectangle ctrlBounds = trimCtrl.getBounds();
        Point ctrlCenter = new Point(ctrlBounds.x + ctrlBounds.width / 2, ctrlBounds.y + ctrlBounds.height / 2);
        if (bar.getSide() == SideValue.LEFT) {
            int verticalValue = ctrlCenter.y < trimCenter.y ? 128 : 1024;
            return 0x4000 | verticalValue;
        }
        if (bar.getSide() == SideValue.RIGHT) {
            int verticalValue = ctrlCenter.y < trimCenter.y ? 128 : 1024;
            return 0x20000 | verticalValue;
        }
        if (bar.getSide() == SideValue.TOP) {
            int horizontalValue = ctrlCenter.x < trimCenter.x ? 16384 : 131072;
            return 0x80 | horizontalValue;
        }
        if (bar.getSide() == SideValue.BOTTOM) {
            int horizontalValue = ctrlCenter.x < trimCenter.x ? 16384 : 131072;
            return 0x400 | horizontalValue;
        }
        return 132096;
    }

    private Image getLayoutImage() {
        if (this.layoutImage == null) {
            this.layoutImage = ((ImageDescriptor)this.resUtils.imageDescriptorFromURI(URI.createURI((String)LAYOUT_ICON_URI))).createImage();
        }
        return this.layoutImage;
    }

    private Image getRestoreImage() {
        if (this.restoreImage == null) {
            this.restoreImage = ((ImageDescriptor)this.resUtils.imageDescriptorFromURI(URI.createURI((String)RESTORE_ICON_URI))).createImage();
        }
        return this.restoreImage;
    }

    private boolean isFixed(int swtSide) {
        return (this.fixedSides & swtSide) != 0;
    }
}

