/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.attributes;

import com.github.weisj.jsvg.animation.time.Duration;
import com.github.weisj.jsvg.animation.time.TimeUnit;
import com.github.weisj.jsvg.attributes.HasMatchName;
import com.github.weisj.jsvg.attributes.SuffixUnit;
import com.github.weisj.jsvg.attributes.paint.PaintParser;
import com.github.weisj.jsvg.attributes.paint.SVGPaint;
import com.github.weisj.jsvg.attributes.transform.TransformPart;
import com.github.weisj.jsvg.attributes.value.PercentageDimension;
import com.github.weisj.jsvg.geometry.size.Angle;
import com.github.weisj.jsvg.geometry.size.AngleUnit;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.Percentage;
import com.github.weisj.jsvg.geometry.size.Unit;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.parser.SeparatorMode;
import com.github.weisj.jsvg.util.AttributeUtil;
import com.github.weisj.jsvg.util.ParserBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.UnaryOperator;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AttributeParser {
    private static final Logger LOGGER = Logger.getLogger(AttributeParser.class.getName());
    @NotNull
    private final PaintParser paintParser;
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");
    private static final Pattern TRANSFORM_PATTERN = Pattern.compile("\\w+\\([^)]*\\)");

    public AttributeParser(@NotNull PaintParser paintParser) {
        this.paintParser = paintParser;
    }

    @Contract(value="_,!null,_ -> !null")
    @Nullable
    public Length parseLength(@Nullable String value, @Nullable Length fallback, @NotNull PercentageDimension dimension) {
        return this.parseSuffixUnit(value, Unit.RAW, fallback, u -> {
            if (u == Unit.PERCENTAGE) {
                switch (dimension) {
                    case WIDTH: {
                        return Unit.PERCENTAGE_WIDTH;
                    }
                    case HEIGHT: {
                        return Unit.PERCENTAGE_HEIGHT;
                    }
                    case LENGTH: {
                        return Unit.PERCENTAGE_LENGTH;
                    }
                    case CUSTOM: {
                        return Unit.PERCENTAGE;
                    }
                    case NONE: {
                        return null;
                    }
                }
            }
            return u;
        });
    }

    @Contract(value="_,!null -> !null")
    @Nullable
    public Duration parseTimeOffsetValue(@Nullable String value, @Nullable Duration fallback) {
        return this.parseSuffixUnit(value, TimeUnit.Raw, fallback, u -> u);
    }

    @Contract(value="_,!null -> !null")
    @Nullable
    public Duration parseDuration(@Nullable String value, @Nullable Duration fallback) {
        if (value == null) {
            return fallback;
        }
        if ("indefinite".equals(value)) {
            return Duration.INDEFINITE;
        }
        Duration timeCount = this.parseSuffixUnit(value, TimeUnit.Raw, null, u -> u);
        if (timeCount != null) {
            return timeCount;
        }
        return fallback;
    }

    @Contract(value="_,!null -> !null")
    @Nullable
    public Percentage parsePercentage(@Nullable String value, @Nullable Percentage fallback) {
        return this.parsePercentage(value, fallback, 0.0f, 1.0f);
    }

    @Contract(value="_,!null,_,_ -> !null")
    @Nullable
    public Percentage parsePercentage(@Nullable String value, @Nullable Percentage fallback, float min, float max) {
        if (value == null) {
            return fallback;
        }
        try {
            float parsed = value.endsWith("%") ? Float.parseFloat(value.substring(0, value.length() - 1)) / 100.0f : Float.parseFloat(value);
            return new Percentage(Math.max(min, Math.min(max, parsed)));
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    @Contract(value="_,_,!null,_ -> !null")
    @Nullable
    private <U, V> V parseSuffixUnit(@Nullable String value, @NotNull SuffixUnit<U, V> defaultUnit, @Nullable V fallback, @NotNull UnaryOperator<@Nullable SuffixUnit<U, V>> unitMapper) {
        int i;
        if (value == null) {
            return fallback;
        }
        SuffixUnit<U, V> unit = defaultUnit;
        String lower = value.toLowerCase(Locale.ENGLISH);
        for (i = lower.length() - 1; i >= 0 && !Character.isDigit(lower.charAt(i)); --i) {
        }
        String suffix = lower.substring(i + 1);
        for (SuffixUnit<U, V> u : defaultUnit.units()) {
            if (!suffix.equals(u.suffix())) continue;
            unit = u;
            break;
        }
        if ((unit = (SuffixUnit<U, V>)unitMapper.apply(unit)) == null) {
            return fallback;
        }
        String str = lower.substring(0, lower.length() - unit.suffix().length());
        try {
            return unit.valueOf(Float.parseFloat(str));
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    public int parseInt(@Nullable String value, int fallback) {
        if (value == null) {
            return fallback;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    @Contract(value="_,!null -> !null")
    @Nullable
    public Length parseNumber(@Nullable String value, @Nullable Length fallback) {
        if (value == null) {
            return fallback;
        }
        try {
            return Unit.RAW.valueOf(Float.parseFloat(value));
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    public float parseFloat(@Nullable String value, float fallback) {
        if (value == null) {
            return fallback;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    @NotNull
    public Angle parseAngle(@Nullable String value, @NotNull Angle fallback) {
        if (value == null) {
            return fallback;
        }
        AngleUnit unit = AngleUnit.Raw;
        String lower = value.toLowerCase(Locale.ENGLISH);
        for (AngleUnit u : AngleUnit.units()) {
            if (!lower.endsWith(u.suffix())) continue;
            unit = u;
            break;
        }
        String str = lower.substring(0, lower.length() - unit.suffix().length());
        try {
            return new Angle(unit, Float.parseFloat(str));
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    @Contract(value="_,!null,_ -> !null")
    public @NotNull Length @Nullable [] parseLengthList(@Nullable String value, @NotNull Length @Nullable [] fallback, @NotNull PercentageDimension dimension) {
        if (value != null && value.equalsIgnoreCase("none")) {
            return new Length[0];
        }
        String[] values = this.parseStringList(value, SeparatorMode.COMMA_AND_WHITESPACE, null);
        if (values == null) {
            return fallback;
        }
        Length[] ret = new Length[values.length];
        for (int i = 0; i < ret.length; ++i) {
            Length length = this.parseLength(values[i], null, dimension);
            if (length == null) {
                return fallback;
            }
            ret[i] = length;
        }
        return ret;
    }

    public float @NotNull [] parseFloatList(@Nullable String value) {
        String[] values = this.parseStringList(value, SeparatorMode.COMMA_AND_WHITESPACE);
        float[] ret = new float[values.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.parseFloat(values[i], 0.0f);
        }
        return ret;
    }

    public double @NotNull [] parseDoubleList(@Nullable String value) {
        if (value == null || value.isEmpty()) {
            return new double[0];
        }
        ArrayList<Double> list = new ArrayList<Double>();
        ParserBase base = new ParserBase(value, 0);
        while (base.hasNext()) {
            list.add(base.nextDouble());
            base.consumeWhiteSpaceOrSeparator();
        }
        return list.stream().mapToDouble(Double::doubleValue).toArray();
    }

    @NotNull
    public @NotNull String @NotNull [] parseStringList(@Nullable String value, SeparatorMode separatorMode) {
        return this.parseStringList(value, separatorMode, new String[0]);
    }

    @Contract(value="_,_,!null -> !null")
    public @NotNull String @Nullable [] parseStringList(@Nullable String value, SeparatorMode separatorMode, @NotNull String @Nullable [] fallback) {
        int i;
        if (value == null || value.isEmpty()) {
            return fallback;
        }
        ArrayList<String> list = new ArrayList<String>();
        int max = value.length();
        int start = 0;
        boolean inWhiteSpace = false;
        for (i = 0; i < max; ++i) {
            char c = value.charAt(i);
            if (Character.isWhitespace(c)) {
                if (!inWhiteSpace && separatorMode.allowWhitespace() && i - start > 0) {
                    list.add(value.substring(start, i));
                    start = i + 1;
                }
                inWhiteSpace = true;
                continue;
            }
            inWhiteSpace = false;
            if (separatorMode.separator() == '\u0000' || c != separatorMode.separator()) continue;
            list.add(value.substring(start, i));
            start = i + 1;
        }
        if (i - start > 0) {
            list.add(value.substring(start, i));
        }
        return list.toArray(new String[0]);
    }

    @Nullable
    public SVGPaint parsePaint(@Nullable String value, @NotNull AttributeNode attributeNode) {
        return this.paintParser.parsePaint(value, attributeNode);
    }

    @NotNull
    public <E extends Enum<E>> E parseEnum(@Nullable String value, @NotNull E fallback) {
        E e = this.parseEnum(value, fallback.getDeclaringClass());
        if (e == null) {
            return fallback;
        }
        return e;
    }

    @Nullable
    public <E extends Enum<E>> E parseEnum(@Nullable String value, @NotNull Class<E> enumType) {
        if (value == null) {
            return null;
        }
        for (Enum enumConstant : (Enum[])enumType.getEnumConstants()) {
            String name;
            String string = name = enumConstant instanceof HasMatchName ? ((HasMatchName)((Object)enumConstant)).matchName() : enumConstant.name();
            if (!name.equalsIgnoreCase(value)) continue;
            return (E)enumConstant;
        }
        return null;
    }

    @NotNull
    private String removeWhiteSpace(@NotNull String value) {
        return WHITESPACE_PATTERN.matcher(value).replaceAll("");
    }

    @Nullable
    public String parseUrl(@Nullable String value) {
        if (value == null) {
            return null;
        }
        if (!value.startsWith("url(") || !value.endsWith(")")) {
            return this.removeWhiteSpace(value);
        }
        return this.removeWhiteSpace(value.substring(4, value.length() - 1));
    }

    public @Nullable List<@NotNull TransformPart> parseTransform(@Nullable String value) {
        if (value == null) {
            return null;
        }
        if ("none".equals(value)) {
            return null;
        }
        Matcher transformMatcher = TRANSFORM_PATTERN.matcher(value);
        ArrayList<TransformPart> parts = new ArrayList<TransformPart>();
        while (transformMatcher.find()) {
            String group = transformMatcher.group();
            TransformPart part = this.parseSingleTransformPart(group);
            if (part == null) {
                LOGGER.warning(() -> String.format("Illegal transform definition '%s' encountered error while parsing '%s'", value, group));
                return null;
            }
            parts.add(part);
        }
        return parts;
    }

    @Nullable
    private TransformPart parseSingleTransformPart(@NotNull String value) {
        int first = value.indexOf(40);
        int last = value.lastIndexOf(41);
        String command = value.substring(0, value.indexOf(40)).toLowerCase(Locale.ENGLISH);
        TransformPart.TransformType type = this.parseEnum(command, TransformPart.TransformType.class);
        if (type == null) {
            return null;
        }
        return this.parseTransformPart(type, value.substring(first + 1, last));
    }

    @Nullable
    public TransformPart parseTransformPart(TransformPart.TransformType type, @NotNull String value) {
        String[] values = this.parseStringList(value, SeparatorMode.COMMA_AND_WHITESPACE);
        Length[] lengths = this.parseTransformLengths(type, values);
        if (lengths == null) {
            return null;
        }
        return new TransformPart(type, lengths);
    }

    private Length @Nullable [] parseTransformLengths(@NotNull TransformPart.TransformType type, @NotNull @NotNull String @NotNull [] values) {
        Length[] lengths;
        switch (type) {
            case MATRIX: {
                if (values.length == 4) {
                    lengths = AttributeUtil.toNonnullArray(this.parseNumber(values[0], null), this.parseNumber(values[1], null), this.parseNumber(values[2], null), this.parseNumber(values[3], null), Length.ZERO, Length.ZERO);
                    break;
                }
                if (values.length == 6) {
                    lengths = AttributeUtil.toNonnullArray(this.parseNumber(values[0], null), this.parseNumber(values[1], null), this.parseNumber(values[2], null), this.parseNumber(values[3], null), this.parseNumber(values[4], null), this.parseNumber(values[5], null));
                    break;
                }
                lengths = null;
                break;
            }
            case TRANSLATE: {
                if (values.length == 1) {
                    lengths = AttributeUtil.toNonnullArray(this.parseLength(values[0], null, PercentageDimension.WIDTH), Length.ZERO);
                    break;
                }
                lengths = AttributeUtil.toNonnullArray(this.parseLength(values[0], null, PercentageDimension.WIDTH), this.parseLength(values[1], null, PercentageDimension.HEIGHT));
                break;
            }
            case TRANSLATE_X: {
                lengths = AttributeUtil.toNonnullArray(this.parseLength(values[0], null, PercentageDimension.WIDTH));
                break;
            }
            case TRANSLATE_Y: {
                lengths = AttributeUtil.toNonnullArray(this.parseLength(values[0], null, PercentageDimension.HEIGHT));
                break;
            }
            case ROTATE: {
                if (values.length > 2) {
                    lengths = AttributeUtil.toNonnullArray(this.parseNumber(values[0], null), this.parseLength(values[1], null, PercentageDimension.WIDTH), this.parseLength(values[2], null, PercentageDimension.HEIGHT));
                    break;
                }
                lengths = AttributeUtil.toNonnullArray(this.parseNumber(values[0], null));
                break;
            }
            case SCALE: 
            case SKEW: {
                if (values.length == 1) {
                    lengths = AttributeUtil.toNonnullArray(this.parseNumber(values[0], null));
                    break;
                }
                lengths = AttributeUtil.toNonnullArray(this.parseNumber(values[0], null), this.parseNumber(values[1], null));
                break;
            }
            case SCALE_X: 
            case SCALE_Y: 
            case SKEW_X: 
            case SKEW_Y: {
                lengths = AttributeUtil.toNonnullArray(this.parseLength(values[0], null, PercentageDimension.NONE));
                break;
            }
            default: {
                lengths = null;
            }
        }
        return lengths;
    }

    @NotNull
    public PaintParser paintParser() {
        return this.paintParser;
    }
}

