/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.dialog;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.dialog.IValidationMessageProvider;
import org.eclipse.jface.databinding.dialog.MaxSeverityValidationStatusProvider;
import org.eclipse.jface.databinding.dialog.ValidationMessageProvider;
import org.eclipse.jface.dialogs.DialogPage;

public class DialogPageSupport {
    private DialogPage dialogPage;
    private DataBindingContext dbc;
    private IValidationMessageProvider messageProvider = new ValidationMessageProvider();
    private IObservableValue<ValidationStatusProvider> aggregateStatusProvider;
    private boolean uiChanged = false;
    private IChangeListener uiChangeListener = event -> this.handleUIChanged();
    private IListChangeListener<ValidationStatusProvider> validationStatusProvidersListener = event -> {
        ListDiffEntry[] listDiffEntryArray = event.diff.getDifferences();
        int n = listDiffEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ListDiffEntry listDiffEntry = listDiffEntryArray[n2];
            IObservableList targets = ((ValidationStatusProvider)listDiffEntry.getElement()).getTargets();
            if (listDiffEntry.isAddition()) {
                targets.addListChangeListener(this.validationStatusProviderTargetsListener);
                for (IObservable observable : targets) {
                    observable.addChangeListener(this.uiChangeListener);
                }
            } else {
                targets.removeListChangeListener(this.validationStatusProviderTargetsListener);
                for (IObservable observable : targets) {
                    observable.removeChangeListener(this.uiChangeListener);
                }
            }
            ++n2;
        }
    };
    private IListChangeListener<IObservable> validationStatusProviderTargetsListener = event -> {
        ListDiffEntry[] listDiffEntryArray = event.diff.getDifferences();
        int n = listDiffEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ListDiffEntry listDiffEntry = listDiffEntryArray[n2];
            if (listDiffEntry.isAddition()) {
                ((IObservable)listDiffEntry.getElement()).addChangeListener(this.uiChangeListener);
            } else {
                ((IObservable)listDiffEntry.getElement()).removeChangeListener(this.uiChangeListener);
            }
            ++n2;
        }
    };
    private ValidationStatusProvider currentStatusProvider;
    protected IStatus currentStatus;
    protected boolean currentStatusStale;

    public static DialogPageSupport create(DialogPage dialogPage, DataBindingContext dbc) {
        return new DialogPageSupport(dialogPage, dbc);
    }

    protected DialogPageSupport(DialogPage dialogPage, DataBindingContext dbc) {
        this.dialogPage = dialogPage;
        this.dbc = dbc;
        this.init();
    }

    public void setValidationMessageProvider(IValidationMessageProvider messageProvider) {
        this.messageProvider = messageProvider;
        this.handleStatusChanged();
    }

    protected DialogPage getDialogPage() {
        return this.dialogPage;
    }

    protected void init() {
        ObservableTracker.setIgnore((boolean)true);
        try {
            this.aggregateStatusProvider = new MaxSeverityValidationStatusProvider(this.dbc);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        this.aggregateStatusProvider.addValueChangeListener(event -> this.statusProviderChanged());
        this.dialogPage.getShell().addListener(12, event -> this.dispose());
        this.aggregateStatusProvider.addStaleListener(staleEvent -> {
            this.currentStatusStale = true;
            this.handleStatusChanged();
        });
        this.statusProviderChanged();
        this.dbc.getValidationStatusProviders().addListChangeListener(this.validationStatusProvidersListener);
        for (ValidationStatusProvider validationStatusProvider : this.dbc.getValidationStatusProviders()) {
            IObservableList targets = validationStatusProvider.getTargets();
            targets.addListChangeListener(this.validationStatusProviderTargetsListener);
            for (IObservable observable : targets) {
                observable.addChangeListener(this.uiChangeListener);
            }
        }
    }

    private void statusProviderChanged() {
        this.currentStatusProvider = (ValidationStatusProvider)this.aggregateStatusProvider.getValue();
        this.currentStatus = this.currentStatusProvider != null ? (IStatus)this.currentStatusProvider.getValidationStatus().getValue() : null;
        this.currentStatusStale = this.aggregateStatusProvider.isStale();
        this.handleStatusChanged();
    }

    protected void handleUIChanged() {
        this.uiChanged = true;
        if (this.currentStatus != null) {
            this.handleStatusChanged();
        }
        this.dbc.getValidationStatusProviders().removeListChangeListener(this.validationStatusProvidersListener);
        for (ValidationStatusProvider provider : this.dbc.getValidationStatusProviders()) {
            IObservableList targets = provider.getTargets();
            targets.removeListChangeListener(this.validationStatusProviderTargetsListener);
            for (IObservable observable : targets) {
                observable.removeChangeListener(this.uiChangeListener);
            }
        }
    }

    protected void handleStatusChanged() {
        String message = this.messageProvider.getMessage(this.currentStatusProvider);
        int type = this.messageProvider.getMessageType(this.currentStatusProvider);
        if (type == 3) {
            this.dialogPage.setMessage(null);
            this.dialogPage.setErrorMessage(this.uiChanged ? message : null);
            if (this.currentStatus != null && this.currentStatusHasException()) {
                this.handleStatusException();
            }
        } else {
            this.dialogPage.setErrorMessage(null);
            this.dialogPage.setMessage(message, type);
        }
    }

    private boolean currentStatusHasException() {
        boolean hasException = false;
        if (this.currentStatus.getException() != null) {
            hasException = true;
        }
        if (this.currentStatus instanceof MultiStatus) {
            MultiStatus multiStatus = (MultiStatus)this.currentStatus;
            int i = 0;
            while (i < multiStatus.getChildren().length) {
                IStatus status = multiStatus.getChildren()[i];
                if (status.getException() != null) {
                    hasException = true;
                    break;
                }
                ++i;
            }
        }
        return hasException;
    }

    protected void handleStatusException() {
        if (this.currentStatus.getException() != null) {
            this.logThrowable(this.currentStatus.getException());
        } else if (this.currentStatus instanceof MultiStatus) {
            MultiStatus multiStatus = (MultiStatus)this.currentStatus;
            int i = 0;
            while (i < multiStatus.getChildren().length) {
                IStatus status = multiStatus.getChildren()[i];
                if (status.getException() != null) {
                    this.logThrowable(status.getException());
                }
                ++i;
            }
        }
    }

    private void logThrowable(Throwable throwable) {
        Policy.getLog().log((IStatus)new Status(4, "org.eclipse.core.databinding", 0, "Unhandled exception: " + throwable.getMessage(), throwable));
    }

    public void dispose() {
        if (this.aggregateStatusProvider != null) {
            this.aggregateStatusProvider.dispose();
        }
        if (this.dbc != null && !this.uiChanged) {
            for (ValidationStatusProvider provider : this.dbc.getValidationStatusProviders()) {
                provider.getTargets().removeListChangeListener(this.validationStatusProviderTargetsListener);
                for (IObservable observable : provider.getTargets()) {
                    observable.removeChangeListener(this.uiChangeListener);
                }
            }
            this.dbc.getValidationStatusProviders().removeListChangeListener(this.validationStatusProvidersListener);
        }
        this.aggregateStatusProvider = null;
        this.dbc = null;
        this.uiChangeListener = null;
        this.validationStatusProvidersListener = null;
        this.validationStatusProviderTargetsListener = null;
        this.dialogPage = null;
    }
}

