/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otre.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.objectteams.otre.util.BoundClass;
import org.eclipse.objectteams.otre.util.CallinBindingManager;
import org.eclipse.objectteams.otre.util.ListValueHashMap;
import org.eclipse.objectteams.otre.util.MethodBinding;

public class RoleBaseBinding {
    private BoundClass roleClass;
    private BoundClass baseClass;
    private ListValueHashMap<MethodBinding> roleMethodBindings = new ListValueHashMap();
    private ListValueHashMap<MethodBinding> baseMethodBindings = new ListValueHashMap();

    public RoleBaseBinding() {
    }

    public RoleBaseBinding(String _roleClassName, String _baseClassName, boolean baseIsInterface, String teamClassName) {
        this.roleClass = new BoundClass(_roleClassName, teamClassName);
        this.baseClass = CallinBindingManager.getBoundBaseClass(_baseClassName, teamClassName);
        this.baseClass.isInterface = baseIsInterface;
    }

    public void addMethodBinding(String bindingFileName, int bindingLineNumber, int bindingLineOffset, String bindingLabel, String roleMethodName, String roleMethodSignature, boolean isStaticRoleMethod, String wrapperName, String wrapperSignature, String modifier, String baseMethodName, String baseMethodSignature, boolean isStaticBaseMethod, boolean baseIsCallin, boolean covariantBaseReturn, int translationFlags, String liftMethodName, String liftMethodSignature) {
        MethodBinding mb = new MethodBinding(bindingFileName, bindingLineNumber, bindingLineOffset, bindingLabel, roleMethodName, roleMethodSignature, isStaticRoleMethod, wrapperName, wrapperSignature, modifier, baseMethodName, baseMethodSignature, isStaticBaseMethod, baseIsCallin, covariantBaseReturn, translationFlags, liftMethodName, liftMethodSignature, this);
        String baseMethodKey = MethodBinding.getBaseMethodKey(baseMethodName, baseMethodSignature);
        String roleMethodKey = roleMethodName + "." + roleMethodSignature;
        this.roleMethodBindings.put(roleMethodKey, mb);
        this.baseMethodBindings.put(baseMethodKey, mb);
    }

    public List<MethodBinding> getBaseMethodBindings() {
        return this.baseMethodBindings.getFlattenValues();
    }

    public List<MethodBinding> getBaseMethodBindings(String baseMethodName, String baseMethodSignature) {
        String baseMethodKey = MethodBinding.getBaseMethodKey(baseMethodName, baseMethodSignature);
        return this.baseMethodBindings.get(baseMethodKey);
    }

    public List<MethodBinding> getRoleMethodBindings() {
        return this.roleMethodBindings.getFlattenValues();
    }

    public List<MethodBinding> getRoleMethodBindings(String roleMethodName, String roleMethodSignature) {
        String roleMethodKey = roleMethodName + "." + roleMethodSignature;
        return this.roleMethodBindings.get(roleMethodKey);
    }

    public boolean hasRoleMethodBinding(String roleMethodName, String roleMethodSignature) {
        String signatureWithoutReturnType = roleMethodSignature.substring(0, roleMethodSignature.lastIndexOf(41) + 1);
        Set<String> bindingKeys = this.roleMethodBindings.keySet();
        for (String key : bindingKeys) {
            String keyWithoutReturnType = key.substring(0, key.lastIndexOf(41) + 1);
            if (!keyWithoutReturnType.equals(roleMethodName + "." + signatureWithoutReturnType)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getRoleMethodSignatures() {
        return this.roleMethodBindings.keySet();
    }

    public BoundClass getRoleClass() {
        return this.roleClass;
    }

    public BoundClass getBaseClass() {
        return this.baseClass;
    }

    public String getRoleClassName() {
        return this.roleClass.getName();
    }

    public String getBaseClassName() {
        return this.baseClass.getName();
    }

    public List<String[]> getBaseSignatures() {
        LinkedList<String[]> result = new LinkedList<String[]>();
        List<MethodBinding> baseMethodBindingList = this.getBaseMethodBindings();
        for (MethodBinding mb : baseMethodBindingList) {
            result.add(new String[]{mb.getBaseMethodName(), mb.getBaseMethodSignature()});
        }
        return result;
    }

    public boolean equals(RoleBaseBinding rbb) {
        return this.roleClass.getName().equals(rbb.getRoleClassName()) && this.baseClass.getName().equals(rbb.getBaseClassName());
    }

    public String toString() {
        StringBuilder out = new StringBuilder(64);
        out.append(this.roleClass.getName());
        out.append(" <-> ");
        out.append(this.baseClass.getName());
        out.append("\nmethod bindings:\n");
        List<MethodBinding> mbsList = this.getBaseMethodBindings();
        for (MethodBinding mb : mbsList) {
            out.append("\n");
            out.append(mb.getBaseMethodName());
            out.append(".");
            out.append(mb.getBaseMethodSignature());
            out.append(":");
            out.append(mb.toString());
        }
        return out.toString();
    }
}

