/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.wizards.listeners;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.refactoring.TypeContextChecker;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.SuperInterfaceSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.core.search.OTSearchEngine;
import org.eclipse.objectteams.otdt.internal.ui.wizards.NewTeamWizardPage;
import org.eclipse.objectteams.otdt.internal.ui.wizards.NewTypeWizardPage;
import org.eclipse.objectteams.otdt.internal.ui.wizards.OTNewWizardMessages;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;
import org.eclipse.objectteams.otdt.ui.dialogs.TeamSelectionDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public abstract class NewTypeWizardPageListener
implements IStringButtonAdapter,
IDialogFieldListener,
IListAdapter<Object> {
    protected static final int CONTAINER = 1;
    protected static final int PACKAGE = 2;
    protected static final int ENCLOSINGTYPE = 3;
    protected static final int NAME = 4;
    protected static final int SUPERTYPE = 5;
    protected static final int SUPERINTERFACES = 6;
    protected static final int ENCLOSINGTYPESELECTION = 7;
    protected IStatus _packageStatus = new StatusInfo();
    protected IStatus _enclosingTeamStatus = new StatusInfo();
    protected IStatus _typeNameStatus = new StatusInfo();
    protected IStatus _modifierStatus = new StatusInfo();
    protected IStatus _superTypeStatus = new StatusInfo();
    protected IStatus _superInterfacesStatus = new StatusInfo();
    private NewTypeWizardPage _observedPage;

    public NewTypeWizardPageListener(NewTypeWizardPage observedPage) {
        this._observedPage = observedPage;
    }

    public void changeControlPressed(DialogField field) {
        this.handleChangeControlPressed(field);
    }

    public void dialogFieldChanged(DialogField field) {
        if (field == this._observedPage.getTypeNameDialogField()) {
            this._observedPage.publicTypeNameChanged();
        }
        int changedElement = this.getChangedElement(field);
        this.performReviews(changedElement);
        this.updateStatus();
    }

    public void doubleClicked(ListDialogField field) {
    }

    public void customButtonPressed(ListDialogField field, int index) {
        this.chooseSuperInterfaces(field);
    }

    public void selectionChanged(ListDialogField field) {
    }

    protected NewTypeWizardPage getObservedPage() {
        return this._observedPage;
    }

    protected int getChangedElement(DialogField field) {
        int change = 0;
        if (field == this.getObservedPage().getPackageDialogField()) {
            change = 2;
        } else if (field == this.getObservedPage().getEnclosingTypeDialogField()) {
            change = 3;
        } else if (field != this.getObservedPage().getInlineSelectionDialogField()) {
            if (field == this.getObservedPage().getTypeNameDialogField()) {
                change = 4;
            } else if (field == this.getObservedPage().getSuperTypeDialogField()) {
                change = 5;
            } else if (field == this.getObservedPage().getSuperInterfacesDialogField()) {
                change = 6;
            } else if (field == this.getObservedPage().getEnclosingTypeSelectionField()) {
                change = 7;
            }
        }
        return change;
    }

    protected void performReviews(int change) {
        switch (change) {
            case 1: {
                this._packageStatus = this.validatePackage();
                this._enclosingTeamStatus = this.validateEnclosingType();
                this._typeNameStatus = this.validateTypeName();
                this._superTypeStatus = this.validateSuperType();
                this._superInterfacesStatus = this.validateSuperInterfaces();
                break;
            }
            case 2: {
                this._packageStatus = this.validatePackage();
                this._enclosingTeamStatus = this.validateEnclosingType();
                this._typeNameStatus = this.validateTypeName();
                break;
            }
            case 3: {
                this._enclosingTeamStatus = this.validateEnclosingType();
                this._typeNameStatus = this.validateTypeName();
                break;
            }
            case 7: {
                this._packageStatus = this.validatePackage();
                this._enclosingTeamStatus = this.validateEnclosingType();
                this._typeNameStatus = this.validateTypeName();
                break;
            }
            case 4: {
                this._typeNameStatus = this.validateTypeName();
                break;
            }
            case 5: {
                this._superTypeStatus = this.validateSuperType();
            }
            case 6: {
                this.validateSuperInterfaces();
            }
        }
    }

    protected void handleChangeControlPressed(DialogField field) {
        IType supertype;
        if (field == this.getObservedPage().getPackageDialogField()) {
            IPackageFragment pack = this.choosePackage();
            if (pack != null) {
                this.getObservedPage().setPackageFragmentName(pack.getElementName());
            }
        } else if (field == this.getObservedPage().getEnclosingTypeDialogField()) {
            IType type = this.chooseEnclosingType();
            if (type != null) {
                String packageName = type.getPackageFragment().getElementName();
                this.getObservedPage().setPackageFragmentName(packageName);
                String qualifiedTeam = type.getFullyQualifiedName('.');
                this.getObservedPage().setEnclosingTypeName(qualifiedTeam);
            }
        } else if (field == this.getObservedPage().getSuperTypeDialogField() && (supertype = this.chooseSuperType()) != null) {
            this.getObservedPage().setSuperTypeName(supertype.getFullyQualifiedName('.'));
        }
    }

    private IPackageFragment choosePackage() {
        IPackageFragmentRoot froot = this.getObservedPage().getPackageFragmentRoot();
        Object[] packages = null;
        try {
            if (froot != null && froot.exists()) {
                packages = froot.getChildren();
            }
        }
        catch (JavaModelException ex) {
            OTDTUIPlugin.logException(null, ex);
        }
        if (packages == null) {
            packages = new IJavaElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getObservedPage().getShell(), (ILabelProvider)new JavaElementLabelProvider(18));
        dialog.setIgnoreCase(false);
        dialog.setTitle(NewWizardMessages.NewTypeWizardPage_ChoosePackageDialog_title);
        dialog.setMessage(NewWizardMessages.NewTypeWizardPage_ChoosePackageDialog_description);
        dialog.setEmptyListMessage(NewWizardMessages.NewTypeWizardPage_ChoosePackageDialog_empty);
        dialog.setElements(packages);
        IPackageFragment pack = this.getObservedPage().getPackageFragment();
        if (pack != null) {
            dialog.setInitialSelections(new Object[]{pack});
        }
        if (dialog.open() == 0) {
            return (IPackageFragment)dialog.getFirstResult();
        }
        return null;
    }

    public static IType chooseTeam(IJavaElement searchScope, Shell shell, IWizardContainer container, String dialogTitle, String dialogMessage, String filter) {
        IJavaSearchScope scope = OTSearchEngine.createOTSearchScope((IJavaElement[])new IJavaElement[]{searchScope}, (boolean)true);
        TeamSelectionDialog dialog = new TeamSelectionDialog(shell, (IRunnableContext)container, scope);
        dialog.setTitle(dialogTitle);
        dialog.setMessage(dialogMessage);
        dialog.setFilter(filter);
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    protected abstract IType chooseSuperType();

    private void chooseSuperInterfaces(ListDialogField field) {
        IPackageFragmentRoot root = this.getObservedPage().getPackageFragmentRoot();
        if (root == null) {
            return;
        }
        Shell parent = this.getObservedPage().getShell();
        IWizardContainer context = this.getObservedPage().getWizard().getContainer();
        NewTypeWizardPage page = this.getObservedPage();
        IJavaProject root2 = root.getJavaProject();
        SuperInterfaceSelectionDialog dialog = new SuperInterfaceSelectionDialog(parent, (IRunnableContext)context, (org.eclipse.jdt.ui.wizards.NewTypeWizardPage)page, root2);
        dialog.setTitle(NewWizardMessages.NewTypeWizardPage_InterfacesDialog_class_title);
        dialog.setMessage(NewWizardMessages.NewTypeWizardPage_InterfacesDialog_message);
        dialog.open();
    }

    protected IType chooseEnclosingType() {
        return this.getObservedPage().chooseEnclosingType();
    }

    protected boolean hasErrorStatus(IStatus[] stati) {
        int i = 0;
        while (i < stati.length) {
            if (stati[i] != null && stati[i].getSeverity() == 4) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public abstract IStatus[] getRelevantStates(boolean var1);

    protected void updateStatus() {
        this.getObservedPage().updateStatus(this.getRelevantStates(false));
    }

    protected IStatus validateTypeName() {
        IType member;
        ICompilationUnit cu;
        StatusInfo status = new StatusInfo();
        String typeName = this.getObservedPage().getTypeName();
        if (typeName.length() == 0) {
            status.setError(NewWizardMessages.NewTypeWizardPage_error_EnterTypeName);
            return status;
        }
        if (typeName.indexOf(46) != -1) {
            status.setError(NewWizardMessages.NewTypeWizardPage_error_QualifiedName);
            return status;
        }
        IStatus val = NewTypeWizardPage.validateJavaTypeName(typeName, this.getObservedPage().getJavaProject());
        if (val.getSeverity() == 4) {
            status.setError(Messages.format((String)NewWizardMessages.NewTypeWizardPage_error_InvalidTypeName, (Object)val.getMessage()));
            return status;
        }
        if (val.getSeverity() == 2) {
            status.setWarning(Messages.format((String)NewWizardMessages.NewTypeWizardPage_warning_TypeNameDiscouraged, (Object)val.getMessage()));
        }
        IType enclosingTeam = this.getObservedPage().getEnclosingType();
        IPackageFragment pack = this.getObservedPage().getPackageFragment();
        if (pack == null && enclosingTeam != null) {
            pack = this.getTeamPackage(enclosingTeam);
        }
        if (pack != null && (cu = pack.getCompilationUnit(String.valueOf(typeName) + ".java")).getResource().exists()) {
            status.setError(NewWizardMessages.NewTypeWizardPage_error_TypeNameExists);
            return status;
        }
        if (enclosingTeam != null && (member = enclosingTeam.getType(typeName)).exists()) {
            status.setError(NewWizardMessages.NewTypeWizardPage_error_TypeNameExists);
            return status;
        }
        this.validateSuperClass(status);
        return status;
    }

    private IPackageFragment getTeamPackage(IType teamType) {
        String enclosingTeamName = teamType.getTypeQualifiedName('/');
        try {
            IPath teamPackagePath = teamType.getPackageFragment().getPath();
            teamPackagePath = teamPackagePath.append(enclosingTeamName);
            return teamType.getJavaProject().findPackageFragment(teamPackagePath);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    protected IStatus validateEnclosingType() {
        StatusInfo status = new StatusInfo();
        this.getObservedPage().setEnclosingType(null, true);
        IPackageFragmentRoot root = this.getObservedPage().getPackageFragmentRoot();
        if (root == null) {
            status.setError("");
            return status;
        }
        String enclName = this.getObservedPage().getEnclosingTypeName();
        if (enclName.trim().length() == 0) {
            this.handleEnclosingTypeDialogFieldIsEmpty(status);
            return status;
        }
        if (this._observedPage instanceof NewTeamWizardPage) {
            this._observedPage.getPackageDialogField().setEnabled(false);
        }
        try {
            IType type = root.getJavaProject().findType(enclName);
            if (type == null) {
                status.setError(NewWizardMessages.NewTypeWizardPage_error_EnclosingTypeNotExists);
            } else if (type.getCompilationUnit() == null) {
                status.setError(NewWizardMessages.NewTypeWizardPage_error_EnclosingNotInCU);
            } else if (!JavaModelUtil.isEditable((ICompilationUnit)type.getCompilationUnit())) {
                status.setError(NewWizardMessages.NewTypeWizardPage_error_EnclosingNotEditable);
            } else if (type.equals(this.getObservedPage().getSuperType())) {
                status.setError(OTNewWizardMessages.NewTypeWizardPage_same_enclosing_and_super_error);
            }
            if (status.isError()) {
                return status;
            }
            this.getObservedPage().setEnclosingType(type, true);
            IPackageFragmentRoot enclosingRoot = JavaModelUtil.getPackageFragmentRoot((IJavaElement)type);
            if (!enclosingRoot.equals(root)) {
                status.setWarning(NewWizardMessages.NewTypeWizardPage_warning_EnclosingNotInSourceFolder);
            }
            this.validateSuperClass(status);
            this.getObservedPage().getInlineSelectionDialogField().setEnabled(true);
            return status;
        }
        catch (JavaModelException ex) {
            status.setError(NewWizardMessages.NewTypeWizardPage_error_EnclosingTypeNotExists);
            OTDTUIPlugin.logException("", ex);
            return status;
        }
    }

    protected void handleEnclosingTypeDialogFieldIsEmpty(StatusInfo status) {
        this.validateSuperClass(status);
    }

    protected IStatus validatePackage() {
        return new StatusInfo();
    }

    protected IStatus validateSuperInterfaces() {
        StatusInfo status = new StatusInfo();
        IPackageFragmentRoot root = this.getObservedPage().getPackageFragmentRoot();
        this.getObservedPage().getSuperInterfacesDialogField().enableButton(0, root != null);
        if (root != null) {
            List<String> elements = this.getObservedPage().getSuperInterfaces();
            int nElements = elements.size();
            int i = 0;
            while (i < nElements) {
                String intfname = elements.get(i);
                Type type = TypeContextChecker.parseSuperInterface((String)intfname);
                if (type == null) {
                    status.setError(Messages.format((String)NewWizardMessages.NewTypeWizardPage_error_InvalidSuperInterfaceName, (Object)intfname));
                    return status;
                }
                ++i;
            }
        }
        return status;
    }

    protected IStatus validateSuperType() {
        StatusInfo status = new StatusInfo();
        IPackageFragmentRoot root = this.getObservedPage().getPackageFragmentRoot();
        this.getObservedPage().getSuperTypeDialogField().enableButton(root != null);
        this.getObservedPage().setSuperType(null);
        String superTypeName = this.getObservedPage().getSuperTypeName();
        if (superTypeName.trim().length() == 0) {
            return status;
        }
        IStatus val = NewTypeWizardPage.validateJavaTypeName(superTypeName, this.getObservedPage().getJavaProject());
        if (val.getSeverity() == 4) {
            status.setError(NewWizardMessages.NewTypeWizardPage_error_InvalidSuperClassName);
            return status;
        }
        if (root != null) {
            try {
                Type type = TypeContextChecker.parseSuperClass((String)superTypeName);
                if (type == null) {
                    status.setError(NewWizardMessages.NewTypeWizardPage_error_InvalidSuperClassName);
                    return status;
                }
                IType iType = this.resolveSuperTypeName(root.getJavaProject(), superTypeName);
                if (iType == null) {
                    status.setError(NewWizardMessages.NewTypeWizardPage_error_InvalidSuperClassName);
                    return status;
                }
                if (iType.equals(this.getObservedPage().getEnclosingType())) {
                    status.setError(OTNewWizardMessages.NewTypeWizardPage_same_enclosing_and_super_error);
                }
                this.getObservedPage().setSuperType(iType);
                this.validateSuperClass(status);
            }
            catch (JavaModelException e) {
                status.setError(NewWizardMessages.NewTypeWizardPage_error_InvalidSuperClassName);
                JavaPlugin.log((Throwable)e);
            }
        } else {
            status.setError("");
        }
        return status;
    }

    private IType resolveSuperTypeName(IJavaProject jproject, String supertypeName) throws JavaModelException {
        if (!jproject.exists()) {
            return null;
        }
        IType supertype = null;
        if (this.getObservedPage().getEnclosingType() != null && this.getObservedPage().isInlineTypeSelected()) {
            IType enclosingType = this.getObservedPage().getEnclosingType();
            String[][] res = enclosingType.resolveType(supertypeName);
            if (res != null && res.length > 0) {
                supertype = jproject.findType(res[0][0], res[0][1]);
            }
        } else {
            IPackageFragment currPack = this.getObservedPage().getPackageFragment();
            if (currPack != null) {
                String packName = currPack.getElementName();
                if (!currPack.isDefaultPackage()) {
                    supertype = jproject.findType(packName, supertypeName);
                }
                if (supertype == null && !"java.lang".equals(packName)) {
                    supertype = jproject.findType("java.lang", supertypeName);
                }
            }
            if (supertype == null) {
                supertype = jproject.findType(supertypeName);
            }
        }
        return supertype;
    }

    public void handleContainerChanged() {
        this.performReviews(1);
        this.updateStatus();
    }

    void validateSuperClass(StatusInfo status) {
        IType superType = this.getObservedPage().getSuperType();
        IType enclosingType = this.getObservedPage().getEnclosingType();
        String newRoleName = this.getObservedPage().getTypeName().trim();
        IOTType superTypeOTElem = null;
        if (superType == null) {
            return;
        }
        superTypeOTElem = OTModelManager.getOTElement((IType)superType);
        try {
            if (superTypeOTElem != null && superTypeOTElem.isRole()) {
                this.checkSuperRoleType(status, enclosingType, superType, newRoleName);
                if (status.isError()) {
                    return;
                }
            }
        }
        catch (JavaModelException ex) {
            ex.printStackTrace();
        }
    }

    private void checkSuperRoleType(StatusInfo status, IType enclosingType, IType superType, String newRoleName) throws JavaModelException {
        if (!this.isTypeToBeCreatedARole()) {
            status.setError(OTNewWizardMessages.NewTypeWizardPage_super_of_regular_is_role_error);
            return;
        }
        if (!this.isSuperRolesTeamContainedInEnclosingTypesHierarchy(enclosingType, superType)) {
            status.setError(OTNewWizardMessages.NewRoleWizardPage_super_is_role_of_different_team_error);
            return;
        }
        if (newRoleName.equals(superType.getElementName())) {
            status.setError(OTNewWizardMessages.NewRoleWizardPage_explicit_and_implicit_subclassing_error);
            return;
        }
        if (this.hasSuperroleOverridingImplicitSubrole(enclosingType, superType)) {
            status.setError(OTNewWizardMessages.NewRoleWizardPage_super_is_overridden_error);
            return;
        }
    }

    private void checkImplicitRoleHierarchyForExplicitSuperClass(StatusInfo status, IType enclosingType, IType superType, String newRoleName) throws JavaModelException {
        IType explicitSuperclassOfImplicitSuperrole = this.getExplicitSuperclassOfImplicitSuperrole(enclosingType, newRoleName);
        if (explicitSuperclassOfImplicitSuperrole != null) {
            if (explicitSuperclassOfImplicitSuperrole.getFullyQualifiedName().equals(superType.getFullyQualifiedName())) {
                status.setInfo(Messages.format((String)OTNewWizardMessages.NewRoleWizardPage_already_has_this_super, (Object)superType.getFullyQualifiedName()));
                return;
            }
            ITypeHierarchy superTypeHierarchy = superType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            if (!superTypeHierarchy.contains(explicitSuperclassOfImplicitSuperrole)) {
                status.setError(Messages.format((String)OTNewWizardMessages.NewRoleWizardPage_incompatible_supers_error, (Object)explicitSuperclassOfImplicitSuperrole.getFullyQualifiedName()));
                return;
            }
        }
    }

    private IType getExplicitSuperclassOfImplicitSuperrole(IType teamType, String roleSimpleName) throws JavaModelException {
        IOTType teamOTElem = OTModelManager.getOTElement((IType)teamType);
        if (teamOTElem == null || !teamOTElem.isTeam()) {
            return null;
        }
        ITypeHierarchy teamSuperHierarchy = teamType.newSupertypeHierarchy(null);
        IType[] superTeams = teamSuperHierarchy.getAllSuperclasses(teamType);
        IType curRole = null;
        ITypeHierarchy explicitRoleSuperHierarchy = null;
        int idx = 0;
        while (idx < superTeams.length) {
            curRole = superTeams[idx].getType(roleSimpleName);
            if (curRole.exists() && (explicitRoleSuperHierarchy = curRole.newSupertypeHierarchy(null)).getSuperclass(curRole) != null) {
                return explicitRoleSuperHierarchy.getSuperclass(curRole);
            }
            ++idx;
        }
        return null;
    }

    private boolean isTypeToBeCreatedARole() {
        IType enclosingType = this.getObservedPage().getEnclosingType();
        if (enclosingType == null) {
            return false;
        }
        IOTType enclosingTypeOTElem = OTModelManager.getOTElement((IType)enclosingType);
        return enclosingTypeOTElem != null && enclosingTypeOTElem.isTeam();
    }

    private boolean isSuperRolesTeamContainedInEnclosingTypesHierarchy(IType enclosingTeam, IType superRole) throws JavaModelException {
        IType teamOfSuperType;
        ITypeHierarchy teamHierarchy = enclosingTeam.newSupertypeHierarchy(null);
        return teamHierarchy.contains(teamOfSuperType = superRole.getDeclaringType());
    }

    private boolean hasSuperroleOverridingImplicitSubrole(IType enclosingTeam, IType superRole) throws JavaModelException {
        IType teamOfSuperrole = superRole.getDeclaringType();
        if (enclosingTeam.getFullyQualifiedName().equals(teamOfSuperrole.getFullyQualifiedName())) {
            return false;
        }
        ITypeHierarchy enclosingTeamHierarchy = enclosingTeam.newSupertypeHierarchy(null);
        IType[] superTeams = enclosingTeamHierarchy.getAllSuperclasses(enclosingTeam);
        IType implicitSubrole = null;
        int idx = 0;
        IType curTeam = superTeams[idx];
        while (!curTeam.getFullyQualifiedName().equals(teamOfSuperrole.getFullyQualifiedName())) {
            implicitSubrole = curTeam.getType(superRole.getElementName());
            if (implicitSubrole.exists()) {
                return true;
            }
            curTeam = superTeams[++idx];
        }
        return false;
    }
}

