/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.hyperlinks;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.sandbox.ui.hyperlinks.IResourceHyperlinkExtension;

public abstract class AbstractResourceHyperlinkExtension
implements IResourceHyperlinkExtension {
    protected static final String DEFAULT_QUALIFIED_NAME = "((\\w(\\w|\\.)*\\w)|\\w)";

    private IHyperlink extractHyperlink(int regionOffset, Matcher m) {
        int start = m.start();
        int end = m.end();
        if (end == -1) {
            end = m.group().length();
        }
        try {
            String resourceName = this.extractResourceName(m.group());
            Region region = new Region(start += regionOffset, (end += regionOffset) - start);
            return this.createHyperlinkInstance((IRegion)region, resourceName);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    protected String extractResourceName(String matchedText) {
        return matchedText.substring(matchedText.lastIndexOf(" ") + 1);
    }

    @Override
    public IHyperlink[] findHyperlink(String text, int lineOffset, int regionOffset) {
        ArrayList<IHyperlink> hyperlinksFound = new ArrayList<IHyperlink>();
        Matcher m = this.getMatcherFor(text);
        while (m.find()) {
            IHyperlink link;
            if (lineOffset < m.start() || lineOffset >= m.end() || !this.isResourceExists(this.extractResourceName(m.group())) || (link = this.extractHyperlink(regionOffset, m)) == null) continue;
            hyperlinksFound.add(link);
        }
        if (hyperlinksFound.size() > 0) {
            return hyperlinksFound.toArray(new IHyperlink[1]);
        }
        return null;
    }

    protected abstract IHyperlink createHyperlinkInstance(IRegion var1, String var2);

    private Matcher getMatcherFor(String text) {
        return Pattern.compile(this.getResourceExpressions(), 2).matcher(text);
    }

    protected abstract String getResourceExpressions();

    protected abstract boolean isResourceExists(String var1);
}

