/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.search.ui;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.internal.sandbox.search.ui.ContentProvider;
import org.eclipse.mylyn.internal.sandbox.search.ui.DesktopSearchActionGroup;
import org.eclipse.mylyn.internal.sandbox.search.ui.DesktopSearchLabelProvider;
import org.eclipse.mylyn.internal.sandbox.search.ui.DesktopSearchResult;
import org.eclipse.mylyn.internal.sandbox.search.ui.DesktopSearchResultEvent;
import org.eclipse.mylyn.internal.sandbox.search.ui.Messages;
import org.eclipse.mylyn.internal.sandbox.search.ui.OpenFileAction;
import org.eclipse.mylyn.internal.sandbox.search.ui.SearchResultLabelProvider;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.part.Page;

public class DesktopSearchResultPage
extends Page
implements ISearchResultPage {
    private String id;
    private DesktopSearchResult searchResult;
    private TreeViewer viewer;
    private ISearchResultViewPart viewPart;
    private Control control;
    private ISearchResultListener listener;
    private MenuManager menu;
    private DesktopSearchActionGroup actionGroup;

    public Object getUIState() {
        return this.viewer == null ? null : this.viewer.getSelection();
    }

    public void setInput(ISearchResult search, Object uiState) {
        if (this.listener == null) {
            this.listener = new ISearchResultListener(){

                public void searchResultChanged(SearchResultEvent e) {
                    DesktopSearchResultEvent event = (DesktopSearchResultEvent)e;
                    DesktopSearchResultPage.this.changed(event);
                }
            };
        }
        if (this.searchResult != null) {
            this.searchResult.removeListener(this.listener);
        }
        this.searchResult = (DesktopSearchResult)search;
        if (this.searchResult != null) {
            this.searchResult.addListener(this.listener);
        }
        this.viewer.setInput((Object)this.searchResult);
        if (uiState instanceof ISelection) {
            this.viewer.setSelection((ISelection)uiState);
        }
        this.getViewPart().updateLabel();
    }

    private void changed(DesktopSearchResultEvent event) {
        final Control control = this.getControl();
        if (!control.isDisposed()) {
            control.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!control.isDisposed()) {
                        DesktopSearchResultPage.this.getViewPart().updateLabel();
                    }
                }
            });
        }
    }

    public void setViewPart(ISearchResultViewPart part) {
        this.viewPart = part;
        this.actionGroup = new DesktopSearchActionGroup((IViewPart)part);
    }

    public ISearchResultViewPart getViewPart() {
        return this.viewPart;
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(container, 770);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DesktopSearchLabelProvider(new SearchResultLabelProvider()));
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.control = container;
        this.createMenu();
        this.viewer.getControl().setMenu(this.menu.createContextMenu(this.viewer.getControl()));
        this.getSite().registerContextMenu(this.getViewPart().getViewSite().getId(), this.menu, (ISelectionProvider)this.viewer);
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    OpenFileAction openFileAction = new OpenFileAction(DesktopSearchResultPage.this.getSite().getPage());
                    openFileAction.selectionChanged(structuredSelection);
                    if (openFileAction.isEnabled()) {
                        openFileAction.run();
                    }
                }
            }
        });
        this.getViewPart().updateLabel();
    }

    private void createMenu() {
        this.menu = new MenuManager("#PopUp");
        this.menu.setRemoveAllWhenShown(true);
        this.menu.setParent((IContributionManager)this.getSite().getActionBars().getMenuManager());
        this.menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DesktopSearchResultPage.this.fillContextMenu(manager);
            }
        });
    }

    protected void fillContextMenu(IMenuManager menu) {
        this.createContextMenuGroups(menu);
        this.actionGroup.setContext(new ActionContext(this.getSite().getSelectionProvider().getSelection()));
        this.actionGroup.fillContextMenu(menu);
        this.getViewPart().fillContextMenu(menu);
    }

    private void createContextMenuGroups(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new GroupMarker("group.goto"));
        menu.add((IContributionItem)new GroupMarker("group.open"));
        menu.add((IContributionItem)new Separator("group.show"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new GroupMarker("group.removeMatches"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new GroupMarker("group.generate"));
        menu.add((IContributionItem)new Separator("group.search"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.viewerSetup"));
        menu.add((IContributionItem)new Separator("group.properties"));
    }

    public Control getControl() {
        return this.control;
    }

    public void dispose() {
        if (this.actionGroup != null) {
            this.actionGroup.dispose();
            this.actionGroup = null;
        }
        super.dispose();
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public String getLabel() {
        if (this.searchResult != null) {
            return this.searchResult.getLabel();
        }
        return Messages.DesktopSearchResultPage_EmptyLabel;
    }
}

