/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.planner;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.mylyn.commons.workbench.forms.DatePicker;
import org.eclipse.mylyn.commons.workbench.forms.DateSelectionDialog;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ReminderCellEditor
extends DialogCellEditor {
    private Date reminderDate;
    private DateSelectionDialog dialog;
    private final String formatString = "dd-MMM-yyyy";
    private final SimpleDateFormat format = new SimpleDateFormat("dd-MMM-yyyy", Locale.ENGLISH);

    public ReminderCellEditor(Composite parent) {
        super(parent, 0);
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        Calendar initialCalendar = null;
        String value = (String)super.getValue();
        if (value != null) {
            try {
                Date tempDate = this.format.parse(value);
                if (tempDate != null) {
                    initialCalendar = Calendar.getInstance();
                    initialCalendar.setTime(tempDate);
                }
            }
            catch (ParseException parseException) {}
        }
        Calendar newCalendar = Calendar.getInstance();
        if (initialCalendar != null) {
            newCalendar.setTime(initialCalendar.getTime());
        }
        this.dialog = new DateSelectionDialog(cellEditorWindow.getShell(), newCalendar, DatePicker.TITLE_DIALOG, true, TasksUiPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.end.hour"));
        int dialogResponse = this.dialog.open();
        this.reminderDate = dialogResponse == 1 ? (initialCalendar != null ? initialCalendar.getTime() : null) : this.dialog.getDate();
        String result = null;
        if (this.reminderDate != null) {
            result = this.format.format(this.reminderDate);
        }
        return result;
    }

    public Date getReminderDate() {
        return this.reminderDate;
    }

    protected void doSetFocus() {
        this.reminderDate = null;
        super.doSetFocus();
    }
}

